  @  /*~!hsearch.c*/  +/* Name:  hsearch.c Part No.: _______-____r +  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     !#ident	"@(#)nbclib:hsearch.c	1.1" !           @  /* Compile time switches:     0   MULT - use a multiplicative hashing function. 0 @   DIV - use the remainder mod table size as a hashing function. @ 5   CHAINED - use a linked list to resolve collisions. 5 4   OPEN - use open addressing to resolve collisions. 4 B   BRENT - use Brent's modification to improve the OPEN algorithm. B 7   SORTUP - CHAINED list is sorted in increasing order. 7 9   SORTDOWN - CHAINED list is sorted in decreasing order. 9 7   START - CHAINED list with entries appended at front. 7 9   DRIVER - compile in a main program to drive the tests. 9 6   DEBUG - compile some debugging printout statements. 6 +   USCR - user supplied comparison routine. + */     #include <stdio.h>     #define SUCCEED		0  #define FAIL		1    @  #define TRUE		1  #define FALSE		0  #define repeat		for(;;)  #define until(A)	if(A) break;     #ifdef OPEN  #    undef CHAINED  #else  #ifndef CHAINED  #    define OPEN  #endif  #endif     #ifdef MULT  #    undef DIV  #else  #ifndef DIV  #    define MULT  #endif  #endif     #ifdef START  #    undef SORTUP  #    undef SORTDOWN  #else  
#ifdef SORTUP 
 #    undef SORTDOWN  #endif  #endif     #ifdef USCR  /#    define COMPARE(A, B) (* hcompar)((A), (B)) /      extern int (* hcompar)();  #else  *#    define COMPARE(A, B) strcmp((A), (B)) * #endif     #ifdef MULT  B#    define SHIFT ((bitsper * sizeof(int)) - m) /* Shift factor */ B                                                           @  A#    define FACTOR 035761254233	/* Magic multiplication factor */ A :#    define HASH hashm		/* Multiplicative hash function */ : 6#    define HASH2 hash2m	/* Secondary hash function */ 6 0static unsigned int bitsper;	/* Bits per byte */ 0 static unsigned int hashm();  static unsigned int hash2m();  #else  
#ifdef DIV 
 6#    define HASH hashd		/* Division hashing routine */ 6 5#    define HASH2(A) 1		/* Secondary hash function */ 5 static unsigned int hashd();  #endif  #endif     typedef enum {  !    FIND,		/* Find, if present */ ! +    ENTER		/* Find; enter if not present */ + 	} ACTION; 	 typedef char *POINTER;  -typedef struct entry {	/* Hash table entry */ -     POINTER key;      POINTER data;  } ENTRY;                   @  #ifdef CHAINED  >typedef struct node {	/* Part of the linked list of entries */ > 	ENTRY item;  	struct node *next;  } NODE;  typedef NODE *TABELEM;  8static NODE **table;	/* The address of the hash table */ 8 static ENTRY *build();  #else  #ifdef OPEN  Etypedef ENTRY TABELEM;	/* What the table contains (TABle ELEMents) */ E :static TABELEM *table;	/* The address of the hash table */ : Dstatic unsigned int count = 0;	/* Number of entries in hash table */ D #endif  #endif     8static unsigned int length;	/* Size of the hash table */ 8 2static unsigned int m;		/* Log base 2 of length */ 2 ;static unsigned int prcnt;	/* Number of probes this item */ ;    extern void free();  extern int printf(), fprintf();                       @  ,extern char *malloc(), *calloc(), *strcpy(); ,    int hcreate();  void hdestroy();  ENTRY *hsearch();  static unsigned int crunch();     
#ifdef DRIVER 
 static void hdump();     main()  {  0    char line[80];	/* Room for the input line */ 0 $    int i = 0;		/* Data generator */ $ (    ENTRY *res;		/* Result of hsearch */ ( !    ENTRY *new;		/* Test entry */ !        if(hcreate(5))  ,	printf("Length = %u, m = %u\n", length, m); , 
    else { 
 "	fprintf(stderr, "Out of core\n"); " 	exit(FAIL);      }         repeat {  		hdump(); 	 	printf("Enter a probe: ");  "	until (EOF == scanf("%s", line)); " #ifdef DEBUG  	printf("%s, ", line);  '	printf("division: %d, ", hashd(line)); '                                        @  -	printf("multiplication: %d\n", hashm(line)); - #endif  '	new = (ENTRY *) malloc(sizeof(ENTRY)); ' 	if(new == NULL) {  '	    fprintf(stderr, "Out of core \n"); ' 	    exit(FAIL);  	}  	else {  4	    new->key = malloc((unsigned) strlen(line) + 1); 4 	    if(new->key == NULL) {  $		fprintf(stderr, "Out of core \n"); $ 
		exit(FAIL); 
 	    }  	    strcpy(new->key, line);  %	    new->data = malloc(sizeof(int)); % 	    if(new->data == NULL) {  $		fprintf(stderr, "Out of core \n"); $ 
		exit(FAIL); 
 	    }  	    *new->data = i++;  	}  	res = hsearch(*new, ENTER);  9	printf("The number of probes required was %d\n", prcnt); 9 	if(res == (ENTRY *) 0)  	    printf("Table is full\n");  	else {  	    printf("Success: ");        @  <	    printf("Key = %s, Value = %d\n", res->key, *res->data); < 	}      }      exit(SUCCEED);  }  #endif     int  =hcreate(size)		/* Create a hash table no smaller than size */ = ,int size;		/* Minimum size for hash table */ , {  5    unsigned int unsize;	/* Holds the shifted size */ 5        if(size <= 0)  	return(FALSE);     @    unsize = size;	/* +1 for empty table slot; -1 for ceiling */ @ /    length = 1;		/* Maximum entries in tabbe */ /     m = 0;		/* Log2 length */      while(unsize) {  	unsize >>= 1;  	length <<= 1;  	m++;      }     8    table = (TABELEM *) calloc(length, sizeof(TABELEM)); 8     return(table != NULL);  }     void  6hdestroy()	/* Reset the module to its initial state */ 6 {       @      free((POINTER) table);  #ifdef OPEN      count = 0;  #endif  }     #ifdef OPEN  B/* Hash search of a fixed-capacity table.  Open addressing used to B @   resolve collisions.  Algorithm modified from Knuth, Volume 3, @ @   section 6.4, algorithm D.  Labels flag corresponding actions. @ */     ENTRY  C*hsearch(item, action)	/* Find or insert the item into the table */ C /ENTRY item;		/* Item to be inserted or found */ / #ACTION action;		/* FIND or ENTER */ # {  )    unsigned int i;	/* Insertion index */ ) 6    unsigned int c;	/* Secondary probe displacement */ 6        prcnt = 1;     	/* D1: */ 	 1    i = HASH(item.key);	/* Primary hash on key */ 1 #ifdef DEBUG      if(action == ENTER)  	printf("hash = %o\n", i);     @  #endif     	/* D2: */ 	 .    if(table[i].key == NULL)	/* Empty slot? */ . 		goto D6; 	 >    else if(COMPARE(table[i].key, item.key) == 0)	/* Match? */ > 	return(&table[i]);     	/* D3: */ 	 A    c = HASH2(item.key);	/* No match => compute secondary hash */ A #ifdef DEBUG      if(action == ENTER)  	printf("hash2 = %o\n", c);  #endif     D4:  4    i = (i + c) % length;	/* Advance to next slot */ 4     prcnt++;     	/* D5: */ 	 .    if(table[i].key == NULL)	/* Empty slot? */ . 		goto D6; 	 >    else if(COMPARE(table[i].key, item.key) == 0)	/* Match? */ > 	return(&table[i]);      else  		goto D4; 	    1D6: if(action == FIND)		/* Insert if requested */ 1 	return((ENTRY *) NULL);                                                 @  /    if(count == (length - 1))	/* Table full? */ / 	return((ENTRY *) 0);     #ifdef BRENT  @/* Brent's variation of the open addressing algorithm.  Do extra @ C   work during insertion to speed retrieval.  May require switching C E   of previously placed items.  Adapted from Knuth, Volume 3, section E A   4.6 and Brent's article in CACM, volume 10, #2, February 1973. A */     C    {   unsigned int p0 = HASH(item.key);   /* First probe index */ C @	unsigned int c0 = HASH2(item.key);  /* Main branch increment */ @ ;	unsigned int r = prcnt - 1; /* Current minimum distance */ ; 7	unsigned int j;         /* Counts along main branch */ 7 <	unsigned int k;         /* Counts along secondary branch */ <                                                  @  <	unsigned int curj;      /* Current best main branch site */ < 7	unsigned int curpos;    /* Current best table index */ 7 2	unsigned int pj;        /* Main branch indices */ 2 A	unsigned int cj;        /* Secondary branch increment distance*/ A =	unsigned int pjk;       /* Secondary branch probe indices */ =    	if(prcnt >= 3) {  A	    for(j = 0; j < prcnt; j++) {   /* Count along main branch */ A :		pj = (p0 + j * c0) % length; /* New main branch index */ : 9		cj = HASH2(table[pj].key); /* Secondary branch incr. */ 9 :		for(k=1; j+k <= r; k++) { /* Count on secondary branch*/ : 9		    pjk = (pj + k * cj) % length; /* Secondary probe */ 9 :		    if(table[pjk].key == NULL) { /* Improvement found */ :                                                  @  0		        r = j + k;	/* Decrement upper bound */ 0 0		        curj = pj;	/* Save main probe index */ 0 3		        curpos = pjk;	/* Save secondeary index */ 3 		    }  		}  	    }  @	    if(r != prcnt - 1) {       /* If an improvement occurred */ @ 8		table[curpos] = table[curj]; /* Old key to new site */ 8 #ifdef DEBUG  6		printf("Switch curpos = %o, curj = %o, oldi = %o\n", 6 		    curj, curpos, i);  #endif  		i = curj;  	    }  	}      }  #endif  4    count++;			/* Increment table occupancy count */ 4 %    table[i] = item;		/* Save item */ % 9    return(&table[i]);		/* Address of item is returned */ 9 }  #endif     #ifdef USCR  #    ifdef DRIVER  
static int 
 
compare(a, b) 
 
POINTER a; 
 
POINTER b; 
 {           @      return(strcmp(a, b));  }     int (* hcompar)() = compare;  
#    endif 
 #endif     #ifdef CHAINED  #    ifdef SORTUP  4#        define STRCMP(A, B) (COMPARE((A), (B)) > 0) 4 	#    else 	 #    ifdef SORTDOWN  4#        define STRCMP(A, B) (COMPARE((A), (B)) < 0) 4 	#    else 	 5#        define STRCMP(A, B) (COMPARE((A), (B)) != 0) 5 
#    endif 
 
#    endif 
    ENTRY  =*hsearch(item, action)	/* Chained search with sorted lists */ = /ENTRY item;		/* Item to be inserted or found */ / #ACTION action;		/* FIND or ENTER */ # {  4    NODE *p;		/* Searches through the linked list */ 4 =    NODE **q;		/* Where to store the pointer to a new NODE */ = (    unsigned int i;	/* Result of hash */ (                                        @  /    int res;		/* Result of string comparison */ /        prcnt = 1;     9    i = HASH(item.key);	/* Table[i] contains list head */ 9    C    if(table[i] == (NODE*)NULL) { /* List has not yet been begun */ C 	if(action == FIND)  	    return((ENTRY *) NULL);  	else  3	    return(build(&table[i], (NODE *) NULL, item)); 3     }  $    else {			/* List is not empty */ $ 	q = &table[i];  	p = table[i];  <	while(p != NULL && (res = STRCMP(item.key, p->item.key))) { < 
	    prcnt++; 
 	    q = &(p->next);  	    p = p->next;  	}     4	if(p != NULL && res == 0)	/* Item has been found */ 4 	    return(&(p->item));  '	else {			/* Item is not yet on list */ ' 	    if(action == FIND)  		return((ENTRY *) NULL);  		    else 	          @  #ifdef START  +		return(build(&table[i], table[i], item)); + #else  		return(build(q, p, item));  #endif  	}      }  }     static ENTRY  *build(last, next, item)  4NODE **last;		/* Where to store in last list item */ 4 )NODE *next;		/* Link to next list item */ ) *ENTRY item;		/* Item to be kept in node */ * {  ,    NODE *p = (NODE *) malloc(sizeof(NODE)); ,        if(p != NULL) {  	p->item = item;  	*last = p;  	p->next = next;  	return(&(p->item));      }      else  	return(NULL);  }  #endif     
#ifdef DIV 
 static unsigned int  )hashd(key)		/* Division hashing scheme */ ) $POINTER key;		/* Key to be hashed */ $ {  !    return(crunch(key) % length); ! }  #else  #ifdef MULT  /*                 @  >    NOTE: The following algorithm only works on machines where > 8    the results of multiplying two integers is the least 8 @    significant part of the double word integer required to hold @ A    the result.  It is adapted from Knuth, Volume 3, section 6.4. A */     static unsigned int  /hashm(key)		/* Multiplication hashing scheme */ / $POINTER key;		/* Key to be hashed */ $ {  >    static int first = TRUE;	/* TRUE on the first call only */ >    ;    if(first) {		/* Compute the number of bits in a byte */ ; /	unsigned char c = ~0;	/* A byte full of 1's */ / 
	bitsper = 0; 
 *	while(c) {		/* Shift until no more 1's */ * 
	    c >>= 1; 
 -	    bitsper++;		/* Count number of shifts */ - 	}  	first = FALSE;      }                        @  A    return((int) (((unsigned) (crunch(key) * FACTOR)) >> SHIFT)); A }     /*  A * Secondary hashing, for use with multiplicitive hashing scheme. A - * Adapted from Knuth, Volume 3, section 6.4. -  */     static unsigned int  ,hash2m(key)		/* Secondary hashing routine */ , 'POINTER key;		/* String to be hashed */ ' {  L    return((int) (((unsigned) ((crunch(key) * FACTOR) << m) >> SHIFT) | 1)); L }  #endif  #endif     static unsigned int  =crunch(key)		/* Convert multicharacter key to unsigned int */ = POINTER key;  {  '    unsigned int sum = 0;	/* Results */ ' $    int s;			/* Length of the key */ $    7    for(s = 0; *key; s++)	/* Simply add up the bytes */ 7 	sum += *key++;         return(sum + s);  }          @  
#ifdef DRIVER 
 static void  1hdump()			/* Dumps loc, data, probe count, key */ 1 {  ,    unsigned int i;	/* Counts table slots */ , #ifdef OPEN  -    unsigned int sum = 0;	/* Counts probes */ - #else  #ifdef CHAINED  (    NODE *a;		/* Current Node on list */ ( #endif  #endif         for(i = 0; i < length; i++)  #ifdef OPEN  	if(table[i].key == NULL)  (	    printf("%o.\t-,\t-,\t(NULL)\n", i); ( 	else {  ?	    unsigned int oldpr = prcnt; /* Save current probe count */ ? 	    hsearch(table[i], FIND);  	    sum += prcnt;  %	    printf("%o.\t%d,\t%d,\t%s\n", i, % '		*table[i].data, prcnt, table[i].key); ' 	    prcnt = oldpr;  	}  '    printf("Total probes = %d\n", sum); ' #else  #ifdef CHAINED  	if(table[i] == NULL)   @  (	    printf("%o.\t-,\t-,\t(NULL)\n", i); ( 	else {  	    printf("%o.", i);  .	    for(a = table[i]; a != NULL; a = a->next) .  		printf("\t%d,\t%#0.4x,\t%s\n",   %		    *a->item.data, a, a->item.key); % 	}  #endif  #endif  }  #endif                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                