  @  /*~!alloca.c*/  */* Name:  alloca.c Part No.: _______-____r *  *  - * Copyright 1991 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:alloca.c	1.1"                @  O/* Written  3:08 am  Jan 26, 1986 by gwyn@brl-tgr.UUCP in ccvaxa:net.sources */ O //* ---------- "portable alloca()" ---------- */ / /*  9	alloca -- (mostly) portable public-domain implementation 9    	last edit:	86/01/26	D A Gwyn     :	This implementation of the PWB library alloca() function, : :	which is used to allocate space off the run-time stack so : 8	that it is automatically reclaimed upon procedure exit, 8 ;	was inspired by discussions with J. Q. Johnson of Cornell. ;    7	It should work under any C implementation that uses an 7 7	actual procedure stack (as opposed to a linked list of 7 9	frames).  There are some preprocessor constants that can 9 8	be defined when compiling for your specific system, for 8                             @  ;	improved efficiency; however, the defaults should be okay. ;    6	The general concept of this implementation is to keep 6 8	track of all alloca()-allocated blocks, and reclaim any 8 :	that are found to be deeper in the stack than the current : 8	invocation.  This heuristic does not reclaim storage as 8 :	soon as it becomes invalid, but it will do so eventually. :    6	As a special case, alloca(0) reclaims storage without 6 7	allocating any.  It is a good idea to use alloca(0) in 7 :	your main control loop, etc. to force garbage collection. : */     2typedef char	*pointer;		/* generic pointer type */ 2    ,#define	NULL	0			/* null pointer constant */ ,    extern void	free();  extern pointer	malloc();     /*                          @  :	Define STACK_DIRECTION if you know the direction of stack : ;	growth for your system; otherwise it will be automatically ; 	deduced at run-time.     5	STACK_DIRECTION > 0 => grows toward higher addresses 5 4	STACK_DIRECTION < 0 => grows toward lower addresses 4 3	STACK_DIRECTION = 0 => direction of growth unknown 3 */     #ifndef STACK_DIRECTION  4#define	STACK_DIRECTION	-1		/* grows toward lower */ 4 #endif     #if STACK_DIRECTION != 0     =#define	STACK_DIR	STACK_DIRECTION	/* known at compile-time */ =    4#else	/* STACK_DIRECTION == 0; need run-time code */ 4    3static int	stack_dir = 0;		/* 1 or -1 once known */ 3 #define	STACK_DIR	stack_dir     -static char	*addr = NULL;	/* address of first -                            @  				   `dummy', once known */  static void  "find_stack_direction( /* void */ ) " 	{  -	auto char	dummy;		/* to get stack address */ -    	if ( addr == NULL )  		{			/* initial entry */  		addr = &dummy;     ,		find_stack_direction();	/* recurse once */ , 		}  	else				/* second entry */  		if ( &dummy > addr )  )			stack_dir = 1;	/* stack grew upward */ ) 		else  ,			stack_dir = -1;	/* stack grew downward */ , 	}     !#endif	/* STACK_DIRECTION == 0 */ !    /*  	An "alloca header" is used to:  *	(a) chain together all alloca()ed blocks; * 	(b) keep track of stack depth.     =	It is very important that sizeof(header) agree with malloc() = ?	alignment chunk size.  The following default should work okay. ? */      @  #ifndef	ALIGN_SIZE  !#define	ALIGN_SIZE	sizeof(double) ! #endif     typedef union hdr  	{  6	char	align[ALIGN_SIZE];	/* to force sizeof(header) */ 6 		struct	{ 	 -		union hdr	*next;	/* for chaining headers */ - ,		char		*deep;	/* for stack depth measure */ , 		}	h;  
	}	header; 
    /*  =	alloca( size ) returns a pointer to at least `size' bytes of = =	storage which will be automatically reclaimed upon exit from = <	the procedure that called alloca().  Originally, this space < =	was supposed to be taken from the current stack frame of the = 8	caller, but that method cannot be made to work for some 8 8	implementations of C, for example under Gould's UTX/32. 8 */     7static header	*last = NULL;	/* -> last alloca header */ 7         @  pointer  2alloca( size )				/* returns pointer to storage */ 2 *	unsigned	size;		/* # bytes to allocate */ * 	{  ,	auto char	probe;		/* probes stack depth: */ , 	register char	*depth = &probe;     #if STACK_DIRECTION == 0  6	if ( STACK_DIR == 0 )		/* unknown growth direction */ 6 		find_stack_direction();  #endif     ;	/* Reclaim garbage, defined as all alloca()ed storage that ; =	   was allocated from deeper in the stack than currently. */ =    	{  2	register header	*hp;		/* traverses linked list */ 2    	for ( hp = last; hp != NULL; )  *		if ( STACK_DIR > 0 && hp->h.deep > depth * *		  || STACK_DIR < 0 && hp->h.deep < depth * 		   )	{  $			register header	*np = hp->h.next; $                                                  @  -			free( (pointer)hp );	/* collect garbage */ -     			hp = np;	/* -> next header */   			}  		else  $			break;		/* rest are not deeper */ $    )	last = hp;			/* -> last valid storage */ ) 	}     	if ( size == 0 )  ,		return NULL;		/* no allocation required */ ,    4	/* Allocate combined header + user data storage. */ 4    	{  8	register pointer	new = malloc( sizeof(header) + size ); 8 					/* address of header */     	if ( new == NULL )  ,		return NULL;		/* abort() is traditional */ ,     	((header *)new)->h.next = last;   !	((header *)new)->h.deep = depth; !    	last = (header *)new;     -	/* User storage begins just after header. */ -    0	return (pointer)((char *)new + sizeof(header)); 0 	}  }                 5@  )/* End of text from ccvaxa:net.sources */ )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           