  @  /*~!tsearch.c*/  +/* Name:  tsearch.c Part No.: _______-____r +  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     !#ident	"@(#)nbclib:tsearch.c	1.1" !    /*   @  E * Tree search algorithm, generalized from Knuth (6.2.2) Algorithm T. E  *   *  A * The NODE * arguments are declared in the lint files as char *, A > * because the definition of NODE isn't available to the user. >  */     #include <search.h>  typedef char *POINTER;  Ftypedef struct node { POINTER key; struct node *llink, *rlink; } NODE; F    #define	NULL	0     extern char *malloc();     NODE *  Dtsearch(key, rootp, compar)	/* Find or insert key into search tree*/ D &POINTER	key;			/* Key to be located */ & <register NODE	**rootp;	/* Address of the root of the tree */ < +int	(*compar)();		/* Comparison function */ + {  2	register NODE *q;	/* New node if key not found */ 2    	if (rootp == NULL)  		return (NULL);         @  %	while (*rootp != NULL) {			/* T1: */ % 2		int r = (*compar)(key, (*rootp)->key);	/* T2: */ 2 
		if (r == 0) 
 #			return (*rootp);	/* Key found */ # 		rootp = (r < 0) ?  4		    &(*rootp)->llink :		/* T3: Take left branch */ 4 4		    &(*rootp)->rlink;		/* T4: Take right branch */ 4 	}  7	q = (NODE *) malloc(sizeof(NODE));	/* T5: Not found */ 7 +	if (q != NULL) {			/* Allocate new node */ + *		*rootp = q;			/* Link new node to old */ * +		q->key = key;			/* Initialize new node */ + 		q->llink = q->rlink = NULL;  	}  	return (q);  }     NODE *  :tdelete(key, rootp, compar)	/* Delete node with key key */ : &POINTER	key;			/* Key to be deleted */ & 8register NODE	**rootp;	/* Address of the root of tree */ 8                                  @  +int	(*compar)();		/* Comparison function */ + {  -	NODE *p;		/* Parent of node to be deleted */ - '	register NODE *q;	/* Successor node */ ' '	register NODE *r;	/* Right son node */ ' %	int ans;		/* Result of comparison */ %    +	if (rootp == NULL || (p = *rootp) == NULL) + 		return (NULL);  5	while ((ans = (*compar)(key, (*rootp)->key)) != 0) { 5 
		p = *rootp; 
 		rootp = (ans < 0) ?  0		    &(*rootp)->llink :		/* Take left branch */ 0 0		    &(*rootp)->rlink;		/* Take right branch */ 0 		if (*rootp == NULL)  &			return (NULL);		/* Key not found */ & 	}  !	r = (*rootp)->rlink;			/* D1: */ ! 5	if ((q = (*rootp)->llink) == NULL)	/* Llink NULL? */ 5 		q = r;  *	else if (r != NULL) {			/* Rlink NULL? */ *                                    @  3		if (r->llink == NULL) {		/* D2: Find successor */ 3 			r->llink = q;  				q = r; 	 %		} else {			/* D3: Find NULL link */ % 5			for (q = r->llink; q->llink != NULL; q = r->llink) 5 		 		r = q;  			r->llink = q->rlink;  			q->llink = (*rootp)->llink;  			q->rlink = (*rootp)->rlink;  		}  	}  -	free((POINTER) *rootp);		/* D4: Free node */ - /	*rootp = q;			/* Link parent to replacement */ / 	return (p);  }     void  3twalk(root, action)		/* Walk the nodes of a tree */ 3 1NODE	*root;			/* Root of the tree to be walked */ 1 ;void	(*action)();		/* Function to be called at each node */ ; {  	void _twalk();     $	if (root != NULL && action != NULL) $ 		_twalk(root, action, 0);  }     static void                           a@  :_twalk(root, action, level)	/* Walk the nodes of a tree */ : 9register NODE	*root;		/* Root of the tree to be walked */ 9 Cregister void	(*action)();	/* Function to be called at each node */ C register int	level;  {  0	if (root->llink == NULL && root->rlink == NULL) 0 		(*action)(root, leaf, level);  	else {  #		(*action)(root, preorder, level); # 		if (root->llink != NULL)  *			_twalk(root->llink, action, level + 1); * $		(*action)(root, postorder, level); $ 		if (root->rlink != NULL)  *			_twalk(root->rlink, action, level + 1); * #		(*action)(root, endorder, level); # 	}  }                                                                                                                                                                