
     NAME
          values - machine-dependent values

     SYNTAX
          #include <values.h>

     DESCRIPTION
          This file contains a set of manifest constants,
          conditionally defined for particular processor
          architectures.

          The model assumed for integers is binary representation
          (one's or two's complement), where the sign is represented
          by the value of the high-order bit.

          BITS(type)          The number of bits in a specified type
                              (e.g., int).

          HIBITS              The value of a short integer with only
                              the high-order bit set (in most
                              implementations, 0x8000).

          HIBITL              The value of a long integer with only
                              the high-order bit set (in most
                              implementations, 0x80000000).

          HIBITI              The value of a regular integer with only
                              the high-order bit set (usually the same
                              as HIBITS or HIBITL).

          MAXSHORT            The maximum value of a signed short
                              integer (in most implementations, 0x7FFF
                              = 32767).

          MAXLONG             The maximum value of a signed long
                              integer (in most implementations,
                              0x7FFFFFFF = 2147483647).

          MAXINT              The maximum value of a signed regular
                              integer (usually the same as MAXSHORT or
                              MAXLONG).

          MAXFLOAT, LN_MAXFLOAT         The maximum value of a
                                        single-precision floating-
                                        point number, and its natural
                                        logarithm.

          MAXDOUBLE, LN_MAXDOUBLE       The maximum value of a
                                        double-precision floating-
                                        point number, and its natural
                                        logarithm.

          MINFLOAT, LN_MINFLOAT         The minimum positive value of
                                        a single-precision floating-
                                        point number, and its natural
                                        logarithm.

          MINDOUBLE, LN_MINDOUBLE       The minimum positive value of
                                        a double-precision floating-
                                        point number, and its natural
                                        logarithm.

          FSIGNIF             The number of significant bits in the
                              mantissa of a single-precision
                              floating-point number.

          DSIGNIF             The number of significant bits in the
                              mantissa of a double-precision
                              floating-point number.

     FILES
          <values.h>

     SEE ALSO
          math.m

          (printed 07/30/92 - J B Systems)

