  @     	     NAME 	 8          setbuf, setvbuf - assign buffering to a stream 8         SYNTAX            #include <stdio.h>     #          void setbuf (stream, buf) #           FILE *stream;            char *buf;     /          int setvbuf (stream, buf, type, size) /           FILE *stream;            char *buf;            int type, size;          DESCRIPTION  F          Setbuf may be used after a stream has been opened but before F C          it is read or written.  It causes the array pointed to by C F          buf to be used instead of an automatically allocated buffer. F D          If buf is the NULL pointer input/output will be completely D           unbuffered.                                                             @  B          A constant BUFSIZ, defined in the <stdio.h> header file, B +          tells how big an array is needed: +                    char buf[BUFSIZ];      @          Setvbuf may be used after a stream has been opened but @ C          before it is read or written.  Type determines how stream C >          will be buffered.  Legal values for type (defined in >           stdio.h) are:     ;          _IOFBF  causes input/output to be fully buffered. ;    D          _IOLBF  causes output to be line buffered; the buffer will D E                  be flushed when a newline is written, the buffer is E .                  full, or input is requested. .    B          _IONBF  causes input/output to be completely unbuffered. B                        @  E          If buf is not the NULL pointer, the array it points to will E F          be used for buffering, instead of an automatically allocated F D          buffer.  Size specifies the size of the buffer to be used. D A          The constant BUFSIZ in <stdio.h> is suggested as a good A C          buffer size.  If input/output is unbuffered, buf and size C           are ignored.     C          By default, output to a terminal is line buffered and all C /          other input/output is fully buffered. /    
     SEE ALSO 
 4          fopen.m, getc.m, malloc.m, putc.m, stdio.m 4         DIAGNOSTICS  C          If an illegal value for type or size is provided, setvbuf C F          returns a non-zero value. Otherwise, the value returned will F    )@            be zero.     	     NOTE 	 C          A common source of error is allocating buffer space as an C E          ``automatic'' variable in a code block, and then failing to E -          close the stream in the same block. -    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          