  @     	     NAME 	 ?          malloc, free, realloc, calloc - main memory allocator ?         SYNTAX            char *malloc (size)            unsigned size;               void free (ptr)            char *ptr;     #          char *realloc (ptr, size) #           char *ptr;            unsigned size;     &          char *calloc (nelem, elsize) & !          unsigned nelem, elsize; !         DESCRIPTION  A          Malloc and free provide a simple general-purpose memory A E          allocation package.  Malloc returns a pointer to a block of E E          at least size bytes that is doubleword aligned for any use. E    A          The argument to free is a pointer to a block previously A                                              @  D          allocated by malloc; after free is performed this space is D E          made available for further allocation, but its contents are E           left undisturbed.     F          Undefined results will occur if the space assigned by malloc F @          is overrun or if some random number is handed to free. @    C          Malloc allocates the first big enough contiguous reach of C C          free space found in a circular search from the last block C C          allocated or freed, coalescing adjacent free blocks as it C A          searches.  It calls sbrk (see brk.m) to get more memory A A          from the system when there is no suitable space already A           free.                                                                 @  D          Realloc changes the size of the block pointed to by ptr to D B          size bytes and returns a pointer to the (possibly moved) B D          block.  The contents will be unchanged up to the lesser of D C          the new and old sizes.  If no free block of size bytes is C F          available in the storage arena, then realloc will ask malloc F C          to enlarge the arena by size bytes and will then move the C            data to the new space.      E          Realloc also works if ptr points to a block freed since the E D          last call of malloc, realloc, or calloc; thus sequences of D E          free, malloc and realloc can exploit the search strategy of E *          malloc to do storage compaction. *                           @  B          Calloc allocates space for an array of nelem elements of B :          size elsize.  The space is initialized to zeros. :    D          Each of the allocation routines returns a pointer to space D @          suitably aligned (after possible pointer coercion) for @ (          storage of any type of object. (    
     SEE ALSO 
           brk.m, malloc.m          DIAGNOSTICS  F          Malloc, realloc and calloc return a NULL pointer if there is F A          no available memory or if the arena has been detectably A C          corrupted by storing outside the bounds of a block.  When C D          this happens the block pointed to by ptr may be destroyed. D    	     NOTE 	                                                               @  F          Search time increases when many objects have been allocated; F D          that is, if a program allocates but never frees, then each D -          successive allocation takes longer. -    F          Space obtained from the system is allocated one map block at F G          a time.  If the callers stack is in extended memory, extended G C          map blocks are obtained.  If the stack is in non-extended C 7          memory, non-extended map blocks are obtained. 7    E          MPX-32 1.X allocates map blocks at the end of the currently E E          allocated memory.  If the user allocates a memory partition E D          in extended memory, the next map block requested by malloc D                                                              @  B          will be allocated following the memory partition and not B E          contiguous with the previously allocated memory.  This will E E          cause malloc to fail.  The user should preallocate and then E B          free memory of the anticipated size before including any B D          memory partitions.  This will insure contiguous map blocks D           for malloced memory.     *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                           