/*
 * unblk.c
 *
 * This program uncompresses MPX compressed files and
 * deletes trailing blanks from a source file
 * input - stdin   
 * output - stdout
 */

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
	unsigned char s[BUFSIZ];
	int i;

	while (1)
	{
		memset(s, '\0', BUFSIZ);
		if ((i = rbl(s, (int)BUFSIZ)) <= 0)
			exit(0);
#ifdef JUNK
		s[72] = '\n';
		s[73] = '\0';
#endif
/*  printf ("read %d chars\n", i); */
		s[i] = '\0';
		putloi(s);
	}
}

/* get a line of input. */

int getloi(s, lim)				/*  right from the book.  */
unsigned char s[];
int lim;
{
	int c, i, j;

#ifdef OLD
	for (i = 0; --lim > 0 && (c = getchar()) != EOF;)
	{
		if ((i >= 6) && ((c == 0xbf) || (c == 0x9f)))
		{
			ungetc(c, stdin);
			return (i);
		}
#else
	j = rmread(fileno(stdin), s);
	/* printf("read %d bytes\n", j);  */
	if (j <= 0)
		return (0);
	s[j] = '\n';
	for (i = 0; --lim > 0 && i < j;)
	{
		c = s[i];

#endif
		s[i++] = c;
		if ((*s != 0xbf) && (*s != 0x9f))
		{
			if (c == '\n')
			{
				if ((s[i - 1] == '\n') && (i > 1))
				{
					while ((s[i - 2] == ' ') && (i > 1))
						--i;
					s[i - 1] = '\n';
				}
				s[i] = '\0';
				return (i);
			}
		}
	}
#ifdef JUNK
	for (i = 0; --lim > 0 && (c = getchar()) != EOF && (s[i++] = c) != '\n';);
	if ((s[i - 1] == '\n') && (i > 1))
	{
		while ((s[i - 2] == ' ') && (i > 1))
			--i;
		s[i - 1] = '\n';
	}
	s[i] = '\0';
#endif
/* printf("loi returning %d bytes\n", i); */
	return (i);
}

/*
 **  output line of text from the source
 */
int putloi(s)
unsigned char *s;
{
	printf("%s", s);
}

unsigned char line[BUFSIZ];
int cmpop = 0;
int cmpflg = 0;
int bcnt = 0;
unsigned char *bptr = 0;
int binary = 1;
int recl = 0;

int rbl(buf, n)
unsigned char *buf;
int n;
{
	int count = 0;
	unsigned char *cp;
	int i;

	unsigned char *linadrs = line;

	if (!cmpop)
	{							/* see if we tested for compressed */
		cmpop = 1;				/* set comp tested flag */
		/* read in the first record */
		if ((recl = getloi(line, BUFSIZ)) == 0)
			return (0);			/* this means eof */
		linadrs = line;
		if (*linadrs == 0xbf || *linadrs == 0x9f)
		{						/* is this file compressed */
			cmpflg = 1;			/* set comp data flag */
			bcnt = linadrs[1];	/* set record count */
			bptr = &linadrs[6];	/* set data address */
		}
		else
			goto re00;
	}

	if (cmpflg)
	{							/* reading compressed data? */
		if (bcnt == 0)
		{						/* any data left in buffer */
		  re18:
			/* read in a data record */
			if ((recl = getloi(line, BUFSIZ)) == 0)
				return (0);		/* this means eof */
			linadrs = line;
			if ((*linadrs & 0xdf) != 0x9f)	/* is this valid rec */
				return (EOF);	/* error if not */
			bcnt = linadrs[1];	/* set record count */
			bptr = &linadrs[6];	/* set data address */
		}
	  re20:
		/* see if any blanks */
		if (i = *bptr++)
		{						/* next buffer pointer */
			if (i == 0xff)
				goto re60;		/* if eol, get out */
			while (i--)
			{
				if (count < n)
				{
					*buf++ = ' ';	/* put blank in buffer */
					count++;
				}
			}
		}
		if (--bcnt <= 0)
			goto re18;			/* read next record */

		if (i = *bptr++)
		{						/* next buffer pointer */
			while (i--)
			{
				if (count < n)
					*buf++ = *bptr;	/* put char in buffer */
				bcnt--;			/* decr count */
				bptr++;			/* next buffer pointer */
				count++;
			}
		}
		if (--bcnt <= 0)
			goto re18;			/* read next record */
		goto re20;

	  re60:
		bcnt--;					/* decr count */
		if ((*--buf == ' ') && (count == 1))
		{
			*buf = '\n';		/* put new line at eol */
			*++buf = '\0';		/* put new line at eol */
		}
		else
		{
			count++;
			*++buf = '\n';		/* put new line at eol */
			*++buf = '\0';		/* put new line at eol */
		}
/* printf("ret cnt = %ld\n", count); */
		return (count);

	}
	else
	{

		/* non compressed read here */

		/* read the next record */
		if ((recl = getloi(line, BUFSIZ)) == 0)
			return (0);			/* this means eof */

	  re00:
		/* here we need to strip off blank put in during write */
		/* this is because mpx does not support zero length blocks */
		if ((recl == 1) && (*linadrs == ' '))
			recl = 0;
		/* now append new line to end of buffer */
		*(cp = linadrs + recl) = '\n';	/* point to last char */

		/* copy this layer buffer to upper caller's buffer */

/* printf ("recl = %x, cp = %x, linadrs = %x\n", recl, cp, linadrs); */
		while (count < n)
		{
			if (linadrs > cp)
				break;
			*buf++ = *linadrs++;
			count++;
		}
	}

/* printf("ret1 cnt = %ld\n", count); */
	return (count);

}

/*~!bbio.c*/
/* Name:  bbio.c Part No.: _______-____r
 *
 * Copyright 1991 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nbrtl:bbio.c	1.0"

#include <stdio.h>

/********************************************************************/
/* These routines handle blocked and optionally compressed MPX files */

#define IOCMAX 10				/* start with 10 for now */

struct ioc {
	int iofcb;					/* fcb for i/o */
	int afcb;					/* callers fcb address */
	unsigned char *bufaddr;		/* callers buffer address */
	int bufcnt;					/* callers buffer size */
	unsigned char *cba;			/* current buffer address */
	unsigned char *rcba;		/* record control block pointer */
	int cpp;					/* current pool position */
	int cfp;					/* current file position */
	char cbn;					/* current buffer number */
	char nab;					/* number of active buffers */
	struct {					/* ioc bit flags */
		unsigned openop:1;		/* open flag */
		unsigned writop:1;		/* last op was write */
		unsigned outaop:1;		/* output active flag */
		unsigned compop:1;		/* if set, tested for comp'ed file */
		unsigned cmpflg:1;		/* if set, reading comp'ed file */
		unsigned iocaloc:1;		/* ioc allocated */
		unsigned free:3;		/* free flags, available */
	} flag;
	int bcnt;					/* compressed rec cur count */
	unsigned char *bptr;		/* compressed rec pointer */
	unsigned char *bufa;		/* start of contiguous buffers */
};

struct ioc ioc[IOCMAX];

#define ERRFLAG 0x04000000
#define EOFFLAG 0x02000000
#define EOMFLAG 0x01000000

#define RCBEOF 0x80				/* bit 0 */
#define RCBBOB 0x40				/* bit 1 */
#define RCBEOB 0x20				/* bit 2 */
#define RCBNULL 0x10			/* bit 3 */
#define RCBCONT 0x08			/* bit 4 */

#define SBLR 0
#define BCLR 1
#define SBTR 2
#define BCTR 3

#define BLKSIZE 768
#define BLKS (10*BLKSIZE)

/* ircont - establish ioc address for this fcb */
/* input - file number */
/* output - ioc address */
struct ioc *ircont(cfcb)
int cfcb;
{
	int i;
	struct ioc *wioc;			/* current ioc */

	for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc = &ioc[++i])
	{
		if (wioc->flag.iocaloc)
			if (wioc->afcb == cfcb)
			{
/*    		fprintf(stderr, "ioc returned %x\n", wioc); */
				return (wioc);
			}
	}
	/* not yet allocated, get a new one */
	for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc = &ioc[++i])
	{
		if (!wioc->flag.iocaloc)
		{
			wioc->flag.iocaloc = 1;	/* ioc allocated */
			if ((wioc->bufa = (unsigned char *)malloc(BLKS)) <= 0)
			{
#ifdef JUNK
				berror("ioc malloc error");
#else
				fprintf(stderr, "ioc malloc error\n");
#endif
				return (0);
			}
			/* initialize new ioc */
			wioc->afcb = cfcb;	/* save callers fcb address */
			wioc->cba = wioc->bufa;	/* set buffer addr in fcb */
			wioc->cbn = 0;		/* no curr buf number */
			wioc->nab = 0;		/* no active bufs */
			/* clear flags */
			wioc->flag.openop = 0;	/* open ioc */
			wioc->flag.writop = 0;
			wioc->flag.outaop = 0;
			wioc->flag.compop = 0;
			wioc->flag.cmpflg = 0;
			wioc->cpp = 0;		/* pool empty */
			wioc->bcnt = 0;		/* no compress cnt */
			wioc->bptr = 0;		/* no pointer either */
			wioc->cfp = 1;		/* curr position is 1st blk */
/*     	    fprintf(stderr, "ioc allocated %x\n", wioc); */
			return (wioc);
		}
	}
#ifdef JUNK
	berror("no ioc space left");
#else
	fprintf(stderr, "no ioc space left\n");
#endif
	return (0);
}

/* rmopen - open up a file stream */
rmopen(cfcb)
int cfcb;
{
	struct ioc *wioc;

	wioc = ircont(cfcb);
	if (wioc->flag.openop)
		return (1);				/* return o.k. */
	/* not open yet, do open */
	wioc->flag.openop = 1;		/* mark open */
	return (1);					/* return o.k. */
}

/* rmclose - close a file stream */
rmclose(cfcb)
int cfcb;
{
	struct ioc *wioc;

	wioc = ircont(cfcb);
	if (!wioc->flag.openop)
		return (1);				/* if not open, return o.k. */
	/* open, do close */
#ifdef NOTNOW
	if (wioc->flag.writop)
		irweof(wioc);			/* if writing, write eof */
	if (wioc->flag.outaop)
		plwrit(wioc);			/* if pool active, purge */
#endif
	wioc->flag.openop = 0;		/* mark closed */
	wioc->flag.iocaloc = 0;		/* mark unallocated */
	free(wioc->bufa);			/* free buffer */
	return (1);
}

#ifdef NOTUSED

/* rmrewind - rewind a file stream */
rmrewind(cfcb)
int cfcb;
{
	struct ioc *wioc;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	if (wioc->flag.writop)
		irweof(wioc);			/* if writing, write eof */
	if (wioc->flag.outaop)
		plrwnd(wioc);			/* if pool active, rewind */
	if (wioc->cpp)				/* is buffer filled */
		wioc->rcba = wioc->cba + 4;	/* set rec cont buf address */
	cfcb->devstat &= ~EOFFLAG;	/* turn off eof in callers fcb */
	return (1);
}

/* rmweof - write eof on file stream */
rmweof(cfcb)
int cfcb;
{
	struct ioc *wioc;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	irweof(wioc);				/* write eof */
	wioc->flag.writop = 1;		/* set writing */
	return (1);
}

/* rmbksp - backspace record on file stream */
rmbksp(cfcb)
int cfcb;
{
	struct ioc *wioc;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	if (wioc->flag.writop)
	{
		irweof(wioc);			/* if writing, write eof */
		wioc->rcba -= 4;		/* back over eof */
		if (!wioc->cpp)
			return (1);			/* return if buffer not filled */
		if (wioc->rcba[SBLR] & RCBEOF)
			return (1);			/* if no eof to back over, exit */
		if (!wioc->rcba[SBLR] & RCBBOB)
		{						/* is it a beg of blk */
			if (wioc->cbn > 1)	/* ignore if not 1st blk */
				if (wioc->cpp < 1)
					return (1);	/* return if not 1st pool */
			bfredf(wioc);		/* read previous buffer */
			wioc->rcba = wioc->cba + (int *)wioc->cba;
		}
		wioc->rcba -= (wioc->rcba[BCLR] + 4);
		wioc->flag.writop = 0;	/* not writing */
		cfcb->devstat &= ~EOFFLAG;	/* turn off eof in callers fcb */
		return (1);
	}
}
#endif							/* NOTUSED */

/* rmread - read from file stream */
rmread(cfcb, buffer)
int cfcb;
unsigned char *buffer;
{
	struct ioc *wioc;
	int fillcnt, i, bytecnt;
	unsigned char *buffp;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
#ifdef JUNK
	if (wioc->flag.writop)
		berror("read after write not allowed");
#else
	if (wioc->flag.writop)
		printf("read after write not allowed");
#endif
/* fprintf (stderr, "cpp = %x\n", wioc->cpp); */
	if (wioc->cpp == 0)
	{							/* if no data in pool yet, read it in */
		bfredf(wioc);			/* read in a block */
		wioc->rcba = wioc->cba + 4;
		/* have we tested for comp data yet */
		if (!wioc->flag.compop)
		{
			wioc->flag.compop = 1;
			/* test for comp rec */
			if (wioc->rcba[4] == 0xbf || wioc->rcba[4] == 0x9f)
			{
				wioc->flag.cmpflg = 1;	/* this is comp data */
				wioc->bcnt = 0;	/* init pointer */
/* fprintf (stderr, "compressed file found\n"); */
			}
		}
	}
	bytecnt = 0;				/* no bytes to caller yet */
	buffp = buffer;				/* save caller buff addr */
	if (wioc->flag.cmpflg)		/* reading compressed */
		if (wioc->bcnt)
			goto re07;			/* any data left */
  re18:
	if (wioc->rcba[SBLR] & RCBEOB)
	{
	  re06:
		if (bfredf(wioc) == -1)
			return (-1);
		wioc->rcba = wioc->cba + 4;
	}
#ifdef JIM
	if (wioc->rcba[SBTR] & RCBEOF)
	{
#else
	if (wioc->rcba[SBTR] & RCBEOF)
	{
		wioc->rcba[SBTR] &= ~RCBEOF;
/* fprintf (stderr, "EOF found\n"); */
		goto re06;
#endif
	  re05:
#ifdef JUNK
		cfcb->devstat |= EOFFLAG;
#endif
		return (-1);			/* return EOF */
	}
	if (wioc->flag.cmpflg)
	{							/* reading compressed */
		if ((wioc->rcba[4] & 0xdf) != 0x9f)
		{
/* fprintf (stderr, "EOF2 found\n"); */
			return (-1);		/* return EOF */
			/*    	    goto re05; *//* exit if not comp */
		}
		wioc->bptr = wioc->rcba + 10;	/* first data byte */
		wioc->bcnt = wioc->rcba[5];	/* get bytes this record */
		if (wioc->bcnt == 0)
		{
		  re10:
			wioc->rcba += (wioc->rcba[BCTR] + 4);
			goto re18;
		}
	  re07:
		if (*wioc->bptr)
		{						/* got blanks */
			if (*wioc->bptr == 0xff)
			{
				wioc->bptr++;
				if (--wioc->bcnt == 0)
				{
					wioc->rcba += (wioc->rcba[BCTR] + 4);
					wioc->bptr = wioc->rcba + 10;
				}
#ifdef JUNK
				cfcb->recl = bytecnt;
				return (1);
#else
				wioc->bufcnt = bytecnt;
				return (bytecnt);
#endif
			}
			for (i = *wioc->bptr; i; *buffp++ = ' ', i--, bytecnt++);
		}
		wioc->bptr++;
		if (--wioc->bcnt > 0)
		{
			if (i = *wioc->bptr)
			{
				wioc->bptr++;
				wioc->bcnt--;
				for (; i; i--)
				{
					*buffp++ = *wioc->bptr++;
					bytecnt++;
					wioc->bcnt--;
				}
				if (wioc->bcnt)
					goto re07;
				goto re10;
			}
		  re24:
			wioc->bptr++;
			if (--wioc->bcnt > 0)
				goto re07;
		}
		goto re10;
	}

	/* process uncompressed record */
#ifdef JUNK
	fillcnt = cfcb->excount - wioc->rcba[BCTR];
	if (fillcnt <= 0)
		cfcb->recl = cfcb->excount;
	else
		cfcb->recl = wioc->rcba[BCTR];
	for (i = 0; i < cfcb->recl; i++)
		cfcb->bufaddr[i] = wioc->rcba[i + 4];
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (1);
#else
	wioc->bufcnt = wioc->rcba[BCTR];
	for (i = 0; i < wioc->bufcnt; i++)
		buffer[i] = wioc->rcba[i + 4];
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (wioc->bufcnt);
#endif
}

#ifdef NOTUSED

/* rmadvr - advance record on file stream */
rmadvr(cfcb)
int cfcb;
{
	struct ioc *wioc;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	if (wioc->flag.writop)
		berror("adv record after write not allowed");
	if (wioc->cpp == 0)
	{							/* if no data in pool yet, read it in */
		bfredf(wioc);			/* read in a block */
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBLR] & RCBEOB)
	{
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF)
	{
		cfcb->devstat |= EOFFLAG;
	}
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (1);
}

/* rmadvf - advance file on file stream */
rmadvf(cfcb)
int cfcb;
{
	struct ioc *wioc;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	if (wioc->flag.writop)
		berror("adv file after write not allowed");
	if (wioc->cpp == 0)
	{							/* if no data in pool yet, read it in */
		bfredf(wioc);			/* read in a block */
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBLR] & RCBEOB)
	{
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF)
	{
		cfcb->devstat |= EOFFLAG;
	}
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (1);
}

/* rmwrit - write data on file stream */
rmwrit(cfcb)
int cfcb;
{
	struct ioc *wioc;
	char *buffp;
	int bcnt;

	rmopen(cfcb);				/* make sure open */
	wioc = ircont(cfcb);
	wioc->flag.writop = 1;		/* show output active */
	wioc->flag.outaop = 1;		/* show pool output active */
	if (wioc->cpp == 0)
	{							/* if no data in pool yet, initialize */
		bfredf(wioc);			/* read in a block */
		wioc->cba = &wioc->buf;
		wioc->nab = 1;
		wioc->cbn = 1;
		wioc->cpp = 1;
		irbinit(cfcb);
	}
	buffp = cfcb->bufaddr;		/* save caller buff addr */
	bcnt = cfcb->excount;
	if (bcnt > 0xff)
		berror("write: char cnt over 254 bytes");
	wioc->rcba = wioc->cba + 4;

	if (wioc->rcba[SBLR] & RCBEOB)
	{
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF)
	{
		cfcb->devstat |= EOFFLAG;
	}
	if ((wioc->cpp + 4) >= (wioc->cba + BLKS - wioc->rcba - 2))
	{
		irfinis(cfcb);
		bfwrit(wioc);
		irbinit(cfcb);
	}
	return (1);
}
#endif							/* NOTUSED */

/* bfredf - read next buffer from file stream */
bfredf(wioc)
struct ioc *wioc;
{
	unsigned char *cbaddr;

	/* see if next buffer in memory */
	if (wioc->cbn >= wioc->nab)
	{
		/* no, read in next pool */
		if (plredf(wioc) == -1)	/* read next pool */
			return (-1);		/* show EOF */
		wioc->cbn = 1;			/* we start at 1st buffer */
		cbaddr = wioc->bufa;	/* reset address pointer */
	}
	else
	{
		wioc->cbn++;			/* bump buffer number */
		cbaddr = wioc->cba + BLKSIZE;	/* next buffer address */
	}
	wioc->cba = cbaddr;			/* set new address */
	/* check for cnt < 0x300 (768) */
	/* check for BOB on in control bits */
	return (1);					/* return O.K. */
}

/* plredf - read next buffer pool from file stream */
plredf(wioc)
struct ioc *wioc;
{
	int retc;

	/* read the file */
	retc = read(wioc->iofcb, wioc->bufa, BLKS);
	if (retc <= 0)
	{
		return (-1);			/* show EOF for error */
	}
	/* compute # of block we read */
	wioc->nab = (retc + BLKSIZE - 1) / BLKSIZE;
	wioc->cpp = wioc->cfp;		/* update curr pool position */
	wioc->cfp += wioc->nab;		/* update current file position */
}
