/*~!BBS.C*/
/* Name:  BBS.C Part No.: _______-____r
*			
*	            SOFTWARE ENGINEERING
*
* The recipient of this product specifically agrees not to distribute,
* disclose, or disseminate in any way, to any one, nor use for its own
* benefit, or the benefit of others, any information contained  herein
* without the expressed written consent of Software Engineering.
*/
static char 	 CMod [] = "@(#)BBS.C	1.1";

/*
 * bbs -- subroutines to handle Encore blocked files
 */

#include <stdio.h>

typedef struct {    /* RRS structure */
	char	blfc [4];
	unsigned type :    8;
	unsigned size :    8;
	unsigned spec :    16;
	struct {    /* access specifications */
		unsigned read  :        1;
		unsigned write :        1;
		unsigned modfy :        1;
		unsigned updat :        1;
		unsigned appnd :        1;
		unsigned resv1 :        11;
		unsigned shar  :	1;
		unsigned excl  :	1;
		unsigned resv2 :	14;
	}
	accs;
	struct {   /* options specifications */
		unsigned syc   :        1;
		unsigned sgo   :        1;
		unsigned slo   :        1;
		unsigned sbo   :        1;
		unsigned blk   :        1;
		unsigned unblk :        1;
		unsigned nomsg :        1;
		unsigned res1  :        1;
		unsigned open  :        1;
		unsigned buff  :        1;
		unsigned res2  :        2;
		unsigned nowt  :        1;
		unsigned publc :        1;
		unsigned vomm  :        1;
		unsigned sep   :        1;
		unsigned res3  :        16;
	}
	opts;
	union {     /* Split into different RRS types */
		char rr_path [1];   /* Pathname -- Type 1 */
		char rr_volnm [1];  /* Volume Name -- Type 2 */
	}
	rr_end;
}
rrs;

typedef struct {  /* FCB structure */
	char lfc [4];
	char * tcw;
	struct {    /* control bits */
		unsigned nowait :	1;
		unsigned noerr  :	1;
		unsigned dfi    :	1;
		unsigned nst    :	1;
		unsigned ran    :	1;
		unsigned bl     :	1;
		unsigned exp    :	1;
		unsigned iec    :	1;
		unsigned dfd    :	1;
		unsigned specctl:	4;
		unsigned racc   :	19;
	}
	cntl;
	int	devstat;
	int	recl;	 /* record length actually transferred */
	int	ioq;
	int	errrtn;
	char *	fataddr;
	char *	bufaddr;
	int	excount;
	int	exracc;
	int	statw1;
	int	statw2;
	int	nwnorm;
	int	nwerrtn;
	char *	blkbuff;
}
fcb;

typedef struct {        /* CNP structure */
	int timeout;
	int abrtn;
	unsigned options :    16;
	unsigned status  :    16;
	int resvd [2];
	fcb * parmlink;
}
cnp;

typedef struct {    /* combined file-control structure */
	fcb	file_fcb;
	cnp	file_cnp;
	rrs	file_rrs;    /* RRS must come last to allow for variability */
}
file_ctl;

char	*itoa ();
int     *mpxopen ();

int     header [192];
int     regs [8];
int     local [4];
int     global [4];
int		*lsp;
int		lsbuf [192];
int		sbuf [384];
int		sect = 0;
long    loff;
long    goff;
long    soff;
int	    conv;
int     ovoff = 0;
int     ovnum = 0;
unsigned int     baseprg = 0;
int     ovmain;
int     vers = 1;
int     base;
int     sbase = 0;
int     max;
long	addr;
char	stdbuf [BUFSIZ];
char    lbuf [132];            /* line buffer */
char    filename [64];       /* load module file name */
char    fname [64];          /* load module file name */
char    table [48];          /* cross ref table entry */
int     count = 0;            /* initialize line buffer counter */
char    module [9];             /* expanded source 4 chars from 24 bits */
char    ovname [9] = "MAIN";          /* current overlay name */
int     source=0;           /* if zero, no source listing */
int     noconv=0;           /* if zero, do conversion */
FILE    *tfp;                 /* temp file pointer */
FILE    *lmp;                 /* load module file pointer */
int		*lmfp;
int		hashsize = 0;		 /* hash table size */
double	zero = 0;
int		num_sec, tot_ent;
char	*fnp;
int		place = 0;	 /* currect sector address */
int 	cinmem = 0;	 /* char in mem */
int 	dirty = 0;  /* non zero if hashbuf modified */
int 	maxsize;    /* current max file size */

main (argc, argv)
char **argv;
{
	register char *p;
	register n, f, same;
	int i, j, k, l;

	lbuf [0] = ' ';
	setbuf (stdout, stdbuf);

	fprintf (stderr, "Longname Converter from I.S.C. Copyright (C) 1988\n");
	argv++;
	f = 0;
	if (argc > 1) {
		p = *argv;
		if (*p == '-') {
			while (*p != '\0') {
				switch (*p++) {
				case 'S':
				case 's':
					source++;
					break;
				case 'C':
				case 'c':
					noconv++;
					break;
				}
			}
			argc--;
			argv++;
		}
	}
	if (argc > 1)
		if (**argv != '+') {
			strcpy (fname, fnp = *argv);
			/* must make pn vector for vomm */
			fnp = (char *) ((int) (strlen (fnp) << 24) | (int) fnp);

			/* open file unblocked */
			if ((lmfp = mpxopen (fnp, "a")) == NULL) {
				fprintf (stderr, "long: cannot open %s\n", *argv);
				exit (1);
			}
			argv++;
			argc--;
		}

	if (argc > 1) {
		fprintf (stderr, "long: invalid option - %s\n", *argv);
		exit (1);
	}

	/* now read rd to see if cataloged load module */
	regs [1] = (int) fnp;  /* filename pointer */
	regs [6] = (int) header; /* 192w buffer */
	regs [7] = 0;      /* no cnp */
	mpxsvc (0x202c, regs, regs);	 /* m.loc */
	if (regs [7]) {
		fprintf (stderr, "unable to read load-module descriptor\n");
		exit (1);
	}
	if ((header [0x40] & 0xff000000) != 0xCA000000) {
		fprintf (stderr, "load-module %s not type 'CA'\n", fnp);
		exit (1);
	}
	maxsize = header [0x45];         /* save current size */

	/* read header of load module */
	if (mpxread (lmfp, (char *) header, sizeof (header), 0) > 0) {
		ovmain = header [0x20];
		if (header [0x50] == 0xE2B00000)
			vers = 0;
		else if (header [0x50] == 0xE4A031A0)
			vers = 2;
                else vers = 1;
#ifdef JUNK
		if (header [0x50] == 0xE3000000)
			vers = 1;
#endif
	}
	else {
		fprintf (stderr, "long: error reading header\n");
		exit (1);
	}
	base = ovmain;
	opentemp ();		 /* open the temp file */

overlay:
	if ((base == 0) && (ovmain == 0) && (ovnum != 0)) exit (0);
	if (base) {
		/* read overlay header of load module */
		if (mpxread (lmfp, (char *) header, sizeof (header), base) > 0) {
			ovoff = header [191 - (ovnum / 2) ];
			if ((ovoff == 0) && (ovnum != 0)) {

				/* all done getting symbols, so hash them */
				/* write 2 wds of zero to file */
				fwrite (&zero, 1, sizeof (zero), tfp);
				/* rewind temp file */
				fseek (tfp, 0, 0);

				/* if no conversion wanted, exit now */
				if (noconv) exit(0);

				/* extend the load module */
				fextend ();

				/* open file unblocked */
				if ((lmfp = mpxopen (fnp, "a")) == NULL) {
					fprintf (stderr, "long: cannot reopen %s\n", fnp);
					exit (1);
				}
				/* we are done, set offset to symbols in header */
				if (mpxread (lmfp, (char *) header, sizeof (header), 0) <= 0){
					fprintf (stderr, "long: error re-reading header\n");
					exit (1);
				}

				/* set pointer to long/short name table */
				header [0x51] = ++base;

				/* set size of hash table */
				header [0x52] = num_sec;
				if (mpxwrite (lmfp, (char *) header, sizeof (header), 0) <= 0){
					fprintf (stderr, "long: error writing header\n");
					exit (1);
				}

				if ((hashbuf = (int *)malloc(num_sec*768)) <= 0) {
					fprintf (stderr, "long: error allocating hash buf\n");
					exit (1);
				}

				if ((cinmem = mpxread (lmfp, hashbuf, num_sec * 768, base)) <= 0){
					fprintf (stderr, "long: error reading hash buf\n");
					exit (1);
				}
				dirty = 0;
				place = base;	 /* current sector address */

				fprintf (stderr, "long: starting hash for %d entries\n", sbase);

				/* now hash all the symbol entries */
				for (i = 0, l = 0; i < sbase; i++) {
					/* read a symbol entry */
					if(fread (table, 1, 32, tfp) <= 0) {
						fprintf (stderr, "long: error reading temp file\n");
						exit (1);
					}
					/* go hash it twice, long & short name */
					if ((k = hash (table, tot_ent)) > l) l = k;
				}
				/* if data in hashbuf, writeout */
				if (dirty) {
					mpxwrite (lmfp, hashbuf, cinmem, place);
					dirty = 0;
				}
				mpxclos (lmfp);
				fprintf (stderr, "%d entries, %d sectors, max hash = %d\n",
				  sbase, num_sec, l);
				/* now we are done */
				exit (0);
			}
			ovoff = (ovnum % 2) ? ovoff >>= 16 : ovoff & 0xffff;
#ifdef JUNK
			ovoff += (ovmain = header [0x20]);
#endif
			for (n=0, p=(char *)header, p=p+(0x260-(ovnum * 8));n < 8; n++)
				ovname [n] = *p++;
			ovname [8] = 0;
		}
		else {
			fprintf (stderr, "long: error reading overlay header\n");
			exit (1);
		}
	}
	if (ovnum && source) printf ("\nOverlay #%d: %s\n", ovnum, ovname);
	else if (source) printf ("\nMain program: %s\n", ovname);
	ovnum++;
	/* read overlay header of load module */
	if (mpxread (lmfp, (char *) header, sizeof (header), ovoff) > 0) {
		/*      printf ("global symbol offset  (0x1c) => 0x%x\n", ovoff + header[0x1c]);
		printf ("local symbol offset   (0x1d) => 0x%x\n", ovoff + header[0x1d]);
		printf ("overlay header offset (0x20) => 0x%x\n", header[0x20]); */
		if (vers) {
			soff = header [0x4d];
			/*          printf ("FTN source offset new (0x4d) => 0x%x\n",
			ovoff + header[0x4d]); */
		}
		else {
			soff = header [0x23];
			/*          printf ("FTN source offset old (0x23) => 0x%x\n",
			ovoff + header[0x23]); */
		}
		soff = (ovoff + soff) * 768;
		/*      printf ("module info offset    (0x27) => 0x%x\n\n",
		ovoff + header[0x27]); */
	}
	else {
		fprintf (stderr, "long: error reading header\n");
		exit (1);
	}

lsym:
	/* PROCESS LOCAL SYMBOLS */
	loff = ovoff + header [0x1d];
golagain:
	/* read local symbol table */
	if (mpxread (lmfp, lsbuf, sizeof (lsbuf), loff) < 0) exit (2);
	for (lsp = lsbuf, k = 0; k < 48; lsp += 4, k++) {
		if (*lsp == 0x80000000) goto overlay;
		if (*lsp == 0) continue;
		if ((*lsp & 0x80000000) != 0) {
			*lsp &= 0x7fffffff;
			for (n = 0, p = (char *)lsp; n < 8; n++)
				module [n] = *p++;
			module [8]=0;
			baseprg = ((unsigned)(lsp[3] & 0xffc00000)) >> 20;
			/*        printf("\nSubroutine start = %s\n", module); */
			continue;
		}
		if ((lsp[2] & 0x0e000000) != 0x0e000000) continue;
		for (n = 0, p = (char *)lsp; n<8; n++)
			lbuf [n] = *p++;
		lbuf [8]=0;
		switch (vers) {
		case 0:
			n = (* (lsp+3) & 0xe0000000) >> 29;
			l = ((* (lsp+3) & 0x000007fe) >> 1) +
			  ((* (lsp+3) & 0x0ffc0000) >> 18) * 768;
			j = (* (lsp+3) & 0x10000000) >> 28;
			break;
		case 1:
			n = (* (lsp+3) & 0xe0000000) >> 29;
			l = ((* (lsp+3) & 0x000007fe) >> 1) +
			  (((* (lsp+2) & 0xe0000000) >> 19) |
			  ((* (lsp+3) & 0x0ffc0000) >> 18)) * 768;
			j = (* (lsp+2) & 0x01000000) >> 24;
			break;
		case 2:
			n = (lsp[2] & 0xe0000000) >> 29;
			l = (lsp[3] & 0x001ff800) >> 11 +
			  ((((unsigned)(lsp[3] & 0xffe00000)) >> 21) + baseprg) * 768;
			j = (lsp[2] & 0x01000000) >> 24;
			break;
		}
		if (n && source)
			/*      printf("%8.8s case %x sym = %8.8s:", module, n, lbuf); */
			printf ("%8.8s:%8.8s:%8.8s:", ovname, module, lbuf);
		if (prsrc (l, n, j) && (n == 3) && (base)) {
			if ((lbuf [5] == '*') && (lbuf [6] == '!')) {
				for (n=0 ; n<40; n++)table [n] = ' ';
				for (n=40 ; n<48; n++)table [n] = '\0';
				for (p=ovname, n=0; *p; n++)table [n] = *p++;
				for (p=module, n=8; *p; n++)table [n] = *p++;
				for (p= &lbuf[7], n=24; *p != '='; n++)table [n] = *p++;
				for (p++, n=16; *p && *p != ' '; n++)table [n] = *p++;
				/* output symbol to temp file */
				sbase++;    /* incr num of entries */
				if ((fwrite (&table [8], 1, sizeof (table) -16, tfp)) <= 0)
				{
					fprintf (stderr, "long: symbol file non-extendable\n");
					exit (1);
				}
			}
		}
	}
	loff++;
	goto golagain;
}

prsrc (off, type, comp)

int     off;
int     type;
int     comp;

{
	int     toff;
	int     n, i, j, k, l;
	int     oldoff, tsect;
	char    *p;
	char	*bp;

	/* Process compressed source */
	if ((soff == 0) || (off == 0)) {
		/*        printf("\tNo compressed source\n"); */
		return (0);
	}

	toff = soff + off - 1;
	tsect = toff/768;
	if (sect != tsect) {
		if (mpxread (lmfp, sbuf, sizeof (sbuf), tsect) < 0) exit (2);
		sect = tsect;
	}
	bp = (char *) sbuf;
        bp += (toff - (tsect * 768));

	/* i == number of chars in line */
	i = *bp++;
	/* j == number of leading blanks */
	j = *bp++;
	/* output leading blanks */
	for (p = lbuf; j; j--)
		*p++ = ' ';
	/* now output text, comp is 0 if compressed */
	if (type) {
		if (!comp) {
			for (n = 0; i; i--) {
				switch (n++) {
				case 0:
					*p++ = ((k = *bp++) >> 2) + ' ';
					continue;
				case 1:
					*p++ = ((l = *bp++) >> 4) | ((k & 0x3) << 4) + ' ';
					continue;
				case 2:
					*p++ = ((k = *bp++) >> 6) | ((l & 0xf) << 2) + ' ';
					continue;
				case 3:
					*p++ = (k & 0x3f) + ' ';
					n = 0;
					continue;
				}
			}
		}
		else {
			for (; i; i--)
				*p++ = *bp++;
		}
	}
	else {
		/*        printf("No source code\n"); */
		return (0);
	}
	*p = '\0';
	/*  printf("source code = %s\n", lbuf); */
	if (source) printf ("%s\n", lbuf);
	return (1);
}

/* opentemp opens a temp file for writing */

opentemp ()
{
#ifndef JUNK
	char*	tmpname = "TEMP BLOC=N";

	/* open file unblocked */
	if ((tfp = fopen (tmpname, "w+")) == NULL) {
		fprintf (stderr, "long: cannot create temp file\n");
		exit (1);
	}
#endif

#ifdef JUNK
	int		iext = 0;
	char*	tmpname = "SYMBOL";
	char	ext [5];

	ext [0] = '.';

	for (iext=0; iext < 100; iext++) {
		strcpy (filename, tmpname);
		strcat (filename, itoa (iext, &ext [1], 10) -1);
		if (access (filename, 0666) == -1) {
			if ((tfp = fopen (filename, "w")) == NULL) {
				fprintf (stderr, "long: cannot create temp file %s\n", filename);
				exit (1);
			}
			fclose (tfp);	 /* close so we can open unblocked */
			/* open file unblocked */
			strcat (filename, " BLOC=N");
			if ((tfp = fopen (filename, "r+")) == NULL) {
				fprintf (stderr, "long: cannot open temp file %s\n", filename);
				exit (1);
			}
			else return;
		}
	}
	fprintf (stderr, "long: cannot allocate temp file %s\n", filename);
	exit (1);
#endif
}

/* itoa - routine to translate a number to its ascii representation */

char	*itoa (num, s , base)

int		num;
char	*s;
int		base;
{
	sprintf (s, "%d", num);
	return (s);
}

findplace (offset, entry)
int	offset;
int	*entry;
{
	int roff, i;
	int	hash = 1;		 /* number of hashes */

	while (1) {
		if (offset >= (num_sec + base)*768)	offset = base * 768;
		roff  = ((offset >> 2) - (place * 192));
		if (hashbuf [roff] == 0) {
			for (i = 0; i < 8;  roff++, i++)
				hashbuf [roff] = entry [i];
			dirty++;
			return (hash);
		}
		/* do next name */
		offset += 32;
		hash++;
		continue;
	}
}

/* routine to extend a load module */
/* the load module must be deallocated */
/* then retyped, then reopened & extended */
/* then closed & reopened for hashing */
fextend ()

{
	int	temp;
	int	i;
	int	k;

	/* calc hash sectors required */
/*	num_sec = ((sbase + 23) * 5) / 48;   80% */
	num_sec = ((sbase + 23) * 6) / 48;  /* 67%*/
	tot_ent = num_sec * 24;

	/* see if there is enough room in module without extending */
	if ((base + num_sec) <= maxsize) {
		/* enough room, clear hash area */
		for (i = 0; i < 192; i++)header [i] = 0;
		for (k = 0; k < num_sec; k++)
			mpxwrite (lmfp, header, sizeof (header), (base + 1 + k));
		mpxclos (lmfp);
		return;
	}

	/* close load module before modifying rd */
	mpxclos (lmfp);
	/* first we must retype file to type 00 from CA */
	regs [1] = (int) fnp;  /* filename pointer */
	regs [6] = (int) header; /* 192w buffer */
	regs [7] = 0;      /* no cnp */
	mpxsvc (0x202a, regs, regs);	 /* m.modd */
	if (regs [7]) {
		fprintf (stderr, "unable to read load-module descriptor\n");
		exit (1);
	}
	temp = header [0x40];
	header [0x40] = (header [0x40] & 0x00ffffff) | (0x1c0);
	/* now rewrite rd back to disk to allow extension */
	mpxsvc (0x202b, regs, regs);	 /* m.rewrit */
	if (regs [7]) {
		fprintf (stderr, "unable to rewrite load-module descriptor\n");
		exit (1);
	}

	/* now extend file */
	regs [1] = (int) fnp;  /* filename pointer */
	regs [6] = num_sec; /* Num of sec to extend */
	regs [7] = 0;      /* no cnp */
	mpxsvc (0x2025, regs, regs);	 /* m.extd */
	if (regs [7]) {
		fprintf (stderr, "unable to extend load-module\n");
		exit (1);
	}

	/* file now extended, rewrite header and file type */
	regs [1] = (int) fnp;  /* filename pointer */
	regs [6] = (int) header; /* 192w buffer */
	regs [7] = 0;      /* no cnp */
	mpxsvc (0x202a, regs, regs);	 /* m.modd */
	if (regs [7]) {
		fprintf (stderr, "unable to read load-module descriptor\n");
		exit (1);
	}
	header [0x40] = temp;

	/* now rewrite rd back to disk */
	mpxsvc (0x202b, regs, regs);	 /* m.rewrit */
	if (regs [7]) {
		fprintf (stderr, "unable to rewrite load-module descriptor\n");
		exit (1);
	}
	/* make sure the non extended sectors are zero */
	if (k = (maxsize - base)) {
		/* open file unblocked */
		if ((lmfp = mpxopen (fnp, "a")) == NULL) {
			fprintf (stderr, "long: cannot reopen %s\n", fnp);
			exit (1);
		}
		/* some sectors left, clear them */
		for (i = 0; i < 192; i++)header [i] = 0;
		for (i = 0; i < k; i++)
			mpxwrite (lmfp, header, sizeof (header), (base + 1 + i));
		mpxclos (lmfp);
	}
	return;
}

/* MPXIO.C - MPX unblocked no-wait I/O routines */
/* This module provides Logical I/O services for writing MPX-32 files */
/* Four routines are exported from this module:              */

/*      mpxopen - accepts a pathname and an access-mode argument.
Assigns an (internally generated) LFC to the file and
opens it for the specified access.  Returns a pointer
to be used for all subsequent accesses to the file.     */

/*      mpxread - accepts a pointer value generated by mpxopen, buffer
address, length (in bytes), and sector address.  Reads the
buffer as one record from the file indicated by the pointer.
The sector address determines where to start reading.
The chars actually read are returned. */

/*      mpxwrite - accepts a pointer value generated by mpxopen, buffer
address, length (in bytes), and sector address.  Writes the
buffer as one record to the file indicated by the pointer.
The sector address determines where to start writing.
The chars actually written are returned. A zero indicates
there was an error */

/*      mpxclos - accepts a pointer value generated by mpxopen.
Closes and deassigns the file indicated by the
pointer.  */

#define M_ASSN(r1,r2) mpxsvc (0x2052,r1,r2)
#define M_WRIT(r1,r2) mpxsvc (0x1032,r1,r2)
#define M_READ(r1,r2) mpxsvc (0x1031,r1,r2)
#define M_WAIT(r1,r2) mpxsvc (0x103C,r1,r2)
#define M_CLSE(r1,r2) mpxsvc (0x1039,r1,r2)

#define TCW(count,ptr) ((count << 20) | (int) ptr | 0x80000)
#define RR_PATH   1                /* Assign by pathname  */
#define RR_TEMP   2                /* Assign to temp file */
#define RR_DEVC   3                /* Assign to device */
#define RR_LFC2   4                /* Assign to secondary LFC */
#define RR_SPACE  5                /* Assign by segment defination */
#define RR_RID    6                /* Assing by resource ID */
#define OPN_WRIT  (2 << 8)
#define OPN_APND  (5 << 8)
#define OPN_UPDAT (4 << 8)
#define OPN_BLKD  3
#define OPN_UNBLKD 2
#define INT(arb)  *((int *) (&(arb)))

/*******************************************************************/

/* NOTE: This routine generates LFCs of the form Mnn, where nn
varies from 00 to 99.  These LFCs are not reused, so no more
than 100 calls to mpxopen can be safely made.  */

int *
  mpxopen (pathnm, access)
char * pathnm;      /* Pathname of file to open */
char   access;      /* Access mode
'w' = write mode (overwrite previous data)
'a' = append mode */
{
	int i;
	file_ctl * fp;
	int rrsize;
	int svcregs [8];
	static lfc_cnt = 0;

	fp = (file_ctl *) malloc ((sizeof (file_ctl)) + strlen (pathnm));

	/* Initialize FCB and RRS LFC */

	fp->file_rrs.lfc [0] = fp->file_fcb.lfc [0] = '\0';
	fp->file_rrs.lfc [1] = fp->file_fcb.lfc [1] = 'M';
	fp->file_rrs.lfc [2] = fp->file_fcb.lfc [2]
	  = ('0' + (lfc_cnt / 10));
	fp->file_rrs.lfc [3] = fp->file_fcb.lfc [3]
	  = ('0' + (lfc_cnt % 10));

	lfc_cnt++;

	/* Set up RRS for assign and open */

	INT (fp->file_rrs.accs) = 0;
	INT (fp->file_rrs.opts) = 0;
	fp->file_rrs.opts.unblk = 1;
	fp->file_rrs.opts.open = 1;
	INT (fp->file_fcb.cntl) = 0;

	/* Now check for system files */

	fp->file_rrs.type = RR_TEMP;  /* Assume it's a temporary */
	rrsize = sizeof (rrs) - 1;             /* # of bytes */
	fp->file_rrs.spec = 0;  /* default initial file size */
	if (strcmp (pathnm, "SLO") == 0) {
		fp->file_rrs.opts.slo = 1;
		fp->file_fcb.cntl.dfi = 1;   /* Inhibit carriage-control */
	}
	else if (strcmp (pathnm, "SGO") == 0) {
		fp->file_rrs.opts.sgo = 1;
	}
	else if (strcmp (pathnm, "SBO") == 0) {
		fp->file_rrs.opts.sbo = 1;
	}
	else {
		fp->file_rrs.type = RR_PATH;
		rrsize += (sizeof (int)) - 1 + strlen (pathnm);
		fp->file_rrs.spec = strlen (pathnm) << 8;
		if (access == 'w') {
			fp->file_rrs.accs.write = 1;
		}
		else {
			fp->file_rrs.accs.updat = 1;
		} /* end if */
		strcpy (fp->file_rrs.rr_end.rr_path, pathnm);
		fp->file_cnp.options
		  = ((access == 'w') ? OPN_WRIT : OPN_UPDAT) + OPN_UNBLKD;
	} /* end if */
	fp->file_rrs.size = rrsize / sizeof (int);  /* in words */

	/* Now initialize FCB */

	fp->file_fcb.tcw = NULL;
	fp->file_fcb.cntl.nowait = 0; /* Nowait I/O */
	fp->file_fcb.cntl.ran = 1; /* Random access I/O */
	fp->file_fcb.cntl.exp = 1; /* Expanded FCB */
	fp->file_fcb.cntl.bl = 0; /* Unblocked I/O */
	fp->file_fcb.cntl.racc = 0;  /* start at sector 0 */
	fp->file_fcb.devstat = 0;
	fp->file_fcb.recl = 0;
	fp->file_fcb.ioq = 0;
	fp->file_fcb.errrtn = 0;
	fp->file_fcb.fataddr = fp->file_fcb.bufaddr = NULL;
	fp->file_fcb.excount = 0;
	fp->file_fcb.exracc = 0;
	fp->file_fcb.statw1 = 0;
	fp->file_fcb.statw2 = 0;
	fp->file_fcb.nwnorm = 0;
	fp->file_fcb.nwerrtn = 0;
	fp->file_fcb.blkbuff = NULL;

	/* Initialize CNP */

	fp->file_cnp.timeout = 1;   /* don't wait for resource */
	fp->file_cnp.abrtn = 0;
	fp->file_cnp.status = 0;
	fp->file_cnp.parmlink = & (fp->file_fcb);

	svcregs [1] = (int) & (fp->file_rrs);
	svcregs [7] = (int) & (fp->file_cnp);
	if (M_ASSN (svcregs, svcregs) >> 3) {
		free (fp);
		return (0);
	} /* endif */
	return ((int *) fp);
} /* end mpxopen */

/**********************************************************/

mpxwrite (fp, text, length, secta)
file_ctl * fp;  /* File to write to */
char * text;    /* Record to write */
int length, secta;
{
	int svcregs [8];

	svcregs [1] = (int) & (fp->file_fcb);

	/* Set up TCW and record length in FCB
	-- rest of FCB carries over from mpxopen */

	fp->file_fcb.bufaddr = text;
	fp->file_fcb.excount = length;

	fp->file_fcb.exracc = secta;
	M_WRIT (svcregs, svcregs);
	if (fp->file_fcb.devstat & 0x40000000) return (-1);
	else return (fp->file_fcb.recl);
} /* end mpxwrit */

/**********************************************************/

mpxread (fp, text, length, secta)
file_ctl * fp;  /* File to read from*/
char * text;    /* Record to read */
int length, secta;
{
	int svcregs [8];

	svcregs [1] = (int) & (fp->file_fcb);

	/* Set up TCW and record length in FCB
	-- rest of FCB carries over from mpxopen */

	fp->file_fcb.bufaddr = text;
	fp->file_fcb.excount = length;

	fp->file_fcb.exracc = secta;   /* point to sector address */
	M_READ (svcregs, svcregs);
	if (fp->file_fcb.devstat & 0x40000000) return (-1);
	else return (fp->file_fcb.recl);
} /* end mpxwrit */

/********************************************************************/

mpxclos (fp)
file_ctl * fp;  /* File to read from*/
{
	int svcregs [8];

	svcregs [1] = (int) & (fp->file_fcb);

	M_CLSE (svcregs, svcregs);
	free (fp);
} /* end mpxclos */

/********************************************************************/

struct {
	struct fcb 	iofcb;	/* fcb for i/o */
	struct fcb *	afcb;	/* callers fcb address */
	char *	cba;	/* current buffer address */
	char *	rcba;	/* record control block pointer */
	int		cpp;	/* current pool position */
	int		cfp;	/* current file position */
	char	cbn;	/* current buffer number */
	char	nab;	/* number of active buffers */
	struct	{		/* ioc bit flags */
		unsigned	openop	:	1;	/* open flag */
		unsigned	writop	:	1;	/* last op was write */
		unsigned	outaop	:	1;	/* output active flag */
		unsigned	compop	:	1;	/* if set, tested for comp'ed file */
		unsigned	cmpflg	:	1;	/* if set, reading comp'ed file */
		unsigned	iocaloc	:	1	/* ioc allocated */
		unsigned	free	:	3	/* free flags, available */
	} flag;
	char	bcnt;	/* compressed rec cur count */
	char *	bptr;	/* compressed rec pointer */
	int *	bufa;	/* start of contiguous buffers */
	}
	ioc [IOCMAX];

#define ERRFLAG 0x04000000
#define EOFFLAG 0x02000000
#define EOMFLAG 0x01000000

#define RCBEOF 0
#define RCBBOB 1
#define RCBEOB 2
#define RCBNULL 3
#define RCBCONT 4

#define SBLR 0
#define BCLR 1
#define SBTR 2
#define CBTR 3

#define BLKS (10*768)

/* ircont - establish ioc address for this fcb */
/* input -  fcb address */
/* output - ioc address */
struct ioc * ircont (cfcb)
struct fcb * cfcb;
{
	int	i;
	struct ioc * wioc;	/* current ioc */

	for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc++, i++) {
		if (wioc->flag.iocaloc)
			if (wioc->afcb == cfcb) return(wioc);
	}
	/* not yet allocated, get a new one */
	for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc++, i++) {
		if (!wioc->flag.iocaloc) {
		wioc->flag.openop = 1;	/* open ioc */
		if(wioc->bufa = (int *)malloc(BLKS)) <= 0) [
			berror("ioc malloc error");
			return (0);
		}
		/* initialize new ioc */
		wioc->afcb = cfcb;			/* save callers fcb address */
		wioc->iofcb[0] = cfcb[0];	/* save lfc */
		wioc->iofcb[2] = 0x02000000;	/* set control info */
		wioc->iofcb.bufaddr = wioc->bufa;	/* set buffer addr in fcb */
		wioc->cba = wioc->bufa;		/* set buffer addr in fcb */
		wioc->cbn = 0;				/* no curr buf number */
		wioc->nab = 0;				/* no active bufs */
		/* clear flags */
		wioc->flag.openop = 0;
		wioc->flag.writop = 0;
		wioc->flag.outaop = 0;
		wioc->flag.compop = 0;
		wioc->flag.cmpflg = 0;
		wioc->cpp = 0;				/* pool empty */
		wioc->bcnt = 0;				/* no compress cnt */
		wioc->bptr = 0;				/* no pointer either */
		wioc->cfp = 1;				/* curr position is 1st blk */
		/* init fcb also */
		wioc->iofcb.devstat = 0;
		wioc->iofcb.recl = 0;
		wioc->iofcb.statw1; = 0;
		wioc->iofcb.statw2; = 0;
		return (wioc);
	}
	berror("no ioc space left");
	return (0);
}

/* rmopen - open up a file stream */
rmopen (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;
	int cnp[6];

	wioc = ircont(cfcb);
	if(wioc->flag.openop)return(1);	/* return o.k. */
	/* not open yet, do open */
	wioc->flag.openop = 1;	/* mark open */
	cnp[0] = 0;
	cnp[1] = 0;
	cnp[2] = 0;
	cnp[3] = 0;
	cnp[4] = 0;
	cnp[5] = 0;
	/* open mode plus unblocked & resource data blocked */
	if ((int)cfcb & 0x40000000)cnp[2] = 0x04280000;	/* r/w */
	else cnp[2] = 0x01280000;	/* open read */
	/* now open resource */
	regs [1] = (int) &wioc->iofcb;  /* fcb address */
	regs [7] = (int) cnp;	/* cnp address */
	if (mpxsvc (0x2042, regs, regs) & 0x40000000)	 /* m.openr */
		berror("unable to open ioc resource");
	return(1);	/* return o.k. */
}

/* rmclose - close a file stream */
rmclose (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	wioc = ircont (cfcb);
	if(!wioc->flag.openop)return(1);	/* return o.k. */
	/* open, do close */
	if (wioc->flag.writop)irweof(wioc);	/* if writing, write eof */
	if (wioc->flag.outaop)plwrit(wioc);	/* if pool active, purge */
	regs[1] = (int) &wioc->iofcb;		/* fcb address */
	mpxsvc (0x1039, regs, regs);		/* close file */
	wioc->flag.openop = 0;	/* mark closed */
	wioc->flag.iocaloc = 0;	/* mark unallocated */
	free (wioc->bufa);		/* free buffer */
	return (1);
}

/* rmrewind - rewind a file stream */
rmrewind (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	if (wioc->flag.writop)irweof(wioc);	/* if writing, write eof */
	if (wioc->flag.outaop)plrwnd(wioc);	/* if pool active, rewind */
	if (wioc->cpp) 		/* is buffer filled */
		wioc->rcba = wioc->cba + 4;	/* set rec cont buf address */
	cfcb->devstat &= ~EOFFLAG;		/* turn off eof in callers fcb */
	return (1);
}

/* rmweof - write eof on file stream */
rmweof (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	irweof(wioc);	/* write eof */
	wioc->flag.writop = 1;	/* set writing */
	return (1);
}

/* rmbksp - backspace record on file stream */
rmbksp (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	if (wioc->flag.writop) {
		irweof(wioc);		/* if writing, write eof */
		wioc->rcba -= 4;	/* back over eof */
	if (!wioc->cpp)return(1); 		/* return if buffer not filled */
	if (wioc->rcba[SBLR] & RCBEOF)return(1); /* if no eof to back over, exit */
	if (!wioc->rcba[SBLR] & RCBBOB)  {	/* is it a beg of blk */
		if (wioc->cbn > 1)			/* ignore if not 1st blk */
			if (wioc->cpp < 1) return(1);	/* return if not 1st pool */
		bfredf(wioc);		/* read previous buffer */
		wioc->rcba = wioc->cba + (int *)wioc->cba;
	}
	wioc->rcba -= (wioc->rcba[BCLR] + 4);
	wioc->flag.writop = 0;	/* not writing */
	cfcb->devstat &= ~EOFFLAG;		/* turn off eof in callers fcb */
	return (1);
}

/* rmread - read from file stream */
rmread (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;
	int	fillcnt, i, bytecnt;
	char * buffp;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	if (wioc->flag.writop) berror("read after write not allowed");
	if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
		bfredf (wioc);		/* read in a block */
		wioc->rcba = wioc->cba + 4;
		if(!wioc->flag.compop) {		/* have we tested for comp data yet */
			wioc->flag.compop = 1;
			if (wioc->rcba[4] == 0xbf) {  /* test for comp rec */
				wioc->flag.cmpflg = 1;		/* this is comp data */
				wioc->bcnt = 0;				/* init pointer */
			}
		}
	}
	bytecnt = 0;			/* no bytes to caller yet */
	buffp = cfcb->bufaddr;	/* save caller buff addr */
	if (wioc->flag.cmpflg) 				/* reading compressed */
		if (wioc->bcnt) goto re07; 		/* any data left */
re18:
	if (wioc->rcba[SBLR] & RCBEOB)
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF) {
re05:
		cfcb->devstat |= EOFFLAG;
		return(-1);	/* return EOF */
	}
	if (wioc->flag.cmpflg) {			/* reading compressed */
		if ((wioc->rcba[4] & 0xdf) != 0x9f) goto re05;	/* exit if not comp */
		wioc->bptr = wioc->rcba + 10;	/* first data byte */
		wioc->bcnt = wioc->rcba[4];		/* get bytes this record */
		if (wioc->bcnt == 0) {
re10:
			wioc->rcba += (wioc->rcba[BCTR] + 4);
			goto re18;
		}
re07:
		if (*wioc->bptr) {		/* got blanks */
			if (*wioc->bptr == 0xff) {
				wioc->bptr++;
				if(--wioc->bcnt > 0) {
					wioc->rcba += (wioc->rcba[BCTR] + 4);
					wioc->bptr +10;
				}
				cfcb->recl = bytecnt;
				return (1);
			}
			for (i = *wioc->bptr; i; *buffp++ = ' ', i--, bytecnt++);
		}
		wioc->bptr++;
		if (--wioc->bcnt > 0) {
			if (i = *wioc->bptr) {
				wioc->bptr++;
				wioc->bcnt--;
				for (; i; i--) {
					*buffp++ = wioc->bptr++;
					bytecnt++;
					wioc->bcnt--;
				}
				if (wioc->bcnt)goto re07;
			}
re24:
			wioc->bptr++;
			if (--wioc->bcnt > 0) goto re07;
		}
		goto re10;
	}
	/* process uncompressed record */
	fillcnt = cfcb->excount - wioc->rcba[BCTR];
	if (fillcnt <= 0) cfcb->recl = cfcb->excount;
	else cfcb->recl = wioc->rcba[BCTR];
	for (i = 0; i < cfcb->recl; i++)
		cfcb->bufaddr[i] = wioc->rcba[i+4];
	wioc->rcba += (wioc->rcba[RCBA] + 4);
	return (1);
}
/* End of module */

re20:
		/* see if any blanks */
		if (i = *curfprm->bptr++) {				/* next buffer pointer */
			if (i == 0xff)goto re60;			/* if eol, get out */
			while (i--) {
				if(count < n) {
					*buf++ = ' ';				/* put blank in buffer */
					count++;
				}
			}
		}
	    if (--curfprm->bcnt <= 0)goto re18;	/* read next record */

		if (i = *curfprm->bptr++) {				/* next buffer pointer */
			while (i--) {
				if(count < n)
					*buf++ = *curfprm->bptr;	/* put char in buffer */
			    curfprm->bcnt--;				/* decr count */
				curfprm->bptr++;				/* next buffer pointer */
				count++;
			}
		}
	    if (--curfprm->bcnt <= 0)goto re18;	/* read next record */
		goto re20;

re60:
	    curfprm->bcnt--;			/* decr count */
		if ((*--buf == ' ') && (count == 1)) {
			*buf = '\n';			/* put new line at eol */
		} else {
			*++buf = '\n';			/* put new line at eol */
			count++;
		}

	} else {

		/* non compressed read here */

#ifdef WHY
		curfprm->linptr = 0;
#endif
		/* read the next record */
		if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
		if (i == -2) return (0);                  /* this means eof */

re00:
		/* here we need to strip off blank put in during write */
		/* this is because mpx does not support zero length blocks */
		if ((curfcb->recl == 1) && (*linadrs == ' ')) curfcb->recl = 0;
		/* now append new line to end of buffer */
		* (cp=linadrs+curfcb->recl) = '\n';       /* point to last char */
	
		/* copy this layer buffer to upper caller's buffer */

		while (count < n) {
			if (linadrs > cp) break;
			*buf++ = *linadrs++;
			count++;
		}
	}

/* rmadvr - advance record on file stream */
rmadvr (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	if (wioc->flag.writop) berror("adv record after write not allowed");
	if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
		bfredf (wioc);		/* read in a block */
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBLR] & RCBEOB) {
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF) {
		cfcb->devstat |= EOFFLAG;
	}
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (1);
}

/* rmadvf - advance file on file stream */
rmadvf (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	if (wioc->flag.writop) berror("adv file after write not allowed");
	if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
		bfredf (wioc);		/* read in a block */
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBLR] & RCBEOB) {
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF) {
		cfcb->devstat |= EOFFLAG;
	}
	wioc->rcba += (wioc->rcba[BCTR] + 4);
	return (1);
}

/* rmwrit - write data on file stream */
rmwrit (cfcb)
struct fcb * cfcb;
{
	struct ioc * wioc;
	char * buffp;
	int bcnt;

	rmopen(cfcb);		/* make sure open */
	wioc = ircont (cfcb);
	wioc->flag.writop = 1;	/* show output active */
	wioc->flag.outaop = 1;	/* show pool output active */
	if (wioc->cpp == 0) {	/* if no data in pool yet, initialize */
		bfredf (wioc);		/* read in a block */
		wioc->cba = &wioc->buf;
		wioc->nab = 1;
		wioc->cbn = 1;
		wioc->cpp = 1;
		irbinit(cfcb);
	}
	buffp = cfcb->bufaddr;	/* save caller buff addr */
	bcnt = cfcb->excount;
	if (bcnt > 0xff) berror("write: char cnt over 254 bytes");
	wioc->rcba = wioc->cba + 4;

	if (wioc->rcba[SBLR] & RCBEOB) {
		bfredf(wioc);
		wioc->rcba = wioc->cba + 4;
	}
	if (wioc->rcba[SBTR] & RCBEOF) {
		cfcb->devstat |= EOFFLAG;
	}
	if((wioc->cpp + 4) >= (wioc->cba + BLKS - wioc->rcba - 2)) {
		irfinis(cfcb);
		bfwrit(wioc);
		irbinit(cfcb);
	}
	return (1);
}

