  @  N/*==========================================================================*/ N N/*                                                                          */ N N/*     CK_TRAN   -  Check if transition will succeed                        */ N N/*                                                                          */ N N/*     inputs:      local data area                                         */ N N/*     outputs:     local data area                                         */ N N/*                                                                          */ N N/*==========================================================================*/ N    static CK_TRAN( l )                                                                                 @  Nregister LOCALPTR l;                        /* pointer to local variables   */ N {  N      unsigned int tran = l->trantype;      /* transition type              */ N N      l->length = NULL;                     /* clear token length           */ N          switch ( tran ) {  N                                            /* begin case for               */ N N         case DIGIT   :                     /* single character transitions */ N          case ALPHA   :           case HEXCH   :           case SPECL   :           case ANYCH   :     N         default      :                     /* default is a specific char   */ N !            return( CK_CHAR(l) ); ! N                                            /* end case for single char     */ N   @  N         case STRNG   :                     /* begin case for string check  */ N N            return( CK_STR( l ));           /* string transition            */ N N                                            /* end case for string test     */ N N         case DNUMB   :                     /* begin case for numerics      */ N          case HNUMB   :  N            return( CK_NUM( l ));           /* numeric transitions          */ N N                                            /* end case for numrics         */ N          case LAMBDA  :  N            return( SUCCESS );              /* always transition            */ N N                                            /* end case for lambda          */ N                                                      @  N         case NOBLNK  : {                   /* transition and remove blanks */ N             int i;  J            for ( i = 0; ( l->stream[i] == ' ' && i <= l->inputln); i++ ); J             l->length = i;              return( SUCCESS );  N            }                               /* end case for no blank test   */ N    N         case EOS     :                     /* transition on end of stream  */ N =            return( l->inputln == NULL ? SUCCESS : FAILURE ); = N                                            /* end case for end of stream   */ N N         case KEYWRD  : {                   /* begin case for keywords      */ N N             if ( CK_STR( l ) )             /* is the next token a string   */ N                                      @  N                  return( CK_KEY( l ));     /* check string in keyword table*/ N N             else                           /* next token is not a string   */ N N                  return( FAILURE );        /* hence we cannot match keyword*/ N N             }                              /* end of case keyword          */ N    N         case TSTEXP  :                     /* begin case for sub&tst exp   */ N          case SUBEXP  : {  (            unsigned int *pfi, len, err; (             char *str;              pfi = l->subtable;              len = l->inputln;              str = l->stream;  4            if ( CPARSE( &pfi, &str, &len, &err) ) { 4 ,               l->length = l->inputln - len; , !               return( SUCCESS ); !          G@  
            } 
             else {  ,               l->length = l->inputln - len; ,                l->errval = err;  N               return( FAILURE );           /*  sub expression transition   */ N 
            } 
 N            }                               /* end of sub&tst expr case     */ N       }  }                                                                                                                                                                                                                                                                                                                                                                                                                                                          