/*~!SDB.SYM.H*/
/* Name: SDB.SYM.H Part No.: _______-___r
 *
 *				SOFTWARE ENGINEERING
 *
 *  The recipient of this product specifically agrees not to distribute,
 *  disclose, or disseminate in any way, to any one, nor use for its own
 *  benefit, or the benefit of others,  any information contained herein
 *  without the expressed written consent of Software Engineering.
 */
/*
 *			S D B . S Y M . H
 *
 *	Define structure of symbol table file produced by hcc and has for
 *	use by sdb.
 */

# define MAGIC_SYM 0x9469l
# define MAGIC_AST 0x3647l
# define IS_SYM( x ) ( x.h_magic == MAGIC_SYM )
# define IS_AST( x ) ( x.h_magic == MAGIC_AST )

struct sdb_head {			/* Header record */
	_int32 h_d1;			/* (Dummy) */
	_int32 h_magic;			/* Magic */
	char h_name [ 16 ];		/* File name */
	_int32 h_d2;
	_int32 h_stb_len;		/* Length of Symbol Table Part */
	_int32 h_d3;
	_int32 h_stb_ch_off;		/* Offset of Character Table in Symbol Table
					   (Length of "Main" Symbol Table)
					   (0 if not using Flexnames)  */
	_int32 h_d4;
	_int32 h_ltb_len;		/* Length of Line Number Table */
	_int32 h_d5;
	_int32 h_spare1;
	_int32 h_d6;
	_int32 h_spare2;
};

struct sdb_stb {			/* Symbol Table Entry */
	char s_name [ NCHNAM ];		/* Symbol Name */
	_int32 s_disp;			/* Displacement */
	short s_size;			/* Size */
	short s_type;			/* Basic Type */
	short s_tstack;			/* Type Stack */
	short s_spare;			/* For Alignment */
};

struct sdb_ltb {			/* Line Number Table Entry */
	_int32 l_lineno;		/* Line Number */
	_int32 l_offset;		/* Offset */
};
