/*~!PASS1.C*/
/* Name:  PASS1.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			       P A S S 1 . C
 *
 *			     Revision History
 *			     ----------------
 */

#include	"has.h"

extern	int		label;
extern	short	debug;
extern	int32	*addrp;
extern	int32	textaddr;
extern	short	curspace;	/* n_type type value */
extern	struct pscdata pseudocodes[];
extern	struct sdata easycodes[];
extern	struct sdata hardcodes[];
extern	char	*index();
extern	char	*rindex();
extern	struct nlist *get();
extern	struct nlist *new();
struct	nlist	*curlabp;	/* curr lab ptr if present */

/*
 *	P A S S 1 ( )
 *
 */
pass1 (fieldp)
register char	**fieldp;
{
	register struct	sdata	*cp;
	register struct pscdata *pp;
	struct nlist *np;
	char *n;
	int k;

	if (label) {
		label = 0;
		DEBUG (6, "Got label (%s)\n", *fieldp);
		if ((np = get (*fieldp)) != NULL) {
			if ((np->n_type & N_TYPE) != N_UNDEF) {
				error ("symbol '%s' multiply defined",*fieldp);
				return (-1);
			}
		} else
			np = new (*fieldp);
		np->n_type |= curspace;
		curlabp = np;
		/* default to current loc counter */
		np->n_value = *addrp;
		DEBUG (9,"(short) *addrp is %d, ",(short) *addrp);
		DEBUG (9,"np is %08lx, ", np);			
		DEBUG (9, "Label value: 0x%08lx\n", *addrp);
		DEBUG (9,"\tnp->n_value is %08x\n", np->n_value);
		fieldp++;
	}
	if (*fieldp == 0) {
		/* line with only a label */
		error ("line with only label");
		return (-1);
	}

	n = *fieldp;
	/* test for pseudo op */
	for (pp = pseudocodes; pp->token[1] < *(n+1); pp++)
		;
	while ((k = strcmp(pp->token, n)) < 0)
		pp++;
	if (k == SAME) {
		if(pp->pass1 != NULL)
			/*  call appropriate routine in do1pseudo  */
			return ((*pp->pass1) (pp->token, fieldp));
		else return(0);
	}

	for (cp = easycodes; cp->token[0] < *n; cp++)
		;
	while ((k = strcmp(cp->token, n)) < 0)
		cp++;
	if (k == SAME) {
		*addrp += 2;
		return (0);
	}

	for (cp = hardcodes; cp->token[0] < *n; cp++)
		;

	for ( ; (cp->token != (char *)'\177') && (cp->token[0] == *n); cp++)
		if (prefix(cp->token, n) == SAME) {
			if (*addrp % 4 !=0)*addrp += 2; /* word bound */
			*addrp += 4;
			return (0);
		}

	error ("unrecognized input");
	return (-1);
}
