/*~!MKHARD.C*/
/* Name:  MKHARD.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			      M K H A R D . C
 *
 *                           Revision History
 *                           ----------------
 */

#include	"has.h"

extern	short	debug;
extern	char	*strchr();

struct h_mr_tab {
	char	*opcode;
	short	opcd;
} h_mr_tab[] = {
	"adfd",	0xe000,
	"adfw",	0xe000,

	"admb",	0xb808,
	"admd",	0xb800,
	"admh",	0xb800,
	"admw",	0xb800,

	"anmb",	0x8408,
	"anmd",	0x8400,
	"anmh",	0x8400,
	"anmw",	0x8400,

	"armb",	0xe808,
	"armd",	0xe800,
	"armh",	0xe800,
	"armw",	0xe800,

	"camb",	0x9008,
	"camd",	0x9000,
	"camh",	0x9000,
	"camw",	0x9000,

	"cmmb",	0x9408,
	"cmmd",	0x9400,
	"cmmh",	0x9400,
	"cmmw",	0x9400,

	"dvfd",	0xe400,
	"dvfw",	0xe400,

	"dvmb",	0xc408,
	"dvmd",	0xc400,
	"dvmh",	0xc400,
	"dvmw",	0xc400,

	"eomb",	0x8c08,
	"eomd",	0x8c00,
	"eomh",	0x8c00,
	"eomw",	0x8c00,

	"exm",	0xa800,

	"la",	0x3400,
	"lb",	0xac08,
	"ld",	0xac00,
	"lea",	0xd000,
	"lear",	0x8000,
	"lf",	0xcc00,
	"lh",	0xac00,
	"lmb",	0xb008,
	"lmd",	0xb000,
	"lmh",	0xb000,
	"lmw",	0xb000,
	"lnb",	0xb408,
	"lnd",	0xb400,
	"lnh",	0xb400,
	"lnw",	0xb400,
	"lw",	0xac00,

	"mpfd",	0xe408,
	"mpfw",	0xe408,

	"mpmb",	0xc008,
	"mpmd",	0xc000,
	"mpmh",	0xc000,
	"mpmw",	0xc000,

	"ormb",	0x8808,
	"ormd",	0x8800,
	"ormh",	0x8800,
	"ormw",	0x8800,

	"stb",	0xd408,
	"std",	0xd400,
	"stf",	0xdc00,
	"sth",	0xd400,
	"stmb",	0xd808,
	"stmd",	0xd800,
	"stmh",	0xd800,
	"stmw",	0xd800,
	"stw",	0xd400,

	"sufd",	0xe000,
	"sufw",	0xe000,

	"sumb",	0xbc08,
	"sumd",	0xbc00,
	"sumh",	0xbc00,
	"sumw",	0xbc00,
	0,	0
};

h_mr (token, fieldp)
register char	*token;
register char	**fieldp;
{
	struct	h_mr_tab	*tp;
	struct	relocation reldata;
	short	dreg;
	short	xreg = 0;
	int32	memloc;
	int k;
	short out1, out2;

	DEBUG (8, "h_mr(%s);", token);			
	for (tp = h_mr_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, fieldp[0])) < 0)
		tp++;
	if (k == SAME) {
		if ( evalqword (fieldp[1], &dreg)
		    || address (fieldp[2], &memloc, &reldata))
			return (-1);
		if (fieldp[3])
			if (evalqword (fieldp[3], &xreg))
				return (-1);
		if (reldata.r_type != -1)				
			dumpreloc (&reldata);	
		out1 = tp->opcd | (((dreg & 7) << 7) | ((xreg & 3) << 5));
		out1 |= ((memloc >> 16) & 7);
		out2 = (short)memloc;
		return (dump2qw (out1, out2));
	}
	bomb ("opcode '%s' not in table", token);
}

struct h_imd_tab {
	char	*opcode;
	short	opcd;
} h_imd_tab[] = {
	"adi",	0xc801,
	"ci",	0xc805,
	"dvi",	0xc804,
	"li",	0xc800,
	"mpi",	0xc803,
	"sui",	0xc802,
	0,		0
};

h_imd (token, fieldp)
register char	*token;
register char	**fieldp;
{
	struct	h_imd_tab *tp;
	short	dreg;
	short	num;
	short	out1;
	int k;

	DEBUG (8, "h_imd(%s);", token);			
	for (tp = h_imd_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, fieldp[0])) < 0)
		tp++;
	if (k == SAME) {
		if ( evalqword (fieldp[1], &dreg))
			return (-1);
		if (evalqword (fieldp[2], &num))
			return (-1);
		out1 = tp->opcd | ((dreg & 7) << 7);
		return (dump2qw (out1, num));
	}
	bomb ("opcode '%s' not in table", token);
}

struct h_m_tab {
	char	*opcode;
	short	opcd;
} h_m_tab[] = {
	"lpsd",	0xf980,
	"lpsdcm",	0xfa80,
	"zmb",	0xf808,
	"zmd",	0xf800,
	"zmh",	0xf800,
	"zmw",	0xf800,
	0,		0
};

h_m (token, fieldp)
register char	*token;
register char	**fieldp;
{
	struct	h_m_tab	*tp;
	struct	relocation reldata;
	short	xreg = 0;
	int32	memloc;
	int k;
	short	out1, out2;

	DEBUG (8, "h_m(%s);", token);			
	for (tp = h_m_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, fieldp[0])) < 0)
		tp++;
	if (k == SAME) {
		if (address (fieldp[1], &memloc, &reldata))
			return (-1);
		if (fieldp[2])
			if (evalqword (fieldp[2], &xreg))
				return (-1);
		if (reldata.r_type != -1)				
			dumpreloc (&reldata);	
		out1 = tp->opcd | ((xreg & 3) << 5);
		out1 |= ((memloc >> 16) & 7);
		out2 = (short)memloc;
		return (dump2qw (out1, out2));
	}
	bomb ("opcode '%s' not in table", token);
}

struct h_n_tab {
	char	*opcode;
	short	opcd;
} h_n_tab[] = {
	"abm",	0xa008,
	"sbm",	0x9808,
	"tbm",	0xa408,
	"zbm",	0x9c08,
	0,	0
};

h_n (token, fieldp)
register char	*token;
register char	**fieldp;
{
	struct	h_n_tab	*tp;
	struct	relocation reldata;
	short	bitn;
	short	xreg = 0;
	int32	memloc;
	int k;
	short	out1, out2;

	DEBUG (8, "h_n(%s);", token);			
	for (tp = h_n_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, fieldp[0])) < 0)
		tp++;
	if (k == SAME) {
		if ( evalqword (fieldp[1], &bitn)
		    || address (fieldp[2], &memloc, &reldata))
			return (-1);
		if (fieldp[3])
			if (evalqword (fieldp[3], &xreg))
				return (-1);
		if (reldata.r_type != -1)				
			dumpreloc (&reldata);	
		out1 = tp->opcd | (((bitn & 7) << 7) | ((xreg & 3) << 5));
		memloc += bitn/8;
		out1 |= ((memloc >> 16) & 7);
		out2 = (short)memloc;
		return (dump2qw (out1, out2));
	}
	bomb ("opcode '%s' not in table", token);
}

h_v1 (token, fieldp)
register char	*token;
register char	**fieldp;
{
	return (dumphword((int32)0));
}

h_svc (token, fieldp)
register char	*token;
char	**fieldp;
{
	short	codeval;
	short	num;

	if (evalqword (fieldp[1], &codeval))
		return (-1);
	if (evalqword (fieldp[2], &num))
		return (-1);
	codeval = (codeval << 12) | num;
	return (dumphword ((int32)0xc8060000 | codeval));
}

struct h_b_tab {
	char	*opcode;
	short	word0;
} h_b_tab[] = {
    "bu",		0xec00,
	"bl",		0xf880,
	"bct",		0xf000,
	"bcf",		0xec00,
	"bft",		0xf000,
	"bgt",		0,
	"blt",		0,
	"beq",		0,
	"bge",		0,
	"ble",		0,
	"bne",		0,
	"bs",		0,
	"bns",		0,
	"jump",		0xec00,
	0,			0
};

#define bct 8
#define bcf 16
#define reg 32

h_b (token, fieldp)
register char	*token;
register char	**fieldp;
{
	struct	relocation reldata;
	short	condcode;
	int32 	addr;						
	short   opcode = 0xec00;
	register struct h_b_tab *tp;

	for (tp = h_b_tab; tp->opcode != 0; tp++)
		if (strcmp (tp->opcode, fieldp[0]) == SAME) {
			if (strcmp (fieldp[0], "bu") == SAME) condcode = 0;
			else if ((condcode = condition (token, fieldp[0])) == -1)
				return (-1);
			DEBUG (8, "h_b(%s);\n", fieldp[1]);			
			if (address (fieldp[1], &addr, &reldata) == -1)
				return (-1);
			DEBUG (8, "\taddr is 0x%0lx\n", addr);		
			if (reldata.r_type != -1) {				
				reldata.r_length = R_IBR;
				dumpreloc (&reldata);
			}
#ifdef JUNK
			if (strcmp (token, fieldp[0]) != SAME) {	/* if conditions */
				if (evalqword (fieldp[2], &s2reg))
					return (-1);
			} else if (*fieldp[2]) {
				error ("Field should be empty (%s)\n", fieldp[2]);
				return (-1);
			}
#endif
			DEBUG (8, "h_b(): addr is now 0x%lx\n", addr);
			if (condcode & bct)opcode = 0xec00;
			else if (condcode & bcf)opcode = 0xf000;
			return (dump2qw ((opcode|(condcode<<7)|
				(short)(addr>>16)&0xF)
				&0xffff, (short) (addr&0xFFFF)));
		}
	bomb ("opcode '%s' not in table", token);
}
