/*~!EVAL.C*/
/* Name:  EVAL.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *				E V A L . C
 *
 *				Revision History
 *				----------------
 */

#include	<ctype.h>
#include	"has.h"


#define	SHORTNUM	1
#define	LONGNUM		2
#define FLOATNUM	3				
#define	MINUS		1
#define	PLUS		2

#define	MAXSHORT	32767

extern	short	debug;
extern	short	dfltextern;
extern	long	*addrp;
extern	struct nlist *get();
extern	struct nlist *new();
extern	char	*malloc();

long	maxi = 0x10000l;

evalfword (strp, fwordp, rp)	/* Warning, really just hword decoder!! */
char	*strp;
/* WORD	*fwordp; */
double	*fwordp;
struct	relocation *rp;
{
   DEBUG (8, "evalfword (%s);\n", strp);			
   if (getval (strp, fwordp, rp) == -1)				
      return (-1); /* if getval blew up, say so */		

   return (0);
}

evalhword (strp, hwordp, rp)
char	*strp;
int32 	*hwordp;	/* short was not halfword */		
struct	relocation *rp;
{
int	ret;	/* temp for return value from getval */		
WORD fword;							

   DEBUG (8, "evalhword ():  %s\n", strp);			
   if ((ret = getval (strp, &fword, rp)) == -1)			
      return (-1); /* if getval didn't like it, I don't either */
   if (ret == FLOATNUM)						
      {								
      *hwordp = (float)fword; /* 32 bit float uses high order 32 bits */
      }								
   else								
      *hwordp = fword; /* only use lower 32 bits for halfword */

   return (0);
}

evalqword (strp, qwordp)
char	*strp;
short	*qwordp;
{
	struct	relocation reldata;	/* ignored */
	int	ret;
	WORD	hword;		/* make it a hepword on any machine */

        DEBUG (8, "evalqword ():  %s\n", strp);			
	if ((ret = getval (strp, &hword, &reldata)) == -1)
		return (-1);
	else if (ret != SHORTNUM) {
		error ("Disallowed value (%s)", strp);
		return (-1);
	}
	DEBUG(3,"\tevalqword: hword is %d\n",(int)hword);
	*qwordp = hword;		/* only last qw */
	return (0);
}

evalbyte (strp, bytep)
char	*strp;
char	*bytep;
{
	WORD	fword;				
	struct relocation dummy;			
	short	tnum;

	DEBUG (8, "evalbyte ():  %s\n", strp);			
	if (getval (strp, &fword, &dummy) == -1)	
		return (-1);
	tnum = fword;
	if (tnum < -128 || tnum > 255) {	
		error ("byte value out of range (%s)", strp);
		return (-1);
	}
	*bytep = (char)tnum;				
	return (0);
}

address (strp, longp, rp)
char	*strp;
int32 	*longp;
struct	relocation *rp;
{
   WORD longintwd;						
	DEBUG (8, "address():  %s\n", strp);			
	if (getval (strp, &longintwd, rp) == -1)
		return (-1);
	*longp = longintwd;  /* pull out lower half */	
	DEBUG (10,"\tvalue is 0x%08lx\n", longintwd);
	DEBUG (10,"\t*longp is 0x%08lx\n", (long)*longp);	
	return (0);
}

char *
rdstring (cp)
register char	*cp;
{
	short	cnt;
	short	num;
	char	*newp;
	register char *mp;

	DEBUG (8, "rdstring(%s);\n", cp);			
	if ((mp = malloc (strlen (cp))) == NULL)
		bomb ("No more memory in rdstring");

	newp = mp;
	if (*cp++ != '"') {
		error ("string spec missing starting '\"'");
		free (newp);
		return (NULL);
	}
	for (; *cp ; ++cp) {
		if (*cp == '"')
			break;
		if (*cp == '\\')
			switch (*++cp) {
			case 0:
				error ("string spec missing ending '\"'");
				free (newp);
				return (NULL);
			case 'b':
				*mp++ = 010;	/* Backspace */
				continue;
			case 'f':
				*mp++ = 014;	/* Form Feed */
				continue;
			case 'n':
				*mp++ = '\n';
				continue;
			case 'r':
				*mp++ = '\r';
				continue;
			case 't':
				*mp++ = '\t';
				continue;
			case '\\':
				*mp++ = '\\';
				continue;
			case '"':
				*mp++ = '"';
				continue;
			case '0':
				num = 0;
				cnt = 3;
				while (*++cp>='0' && *cp<='7' && cnt--) {
					num <<= 3;
					num |= (*cp-'0');
				}
				*mp++ = num;
				--cp;
				continue;
			default:
				*mp++ = *cp;
			}
		else
			*mp++ = *cp;
	}
	*mp++ = '\0';
	if (*cp != '"') {
		error ("string spec missing ending '\"'");
		free (newp);
		return (NULL);
	}
	return (newp);
}

prefix (pref, term)
char	*pref;
char	*term;
{
	while (*pref)
		if (*pref++ != *term++)
			return (!SAME);
	return (SAME);
}

getval (strp, hwordp, rp)	/* return value of strp in *hwordp */
register char	*strp;
WORD	*hwordp;						
struct	relocation *rp;
{
	extern	double	atof();					
	extern  char	*strchr();			
	register struct	nlist	*np;
	register char	*cp;
	char	savesign;
	char	sign;
	int	ret;
	int	rettmp;
	long	ltmp;
	short	expsw  = 0;	/* 0= int expression, 1= float */
				/* NOTE: the existence of float	*/
				/* means the expression must be fl. */
	double	fpn = 0;
	WORD	hw;					

	DEBUG (6, "getval(%s);\n", strp);			
	rp->r_type = -1;					
	rp->r_address = *addrp;
	ret = SHORTNUM;
	*hwordp = 0;				
	sign = '+';

	do {
		if (*strp == '+' || *strp == '-')
			sign = *strp++;
		cp = strp;
		while (*strp != '\0' && ((*strp != '-' && *strp != '+') ||
		    (isdigit(*cp) && (*(strp-1) == 'E' || *(strp-1) == 'e'))))
			strp++;
		savesign = *strp;
		*strp = '\0';
		DEBUG (8, "getval(): term (%s)\n", cp);
		/* if it's a number, convert it */
		if (isdigit (*cp) || (*cp == 'x' && *(cp+1) == '\'') ||
			(*cp == 'X' && *(cp+1) == '\'')) {
		   if ( expsw || (((strchr(cp, 'E') !=0) ||	
		      (strchr(cp,'e')!=0) ||			
		      ((strchr(cp,'.') < (strchr(cp,'\0')-1))&& strchr(cp,'.')))
		      && (strchr(cp,'x') == 0) && (strchr(cp,'X') == 0)))
			{ 					
			DEBUG (10,"\tcp is %s\n", cp);		
			atof(fpn, cp);

			if (expsw == 0)				
				fpn = (float)fpn;
			expsw = 1;				
		   } else {	/* not floating point */	
			rettmp = getbnum (cp, &hw);		
			ltmp = hw;		
			if (rettmp != SHORTNUM)
				ret = rettmp;
			if (rettmp == -1)
				return (-1);
		   }						
		} else if (*cp == '$') {
			ltmp = *addrp;
			if (ltmp > MAXSHORT)
				ret = LONGNUM;
		} else {	/* else it must be a name */
			/* if get can't find it, it's undefined */
			if ((np = get (cp)) == NULL) {
			/* if undefined aren't external, they're illegal */
				if (! dfltextern) {
				   error ("Use of undefined symbol (%s)", cp);
					return (-1);
				} else {
					/* if undefined are external, make it external */
					np = new (cp);
					np->n_type = N_EXTERN;
				}
			}
			ltmp = ((np->n_type & N_TYPE) == N_UNDEF) ?
				  0L : np->n_value;
			hw = ltmp;		
			if (expsw)				
				ltmp = ltmp;
			DEBUG(8,"getval(): found symbol with value 0x%0lx\n",
			       np->n_value);
			if (np->n_type != N_ABS) {
				/*
				 *  If this is a text address, convert to
				 *  a word address as program memory is
				 *  only accessed with word addresses.
				 */
				if ((np->n_type&N_TYPE) == N_TEXT) {
				    DEBUG(8,"ltmp 0x%08lx, ",ltmp);
				    hw = ltmp;		
				    DEBUG(8,"hw 0x%08lx\n", ltmp);
				}
				if ((rp->r_type != -1) && ((sign == PLUS)
				    || (np->n_type&N_TYPE) == N_UNDEF
				    || (rp->r_type&N_TYPE) == N_UNDEF)) {
					DEBUG(4,"symbol # = %u",rp->r_symnum);
					DEBUG(4,"  type = 0%o",rp->r_type);
					DEBUG(4,"  np sym# = %u", np->n_symnum);
					DEBUG(4,"  np n_type = 0x%x\n",np->n_type);
					error ("Unresolvable combination");
					return (-1);
				}
				if (rp->r_type == -1) {	
					if ((np->n_type&N_TYPE) == N_UNDEF) {
						rp->r_type = R_BSYM;
						rp->r_symnum = np->n_symnum;
					} else {
						rp->r_type = np->n_type & N_TYPE;
						rp->r_symnum = 0;
					}
				} else
					rp->r_type = -1;	
			}
			if (ltmp < 0 || ltmp > MAXSHORT)
				ret = LONGNUM;
		}
		if (expsw)					
		{
			if(sign == '+')
				*hwordp += (float)fpn;
			else
			{
				/* perform unary minus on termval */
				*hwordp = -(float)fpn;
			}
		}
		else {					
			if (sign == '+')
				*hwordp += ltmp;
			else
				*hwordp -= ltmp;
		DEBUG(8,"\tloop: hwordp 0x%08x\n",*hwordp);
		}
	*strp = savesign;					
	} while (savesign != '\0');
	DEBUG (8,"Getval(): Final number is 0x%08x\n",*hwordp);
	if (expsw)					
	   ret = FLOATNUM;					
	return (ret);
}

getbnum(strp, hwp) 	/* get 64 bit number in WORD structure */

WORD	*hwp;
char	*strp;

{
	short	base;
	short	maxdigit = 0;
	char	c;
	char	sign;
	short	sym = SHORTNUM;
	short	ndigit = 0;
	int32	tnum=0;

	DEBUG(4,"getbnum(%s, ", strp);			
	DEBUG(4,"%08x);", hwp);			

	*hwp=0;
	sign = '+';
	if (*strp == '+' || *strp == '-') {
		sign = *strp++;
	}
	base = 10;
	if (*strp == '0')
		base = 8;

	DEBUG (7, "getbnum: starting base %d\n", base);

	while (1) {
		c = *strp++;
		if (isdigit(c) || (base==16 && isxdigit(c))) {
			if (base == 8) tnum <<= 3;
			else if (base == 10) {
				tnum *= 10;
			}

			else tnum <<= 4;

			if (isdigit(c) ) c -= '0';
			else if (c >= 'a') c -= 'a'-10;
			else c -= 'A'-10;
			tnum += c;
			ndigit++;
			if (c > maxdigit) maxdigit = c;
			continue;
		}
		if (c == '\'')continue;
		if (c == 'b' || c == 'B')continue;
		if (c == 'h' || c == 'H') {
			tnum <<= 1;
			continue;
		}
		if (c == 'w' || c == 'W') {
			tnum <<= 2;
			continue;
		}
		if (c == 'd' || c == 'D') {
			tnum <<= 3;
			continue;
		}
		if (c == 'f' || c == 'F') {
			tnum <<=5;
			continue;
		}
		if (c == '.') {
			/*
			 * If nothing follows, then allow decimal notation
			 * of the form "<number>."
			 */
			if (base == 16 || *strp) {
				DEBUG (8, "getnum: dot error\n", 0);
				error("number error");
				return (-1);
			}
			c = 0;
			break;
		}
		if (c == 'x' || c == 'X') {
#ifdef JUNK
			if (base != 8 || tnum !=0 || sym != SHORTNUM) {
				error("Hex error");
				return (-1);
			}
#endif
			base = 16;
			continue;
		} else if ((c == 'l' || c == 'L') && sym == SHORTNUM) {
			sym = LONGNUM;
			break;
		}
#ifdef JUNK
		  else
			break;
#endif
		if (ndigit == 0) {
			error ("No digits??");
			return (-1);
		}
		break;
	}
	if (c != '\0' || maxdigit >= base) {
		error("Number syntax");
		return (-1);
	}
	if (sym == SHORTNUM && tnum >= maxi) {
		sym = LONGNUM;
	}
	*hwp = tnum;
	if (sign == '-') {
		*hwp = -*hwp;
	}
	DEBUG (8,"Got number (0x%08lx)\n", *hwp);
	return (sym);

}

/*
 *	Getnum() adapted from the Ritchie C Compiler
 */
getnum(strp, longp)
register char	*strp;
long	*longp;
{
	WORD	hpword;
	short	sym;

	DEBUG(4,"getnum(%s, ", strp);			
	DEBUG(4,"%08x);\n", longp);				
	DEBUG(4,"\t&hpword is %08x\n", &hpword);
	sym = getbnum (strp, &hpword);
	DEBUG(4,"\tgetnum: ..lhw is %d, ", hpword);	
	*longp = hpword;			
	DEBUG(4," returning %d\n", *longp);		
	return(sym);
}
