/*~!DO2PSEUDO.C*/
/* Name:  DO2PSEUDO.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			   D O 2 P S E U D O . C
 *
 *			      Revision History
 *			      ----------------
 */
#include	<ctype.h>
#include	"has.h"

extern	short	debug;
extern	short	curspace;
extern	long	*addrp;
extern	long	dataaddr;
extern	long	textaddr;
extern	long	bssaddr;
extern	struct output	dataout;
extern	struct output	textout;
extern	struct output	*curout;
extern	struct nlist *get();
extern	char	*rdstring();
extern	short	listing;
extern  struct  nlist	*curlabp;
extern  short	linenumber;
short	out1, out2;

do2equ (token, fieldp)
char	*token;
register char	**fieldp;
{
	int32	hw;
	struct	relocation	rp;

	if (curlabp == NULL) {
		error ("equ missing label");
		return (-1);
	}
	if (*(++fieldp) == 0) {
		error ("equ missing symbol and value");
		return (-1);
	}
	if ((getval(*fieldp, &hw, &rp)) < NULL) {
		error ("Undefined equ value");
		return (-1);
	}

	out1 = (short)(hw >> 16);
	out2 = (short)hw;

	if( listing ) {
		prtloc();
		prtss(out1, out2);
	}
	return(0);
}

do2data ()
{
	addrp = &dataaddr;
	curspace = N_DATA;
	curout = &dataout;
	prtloc();
	prtbb();
}

do2text ()
{
	addrp = &textaddr;
	curspace = N_TEXT;
	curout = &textout;
	prtloc();
	prtbb();
}

do2bss ()
{
	addrp = &bssaddr;
	curspace = N_BSS;
	curout = NULL;
	prtloc();
	prtbb();
}

do2align (token, fieldp)
char	*token;
register char	**fieldp;
{
	int	k;

	if (*(++fieldp) == 0) {
		error ("bound missing arg");
		return (-1);
	}
	k = align2 (aligndecode (*fieldp));
	prtloc();
	prtbb();
	return (k);
}

char	*nothing = "\0\0\0\0\0\0\0\0";

align2 (where)
int	where;
{
	register short remain;

	DEBUG (7, "Align2: addr is %0lx\n", *addrp);
	remain = (short)((*addrp + (where-1) & ~(where-1)) - *addrp );
	switch (where) {
	case N_AFILE:
	case N_AFWORD:
	case N_AHWORD:	
	case N_AQWORD:
		DEBUG (7, "Addr aligned to %x\n", where);
		DEBUG (7, "Addr aligned by adding %d\n", remain);
		if (curspace == N_BSS)		
			*addrp += (long)remain;
		else						
		    dumpstr (nothing, remain);
		break;
	case N_ABYTE:
		break;
	default:
		error ("illegal bound arg");
		return (-1);
	}
	DEBUG (7, "align2: now addr is %0lx\n", *addrp);
	return (0);
}

do2rez (token, fieldp)
char	*token;
char	**fieldp;
{
	WORD	w;
	short	numlocs;
	short	savlist;

	if ((evalqword (fieldp[1], &numlocs)) < 0 || numlocs <= 0) {
		error ("illegal rez value");
		return (-1);
	}
	if (curspace == N_TEXT) {
		numlocs--;
		dump4qw (0, 0, 0, 0);
		savlist = listing;
		listing = 0;
  		while (numlocs--) {
			dump4qw (0, 0, 0, 0);
 		} ;
		listing = savlist;
		return(0);
	}
	if (curspace != N_BSS) {
		w = 0L;
		while (numlocs > (sizeof (WORD) - 1)) {
			dumphword (&w);
			numlocs -= sizeof (WORD);
		}
		if (numlocs > 0L)
			dumpstr ((char*)&w, (short)numlocs);
	} else
		/* BSS is always 0 so no need to dump it */
		*addrp += numlocs;
	prtbloc();
	return(0);
}

do2zero (token, fieldp)
char	*token;
register char	**fieldp;
{
	int32	w;
	int32	howmuch;

	DEBUG(2,"do2zero( ,%s);\n", fieldp[1]);			
	prtloc ();						
	getnum (*(++fieldp), &howmuch);
	DEBUG(3,"\tdo2zero: howmuch is %d", howmuch);		
	if (curspace != N_BSS) {
		w = 0;
		while (howmuch > (sizeof (WORD) - 1)) {
			dumpstr((char*)&w, (short) sizeof(WORD));	
			howmuch -= sizeof (WORD);
		}
		if (howmuch > 0L)
			dumpstr ((char*)&w, (short) howmuch);
	} else
		/* BSS is always 0 so no need to dump it */
		*addrp += howmuch;
	prtbloc();
}

do2string(token, fieldp)
char	*token;
register char	**fieldp;
{
	register char *cp;

	DEBUG (4,"do2string( ,%s);\n", fieldp[1]);
	cp = rdstring (*(++fieldp));
	if (cp == NULL)
		return (-1);
	prtloc ();					
	prtbb();
	if (strcmp (token, ".astring") == NULL)  /* if equal */	
	   dumpstr (cp, (short) strlen(cp));	/* dump w/o null */
	else							
	   dumpstr (cp, (short) strlen(cp)+1); /* Add one for the NULL */
	free (cp);
	return (0);
}

do2fword (token, fieldp)
char	*token;
register char	**fieldp;
{
/*	WORD	fword; */
	double	fword; 
	struct	relocation reldata;
	short l;

	DEBUG(3,"do2fword( ,%s);\n", fieldp[1]);		

	l=0;
	++fieldp;
	align2 (N_AFWORD);
	while (*fieldp) {
		if (evalfword (*fieldp, &fword, &reldata))
			return (-1);
		if (reldata.r_type != -1) {			
			reldata.r_length = R_FWORD;
			dumpreloc (&reldata);
		}
		if( listing ) {
			if( l ) printf("\n");
			l++;
 	       }
		dumpfword (&fword);
		fieldp++;
	}
	return (0);
}

do2hword (token, fieldp)
char	*token;
register char	**fieldp;
{
	struct	relocation reldata;
	int32	hword;
	short	l;

	DEBUG(3,"do2hword( ,%s);\n", fieldp[1]);		

	++fieldp;
	l = 0;
	align2 (N_AHWORD);
	while (*fieldp) {
		if (evalhword (*fieldp, &hword, &reldata))
			return (-1);
		if (reldata.r_type != -1) {			
			reldata.r_length = R_HWORD;
			dumpreloc (&reldata);
		}
		if( listing ) {
			if( l ) printf("\n");
			l++;
		}
		dumphword (hword);
		fieldp++;
	}
	return (0);
}

do2qword (token, fieldp)
char	*token;
register char	**fieldp;
{
	short	qword;
	short   l;

	++fieldp;
	l = 0;
	align2 (N_AQWORD);
	while (*fieldp) {
		if (evalqword (*fieldp, &qword))
			return (-1);
		if( listing ) {
			if( l ) printf("\n");
			l++;
		}
		dumpqword (qword);
		fieldp++;
	}
	return (0);
}

do2byte (token, fieldp)
char	*token;
register char	**fieldp;
{
	char	byte;

	++fieldp;
	while (*fieldp) {
	    if (evalbyte (*fieldp, &byte))
		return (-1);
	    if (listing) /* list bytes */			
		{ };	/* not yet */				
		dumpstr (&byte, (short) 1);			
		fieldp++;
	}
	prtbloc();
	return (0);
}

do2loc (token, fieldp)
char	*token;
register char	**fieldp;
{
	WORD	w;
	long	delta;						
	long	newloc;						

	DEBUG(4,"do2loc( ,%s);\n", *fieldp);			
	DEBUG(10,"\t&newloc is 0x%08x\n", &newloc);		

	if (getnum (*++fieldp, &newloc) == -1)
		return (-1);
	DEBUG(10,"\tdo2loc: newloc is %d\n", newloc);		
	if (newloc < *addrp) {
		error (".loc goes backwards (pass2)");
		return (-1);
	}
	DEBUG(10,"\tdo2loc: newloc is %d, ", newloc);		
	DEBUG(10,"*addrp is %d, ", *addrp);			
	delta = newloc - *addrp;				
	DEBUG(10,"delta is %d\n", delta);			
	if (delta > 0L) {
		w = 0;					
		while (delta > (sizeof (WORD) - 1)) {
			dumpfword (&w);
			delta -= sizeof (WORD);
		}
		if (delta > 0L)
			dumpstr ((char*)&w, (short) delta);
	}
	prtbloc();
	return (0);
}

do2line (token, fieldp)
char	*token;
register char	**fieldp;
/*
 *	Write line number and relative address to symbol table
 *	used by symbolic debugger.
 */
{
	int32	got;						
	int	sourline;
	int	locat;
	extern	FILE	*o_astf;
	extern	short	symdebug;

	++fieldp;

	if (symdebug) {

		getnum (*fieldp, &got);				
		sourline = ((int) got);		

		locat = ((int)(textaddr));		

		fwrite (&sourline, sizeof (sourline), 1, o_astf);
		fwrite (&locat, sizeof (locat), 1, o_astf);
	}
}

do2end (token, fieldp)
char *token;
char **fieldp;
{
	align2 (N_AHWORD);
	return (do2lpool(token, fieldp));
}

do2lpool (token, fieldp)
char *token;
char **fieldp;
{
	extern short numsyms;
	extern short lpi;
	extern struct nlist	*symlist[];
	int	i;
	struct	nlist	*np;
	struct  relocation reldata;
	int32	hword;
	int	l;

	align1 (N_AHWORD);
	l=0;
	for (i=0; i<numsyms; i++) {
		np = symlist[i];
	DEBUG(1,"do2lpool: looking at symbol %s\n", np->n_name);			
		if (((np->n_type & N_TYPE) == N_CONSTA) && (np->n_name[0] == '=')) {
			if (np->n_spare != lpi)continue;
			if ((evalhword(&np->n_name[1], &hword, &reldata)) == -1)
				continue;
	DEBUG(1,"do2lpool: symbol value %lx\n", hword);			
			if (reldata.r_type != -1) {			
				reldata.r_length = R_HWORD;
				dumpreloc (&reldata);
			}
			if( listing ) {
				if( l ) printf("\n");
				l++;
			}
			dumphword (hword);
			np->n_type = N_CONST;	/* this a literal pointer */
		}
	}
	lpi++;
	if( listing )  {
		prtloc();
		prtbb();
	}
	return (0);
}

prtloc ()							
{								
if (!listing)							
    return;							
switch (curspace)						
    {
    case N_TEXT: printf("%04d Text %06lx ",linenumber, *addrp);
	break;
    case N_DATA: printf("%04d Data %06lx ",linenumber, *addrp);
	break;
    case N_BSS:  printf("%04d BSS  %06lx ",linenumber, *addrp);
	break;
    default:  error ("illegal address space");
    }
} /* end of prtloc */					

int	prtss(s1, s2)
short	s1;
short	s2;
{

	if (listing)
		printf("%04x %04x ",s1 & 0xffff, s2 & 0xffff);
}

int	prtbs(s1)
short	s1;
{

	if (listing)
		printf("     %04x ",s1 & 0xffff);
}

int	prtsb(s1)
short	s1;
{

	if (listing)
		printf("%04x      ",s1 & 0xffff);
}

int	prtbb()
{

	if (listing)
		printf("          ");
}

int	prtbloc()
{

	if (listing)
		printf("%04d                       ",linenumber);
}
