/*~!CODES.C*/
/* Name: CODES.C Part No.: _______-___r
 *
 *				SOFTWARE ENGINEERING
 *
 *  The recipient of this product specifically agrees not to distribute,
 *  disclose, or disseminate in any way, to any one, nor use for its own
 *  benefit, or the benefit of others,  any information contained herein
 *  without the expressed written consent of Software Engineering.
 */
/*							*/
/*
 *			 I S C   A s s e m b l e r
 *
 *			      C O D E S . C
 *
 *			     Revision History
 *			     ----------------
 */

#include <stdio.h>
#include "has.h"

int32	textaddr;		/* Location counter for text space */
int32	dataaddr;		/* Location counter for data space */
int32	bssaddr;		/* Location counter for bss space */
int32	*addrp;			/* Pointer to the current location counter */
short	curspace;		/* The N_TYPE value for the current space */
int32	trsize;			/* Size of text relocation data */
int32	drsize;			/* Size of data relocation data */
FILE	*reltfile;		/* Text relocation info file */
FILE	*reldfile;		/* Data relocation info file */
short	numsyms;		/* The number of symbols defined */
short	dfltextern = 0;	/* Set if undefines become externals */
short	debug = 0;		/* Debugging control */
short	symdebug = 0;	/* set for creation of symbol & line number
				   		   file for symbolic debugger */
int	totallines = 0;		/* total # of .line pseudo ops encountered */

/* following table for pseudops */

int	do1define();
int	do1data(), do2data();
int	do1text(), do2text();
int	do1bss(), do2bss();
int	do1common();
int	do1global();
int	do1align(), do2align();
int	do1zero(), do2zero();
int	do1rez(), do2rez();
int	do1string(), do2string();
int	do1fword(), do2fword();
int	do1hword(), do2hword();
int	do1qword(), do2qword();
int	do1byte(), do2byte();
int	do1loc(), do2loc();
int	do1line(), do2line();
int do1lpool(), do2lpool();
int	do1end(), do2end();

int	do1equ(), do2equ();

struct pscdata pseudocodes[] = {
	"abs",		NULL,		NULL,
	"acb",		NULL,		NULL,
	"ach",		NULL,		NULL,
	"acw",		NULL,		NULL,
	"acd",		NULL,		NULL,
	"bound",	do1align,	do2align,
	"common",	do1common,	NULL,
	"csect",	do1text,	do2text,
	"data",		do1byte,	do2byte,
	"datab",	do1byte,	do2byte,
	"datad",	do1fword,	do2fword,
	"datah",	do1qword,	do2qword,
	"dataw",	do1hword,	do2hword,
	"def",		do1define,	NULL,
	"dsect",	do1data,	do2data,
	"end",		do1end,		do2end,
	"equ",		do1equ,		do2equ,
	"ext",		do1global,	NULL,
	"gen",		NULL,		NULL,
	"list",		NULL,		NULL,
	"lpool",	do1lpool,	do2lpool,
	"org",		do1loc,		do2loc,
	"page",		NULL,		NULL,
	"program",	NULL,		NULL,
	"rel",		NULL,		NULL,
	"res",		do1rez,		do2rez,
	"rez",		do1rez,		do2rez,
	"space",	do1line,	do2line,
	"title",	NULL,		NULL,
	"zero",		do1zero,	do2zero,
	"\177\177",	0,		0
};

/* following table for halfword instructions */

int	noarg();
int	d();
int	ds1();
int	ds2();
int	ds1s2();
int	ds2s1();
int	s1s2();

struct sdata easycodes[] = {
	"abr",		ds2,
	"adr",		ds1s2,
	"adrm",		ds1s2,
	"anr",		ds1s2,
	"bei",		noarg,
	"car",		ds1s2,
	"cea",		noarg,
	"cmr",		ds1s2,
	"dae",		noarg,
	"dvr",		ds1s2,
	"eae",		noarg,
	"eor",		ds1s2,
	"eorm",		ds1s2,
	"es",		ds1,
	"halt",		noarg,
	"lcs",		ds1,
	"mpr",		ds1s2,
	"nop",		noarg,
	"nor",		ds2s1,
	"nord",		ds2s1,
	"orr",		ds1s2,
	"orrm",		ds1s2,
	"rnd",		ds1,
	"sbr",		ds2,
	"sea",		noarg,
	"scz",		ds2s1,
	"sla",		s1s2,
	"slad",		s1s2,
	"slc",		s1s2,
	"sll",		s1s2,
	"slld",		s1s2,
	"sra",		s1s2,
	"srad",		s1s2,
	"src",		s1s2,
	"srl",		s1s2,
	"srld",		s1s2,
	"sur",		ds1s2,
	"surm",		ds1s2,
	"tbr",		ds2,
	"trc",		ds1s2,
	"trcm",		ds1s2,
	"trn",		ds1s2,
	"trnm",		ds1s2,
	"trr",		ds1s2,
	"trrm",		ds1s2,
	"trsc",		ds1s2,
	"trsw",		ds1,
	"tscr",		ds1s2,
	"uei",		noarg,
	"wait",		noarg,
	"xcr",		ds1s2,
	"xcrm",		ds1s2,
	"zbr",		ds2,
	"zr",		d,
	"\177",		0
};

/* following table for fullword instructions */

int	h_b();
int	h_svc();
int	h_mr();
int	h_imd();
int	h_m();
int	h_n();
int	h_v1();

/*
 *  The ordering of this table is important.  The first string matched
 *  will be the way the opcode is interpreted.  For example, 'create'
 *  must come before 'cr'.
 */
struct sdata hardcodes[] = {
	"abm",		h_n,
	"adf",		h_mr,
	"adi",		h_imd,
	"adm",		h_mr,
	"anm",		h_mr,
	"arm",		h_mr,
	"b",		h_b,
	"cam",		h_mr,
	"ci",		h_imd,
	"cmm",		h_mr,
	"dvf",		h_mr,
	"dvi",		h_imd,
	"dvm",		h_mr,
	"eom",		h_mr,
	"exm",		h_mr,
	"exr",		h_v1,
	"li",		h_imd,
	"lm",		h_mr,
	"ln",		h_mr,
	"lp",		h_m,
	"l",		h_mr,
	"mpf",		h_mr,
	"mpi",		h_imd,
	"mpm",		h_mr,
	"orm",		h_mr,
	"sbm",		h_n,
	"stm",		h_mr,
	"st",		h_mr,
	"suf",		h_mr,
	"sui",		h_imd,
	"sum",		h_mr,
	"svc",		h_svc,
	"tbm",		h_n,
	"zbm",		h_n,
	"zm",		h_m,
	"\177",		0
};
