/*A.OUT.H*/
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */

#ifndef	INCLUDE_A_OUT_H
#define	INCLUDE_A_OUT_H
#if	defined(RCSID) && !defined(lint)
static char *include_a_out_hrcsid = "@(#) (Gould) $Header: a.out.h,v 1.9 86/07/28 08:24:02 root UTX/32-2_0 $";
#endif	RCSID

/* This is a quickie combination of the PN and NP1 files, which should be
   superceded by something more reasonable from the languages group. */

#ifdef GOULD_PN
/* 	@(#) UTX/32 1.3  a.out.h ver 1.3 */

/* A.OUT.H SHOULD BE MADE TO REFLECT THE 4.3 VERSION.  THIS WILL HAVE
 * TO WAIT UNTIL THE KERNEL GROUP CREATES A SYS/EXEC.H HEADER FILE.
 */

/*
 * Header prepended to each a.out file.
 */
struct exec {
	long		a_magic;	/* magic number */
	unsigned	a_text;		/* size of text segment */
	unsigned	a_data;		/* size of initialized data */
	unsigned	a_bss;		/* size of uninitialized data */
	unsigned	a_syms;		/* size of symbol table */
	unsigned	a_entry;	/* entry point */
	unsigned	a_trsize;	/* size of text relocation */
	unsigned	a_drsize;	/* size of data relocation */
#ifdef	gould
	/* ---- old style header above, new for SEL Base Reg UNIX below --- */

	unsigned	a_stsize;	/* size of string table */
	unsigned	a_txbase;	/* load address of text,
					   determines stack size */
	unsigned	a_nbtext;	/* size of "far" part of text */
	unsigned	a_nbdata;	/* size of "far" part of data */
	unsigned	a_nbbss;	/* size of "far" part of bss */
	unsigned	a_tstamp;	/* time and date stamp */
	unsigned	a_mstamp;	/* target machine stamp */
	unsigned	a_sstamp;	/* target operating system stamp */
	unsigned	a_ccvers;	/* oldest compiler version stamp */
	unsigned	a_asvers;	/* oldest assembler version stamp */
	unsigned	a_ldvers;	/* oldest loader version stamp */
#endif	gould
};

#define	OMAGIC	0407	/* old impure format */
#define	NMAGIC	0410	/* read-only text */
#define	ZMAGIC	0413	/* demand load format */


/*
 * Macros which take exec structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 * Note that the a_text includes a_nbtext; likewise for data and bss.
 */
#define	N_BADMAG(x)  \
    (((x).a_magic)!=OMAGIC && ((x).a_magic)!=NMAGIC && ((x).a_magic)!=ZMAGIC)

#ifdef	gould
/*
 * ZMAGIC files now include the struct exec header as part of the text segment.
 * The size of the header is included in exec.a_text and the offset to the
 * beginning of text is zero.  Programs that need to locate the text of the 1st
 * object loaded in a ZMAGIC file should use ZTXTOFF.
 */
#define	ZTXTOFF ((((sizeof (struct exec))+((sizeof (double))-1))/(sizeof (double)))*(sizeof (double)))
#define	N_TXTOFF(x)  \
	((x).a_magic==ZMAGIC ? 0 : sizeof (struct exec))
#else	not gould
#define	N_TXTOFF(x)  \
	((x).a_magic==ZMAGIC ? 1024 : sizeof (struct exec))
#endif	gould

#define N_SYMOFF(x)  \
	(N_TXTOFF(x) + (x).a_text+(x).a_data + (x).a_trsize+(x).a_drsize)
#define	N_STROFF(x)  \
	(N_SYMOFF(x) + (x).a_syms)

#ifdef	gould
/*
 * It would be best to include <nlist.h> here and avoid a duplicate definition
 * of the nlist structure.  Unfortunately, with the advent of the string table
 * version of symbol tables, usage has diverged.  Those commands that convert
 * string indices to pointers use the union declaration here, while commands
 * that have statically initialized symbol table entries must use the union-
 * less version found in <nlist.h>.
 *
 * NOTE that changes here must be reflected in <nlist.h>.
 */
#endif	gould

/*
 * Structure of a symbol table entry, as used by <a.out.h>.  This version
 * is used when stuff can be both on disc and in core.
 */
struct nlist
{
	union
	{
		char	*n_name;	/* for use when in-core */
		long	n_strx;		/* index into file string table */
	} n_un;
	unsigned char	n_type;		/* type flag, see defines below */
	char	n_other;
	short	n_desc;			/* see <stab.h> */
	unsigned	n_value;	/* value of this symbol */
					/* or size if common or stab offset */
};

#define	n_hash	n_desc			/* used internally by ld */
#ifdef	gould
/*
 * Common symbols need to be marked NOBASE between as and ld, but the n_type
 * field can't be used (symbol needs to stay N_UNDEF|N_EXT).  A non-zero
 * value for this field means that there are no memref relocations to this
 * symbol in a .o file.  If all .o files reference the symbol have non-zero
 * n_nobase fields, then ld will allocate common storage for the symbol in
 * the nbbss segment.
 */
#define	n_nobase	n_other		/* make comm symbol NOBASE */
#endif	gould

/*
 * Simple values for n_type.
 */
#define	N_UNDF	0x0	/* undefined */
#define	N_ABS	0x2	/* absolute */
#define	N_TEXT	0x4	/* text */
#define	N_DATA	0x6	/* data */
#define	N_BSS	0x8	/* bss */
#ifdef	gould
#define	N_NBTEXT  0xa	/* far text */
#define	N_NBDATA  0xc	/* far data */
#define	N_NBBSS	0xe	/* far bss */
#define	N_NBCOM	0x14	/* far common */
#endif	gould
#define	N_COMM	0x12	/* common */
#define	N_FN	0x1f	/* file name symbol */
#define	N_EXT	01	/* external bit, or'ed in */
#define	N_TYPE	0x1e	/* mask for all the type bits */

/*
 * Other permanent symbol table entries have some of the N_STAB bits set.
 * These are given in <stab.h>
 */

#define	N_STAB	0xe0	/* if any of these bits set, don't discard */

/*
 * Format for namelist values.
 */
#define	N_FORMAT	"%08x"

/*
 * Format of a relocation datum.
 */
struct relocation_info
{
	int	r_address;		/* address which is relocated */
	unsigned	r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 		/* was relocated pc relative already *
		r_length:2,		/* 0=8bits,1=16bits,2=32bits,3=64bits */
		r_extern:1,		/* value relative to sym referenced */
#ifdef	gould
		r_type:4;		/*	0=const,
						1=addr literal,
						2=mem ref inst */
#else	not gould
		:4;			/* nothing, yet */
#endif	gould
};

#ifdef	gould
#define	R_BYTE		0
#define	R_HALFWORD	1
#define	R_WORD		2
#define	R_DOUBLEWORD	3

#define	R_CONST		0
#define	R_ADDRLITERAL	1
#define	R_MEMREFINST	2
#endif	gould

#endif GOULD_PN

#ifdef GOULD_NP1
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * Version for Gould NP1
 */

/*
 * Definitions of the a.out header
 * and magic numbers are shared with
 * the kernel.
 */
#include <sys/exec.h>

/*
 * Macros which take exec structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 * Note that the a_text includes a_nbtext; likewise for data and bss.
 */
#define	N_BADMAG(x \
    (((x).a_magic)!=OMAGIC && ((x).a_magic)!=NMAGIC && ((x).a_magic)!=ZMAGIC)

#ifdef GOULD_NP1
/*
 * ZMAGIC files now include the struct exec header as part of the text segment.
 * The size of the header is included in exec.a_text and the offset to the
 * beginning of text is zero.  Programs that need to locate the text of the 1st
 * object loaded in a ZMAGIC file should use ZTXTOFF.
 */
#define SUBSEGALIGN 16		/* all segments must be rounded up to this
				   size to ensure quadword alignment */
#define	ZTXTOFF ((((sizeof (struct exec))+(SUBSEGALIGN-1))/SUBSEGALIGN)*SUBSEGALIGN)
#define	N_TXTOFF(x)  \
	((x).a_magi===ZMAGIC ? 0 : sizeof (struct exec))
#else
#define	N_TXTOFF(x) \
	((x).a_magic==ZMAGIC ? 1024 : sizeof (struct exec))
#endif GOULD_NP1

#define N_SYMOFF(x) \
	(N_TXTOFF(x) + (x).a_text+(x).a_data + (x).a_trsize+(x).a_drsize)
#define	N_STROFF(x) \
	(N_SYMOFF(x) + (x).a_syms)

/*
 * Format of a relocation datum.
 * It would be best to include <nlist.h> here and avoid a duplicate definition
 * of the nlist structure.  Unfortunately, with the advent of the string table
 * version of symbol tables, usage has diverged.  Those commands that convert
 * string indices to pointers use the union declaration here, while commands
 * that have statically initialized symbol table entries must use te union-
 * less version found in <nlist.h>.
 *
 * NOTE that changes here must be reflected in <nlist.h>.
 */
struct relocation_info {
	int	r_address;	/* address which is relocated */
unsigned int	r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* was relocated pc relative already */
		r_length:2,	/* 0=byte, 1=word, 2=long */
		r_extern:1,	/* does not include value of sym referenced */
#ifdef	GOULD_NP1
		r_type:4;		/*	0=const,
						1=addr literal,
						2=mem ref inst */
#else	not GOULD_NP1
		:4;			/* nothing, yet */
#endif	GOULD_NP1
};

#ifdef	GOULD_NP1
#define	R_BYTE		0
#define	R_HALFWORD	1
#define	R_WORD		2
#define	R_DOUBLEWORD	3

#define	R_CONST		0
#define	R_ADDRLITERAL	1
#define	R_MEMREFINST	2
#define R_LIL		3
#define R_TRUNC_CONST   4
#endif	GOULD_NP1

/*
 * Structure of a symbol table entry, as used by <a.out.h>.  This version
 * is used when stuff can be both on disc and in core.
 */
struct nlist
{
	union
	{
		char	*n_name;	/* for use when in-core */
		long	n_strx;		/* index into file string table */
	} n_un;
	unsigned char	n_type;		/* type flag, e.g. N_TEXT; see below */
	char	n_other;		/* mostly unused */
	short	n_desc;			/* see <stab.h> */
	unsigned long	n_value;	/* value of symbol */
					/* or size if common or stab offset */
};
#define	n_hash	n_desc		/* used internally by ld */

#ifdef GOULD_NP1
/*
 * Common symbols need to be marked NOBASE between as and ld, but the n_type
 * field can't be used (symbol needs to stay N_UNDEF|N_EXT).  A non-zero
 * value for this field means that there are no memref relocations to this
 * symbol in a .o file.  If all .o files reference the symbol have non-zero
 * n_nobase fields, then ld will allocate common storage for the symbol in
 * the nbbss segment.
 */
#define	n_nobase	n_other		/* make comm symbol NOBASE */
#endif	GOULD_NP1

/*
 * Simple values for n_type.
 */
#define	N_UNDF	0x0		/* undefined */
#define	N_ABS	0x2		/* absolute */
#define	N_TEXT	0x4		/* text */
#define	N_DATA	0x6		/* data */
#define	N_BSS	0x8		/* bss */
#ifdef	GOULD_NP1
#define	N_NBTEXT  0xa		/* far text */
#define	N_NBDATA  0xc		/* far data */
#define	N_NBBSS	0xe		/* far bss */
#define	N_NBCOM	0x14		/* far common */
#endif	GOULD_NP1
#define	N_COMM	0x12		/* common (internal to ld) */
#define	N_FN	0x1f		/* file name symbol */

#define	N_EXT	01		/* external bit, or'ed in */
#define	N_TYPE	0x1e		/* mask for all the type bits */

/*
 * Sdb entries have some of the N_STAB bits set.
 * These are given in <stab.h>
 */
#define	N_STAB	0xe0		/* if any of these bits set, a SDB entry */

/*
 * Format for namelist values.
 */
#define	N_FORMAT	"%08x"

#endif GOULD_NP1
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */
#endif	INCLUDE_A_OUT_H
