/*~!HRTD.C*/
/* Name:  HRTD.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of International Software Corp.
 *
 *                    RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

/*
 *	               I S C   R. T. D e b u g g e r
 *
 *		                H R T D . C
 *
 */

/*
 *******************************************************************************
 *
 * Copyright(C) International Software Corporation 1988. All rights reserved.
 *
 *(PDLSTART)
 *******************************************************************************
 *
 *               HRTD system module
 *
 *  Author       : JCBevier
 *  Date         : 22 August, 1989
 *  Revision     : 1.0
 *  Filename     : HRTD.C
 *
 *
 *  Revision History:
 *  -----------------
 *  1.0,  20-Sep-88, by tk  - Initial revision.
 *  1.0a, 10/05/88, by MJF, detailed design
 *  2.0,  12/01/88, by JCB, Initial code development.
 *  2.0a, 12/08/88, by JCB, Continue code development.
 *  2.1   08/22/89, by JCB, Revise include file
 *  2.2   09/07/89, by JCB, Revise SVC info
 *
 *  Functional description:
 *  -----------------------
 *
 *  This module is the interface between the RTD64 program that talks to
 *  the user, and the tasks running in the system.  RTD64 tasks place requests
 *  in the RTD64 partition, and then go to sleep.  H.RTD will wake up and
 *  process these requests, then go to sleep itself.
 *     The requests are:
 *       get data from a task or partition
 *       store data in a task or parition
 *       inquire about a task or parition
 *       wake up an RTD64 task
 *       break a task
 *       re-initialize (request comes either locally or remotely)
 *
 *  Note that the requests in the partition may be for various nodes that
 *  share the partition.  Each H.RTD64 will respond to requests concerning
 *  tasks in its node.  Realize that a request for information about data on
 *  node x, for example, may be requested by a copy of RTD64 running on node y.
 *
 *  Program definition:
 *  -------------------
 *
 *  H.RTD is an MPX system module, and is called via a HAT entry.  We may
 *  have the initialization entry point of H.RTD "steal" (commandeer?) the
 *  real-time clock interrupt.
 *
 *  Commons:
 *  --------
 *  H.RTD uses the RTDRTX common that RTD64 programs use.
 *
 *  Equates:
 *  --------
 *  All equates are internal.  See their definition in the program later.
 *
 *  Local variables
 *  ---------------
 *  See later in the program.
 *
 *******************************************************************************
 *(PDLEND)
 */

/*
 *******************************************************************************
 * this is an mpx handler written in 'c'
 *******************************************************************************
 */

asm ("hat dataw 1");            /* sysgen needs a hat */
asm (" acw sg.ini");            /* tell sysgen where to go */

#ifndef HRTD64
#define HRTD64
#endif
/* must define HRTD64 for correct include file info */
#include "^(rtd.inc)rtdnode.inc"
#include "^(rtd.inc)rtdprt.inc"
#include <cdots.h>
#include <dqe.h>
#include <tsa.h>
#include <smt.h>

#define TRUE    1
#define FALSE   0
#define LOGPADR RTDNODEP

/*
 * local subroutines
 */

static int * xlear();
static int * lear();
static void goumap();
static void gomap();

/*
 * Local variables
 */

static  int     initDone = FALSE; /* set non zero when init is all done */
static  int     nodenum = 0;      /* local node number */
static  int     ticksx1;          /* clock ticks in 1 seconds */
static  int     ticksx5;          /* clock ticks in 5 seconds */
static  int     ticksday;         /* clock ticks in a day (86400 secs) */
static  int     strtclk = 0;      /* starting clock ticks */
static  int     spsave;           /* save sp during resume call */
static  int*    realpadr;         /* real partition address */
static  int*    laddr = (int *)LOGPADR;  /* logical partition address */
static  struct dqe * dqeptr;      /* static pointer to dqe */
static  int     dqen;             /* temp dqe number */
static  struct tsa * tsaptr;      /* static pointer to tsa */
static  struct smt * smtptr;      /* static pointer to smt */

/* c defined in cdots.h include file as structure for cdot region*/
#define CDOTP ((struct c *)CDOTS)

/* t defined in tsa.h include file as structure for task tsa (c.tsad) */
#define TSAP (*(struct tsa **)C_TSAD)

/* smt defined in smt.h include file as structure for smt (c.smta) */
#define SMTP (*(struct smt **)C_SMTA)
/* smt entry size in bytes */
#define SMTS (*(char *)C_SMTS)
/* number of smt entries */
#define SMTN (*(char *)C_SMTN)

/* dqe defined in dqe.h include file as structure for task dqe */
/* following macro to get dqe addr given dqe num */
#define DQEP(n) (((struct adat *)C_ADAT)->dqe[n])
/* following macro to get current dqe address from C.CURR */
#define CDQE ((struct dqe *)(CDOTP->curr.sf))

/*
 *(PDL)  I.  Initialization (which may succeed, not precede, the following)
 *(PDL)      A.  Save real-time clock (rtc) interrupt handler address
 *(PDL)      B.  Store the address of step II. as the new rtc handler
 *(PDL)      C.  Calculate clock interrupts in 5 seconds and per day
 *(PDL)          set ticksx1 = (1 * C.MTIM)/C.NTIM
 *(PDL)          set ticksx5 = (5 * C.MTIM)/C.NTIM
 *(PDL)          set ticksday = (86400 * C.MTIM)/C.NTIM
 *(PDL)
 *(PDL) II.  On Each Timer Interrupt
 *(PDL)
 */
/* routine to handle clock interrupts */
/* entered at each clock int */
rtdclk()
{
  int     rtdn;           /* rtd64 program index */
  int     rtdindex;       /* index to first rtd entry */
  int     numf;           /* num entries found */

/*
 *(PDL)      if (initDone = FALSE)return;
 *(PDL)      A.  NodeBit++;
 *(PDL)      B.  Recover Lost Entries
 *(PDL)          if (five seconds since last check) {
 *(PDL)             for (every entry assigned to this node)
 *(PDL)                 if (RTD64 program still in system)
 *(PDL)                    ;
 *(PDL)                 else
 *(PDL)                    recover the entry for that program;
 *(PDL)          }
 *(PDL)
 */
  if (!initDone)return;   /* exit if not ready to run yet */
  if (rsrvNode != nodeInit)return; /* exit if bad partition */
  if (prtStatus != prtInit)return; /* exit if bad partition */

/* see if we have been requested to shutdown */
/* if so, go inactive */
  if (NdFlag(nodenum) & ShutDown) {
    NdActive(nodenum) = NodeInactive;    /* set us inactive */
    NdFlag(nodenum) &= !ShutDown;        /* shut off shutdown flag */
    for (rtdn = 0; rtdn < MAXNUMRTD64S; rtdn ++) {
      /* see if rtd assigned to us */
      if ((nodeNum(rtdn) == nodenum) && (taskNum(rtdn))) {
        /* get task number & see if active */
        /* get dqe addr */
        dqeptr = DQEP(taskNum(rtdn) >> 24);
        /* if task executing, abort it */
        if (dqeptr->us >= CURR) {
          asm (" stw sp.,spsave");    /* save stack pointer */
          asm (" ext S.EXEC18");      /* exec resume routine */
          asm (" lw r1.,dqeptr");     /* get dqe addr in r2 */
          asm (" lw r5.,=C'RTD6'");
          asm (" lw r6.,=C'4INI'");
          asm (" lw r7.,=C'TING'");
          asm (" bl S.EXEC18");       /* go to exec */
          asm (" lw r3.,spsave");     /* get back our sp */
        }
      }
    }
    initDone = FALSE;
    return;
  }

  NdBit(nodenum)++;       /* we are still ticking */

/*
 * put recover lost entries code here
 */

  for (rtdn = 0; rtdn < MAXNUMRTD64S; rtdn ++) {
    /* see if rtd assigned to us */
    if ((nodeNum(rtdn) == nodenum) && (taskNum(rtdn))) {
      /* get task number & see if active */
      /* get dqe addr */
      dqeptr = DQEP(taskNum(rtdn) >> 24);
      /* if task executing, continue */
      if ((dqeptr->tan != taskNum(rtdn)) || (dqeptr->us < CURR)) {
        /* task has aborted, clean up */
        taskNum(rtdn) = 0;
      }
    }
  }

/*
 *(PDL)
 *(PDL)      C.  Handle RTD64 requests
 *(PDL)           do for each entry requesting this node {
 *(PDL)              if entry status is stPending or stBeingProcessed {
 *(PDL)                 switch (request code) {
 *(PDL)
 */
  for (rtdn = 0; rtdn < MAXNUMRTD64S; rtdn ++) {
    if (rtdindex = firstEntry(rtdn)) {
      for (numf=0; numf<nAssigned(rtdn); rtdindex++, numf++) {
        if ((RtStatus(rtdindex) == stPending) ||
          (RtStatus(rtdindex) == stBeingProcessed)) {
          if(RtNode(rtdindex) == nodenum) {

            /* an entry has been found for me to process */
            int getput = 0;     /* flag for get and put */

            switch (RtReqCode(rtdindex)) {
/*
 *(PDL)
 *(PDL)                 case reqGet:
 *(PDL)                   map in task or partition;
 *(PDL)                   read data into entry;
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
              case reqGet:
                getput = 1;
/*
 *(PDL)
 *(PDL)                 case reqSet:
 *(PDL)                   map in task or partition;
 *(PDL)                   write data from entry;
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
              case reqSet:
                /* see if task or partition */
                if (dqen = (RtTaskNo(rtdindex) >> 24)) {
                  /* we have a task number */
                  /* data addr map start */
                    int das = (int)RtLogAddr(rtdindex);
                  /* data addr map start */
                    int dae = das + RtLen(rtdindex) - 1;
                    int cntr;
                    dqeptr = DQEP(dqen);
                    if (dqeptr->us < CURR)continue;
                  /* get real tsa address of requested task */
                    tsaptr = (struct tsa *)(((int)(dqeptr->msd)) & 0xffe000);
                  /* loop for each data byte requested */
                    for (cntr=0; cntr < RtLen(rtdindex); cntr++) {
                    /* calc logical map number */
                      int curlmap = ((das + cntr) >> 13) - CDOTP->msd;
                      short * midlptr = (short *)dqeptr->msd;
                    /* look for valid map */
/*                    if (midlptr[curlmap] & 0x8000) */
                    /* get physical map num & calc real addr */
                      int phyadr = (((int)(midlptr[curlmap]) << 13) &
                         0xffe000) | ((das + cntr) & 0x1fff);
                      if (getput)
                    /* get data from memory */
                        RtData(cntr, rtdindex) = (*(char *)phyadr);
                      else
                    /* put data in memory */
                        *(char *)phyadr = RtData(cntr, rtdindex);
                    }
                } else {
                  /* we have a partition index */
                  /* data addr map start */
                    int das = (int)RtLogAddr(rtdindex);
                  /* data addr map start */
                    int dae = das + RtLen(rtdindex) - 1;
                    int cntr;
                    int psla;
                  /* get smt addr of requested partition */
                    smtptr = (struct smt *)((int)SMTP +
                      (SMTS * RtPrtNo(rtdindex)));
                  /* set logical starting address */
                    psla = smtptr->page << 11;
                  /* loop for each data byte requested */
                    for (cntr=0; cntr < RtLen(rtdindex); cntr++) {
                    /* calc logical map offset number */
                      int mapoff = (das - psla + cntr) >> 13;
                    /* get physical map num & calc real addr */
                      int phyadr = (((int)(smtptr->midl[mapoff]) << 13) &
                         0xffe000) | ((das - psla + cntr) & 0x1fff);
                      if (getput)
                    /* get data from memory */
                        RtData(cntr, rtdindex) = (*(char *)phyadr);
                      else
                    /* put data in memory */
                        *(char *)phyadr = RtData(cntr, rtdindex);
                    }
                }
                  RtStatus(rtdindex) = stComplete;  /* all done now */
                break;
/*
 *(PDL)
 *(PDL)                 case reqInq:
 *(PDL)                   lookup in DQE table and get information about tasks;
 *(PDL)                   look up in TSA and get info (go unmapped?);
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
              case reqInq:
                for (dqen = 1; dqen <= (int)(*(char *)C_NDQE); dqen++) {
                  int dse = 0;
                  int css = 0;
                  int last = 0;
                  int cntr;
                  dqeptr = DQEP(dqen);
                  if (dqeptr->us < CURR)continue;
                  if ((RtTaskDName(rtdindex)) != dqeptr->lmn)continue;
                  /* we found a taskname match, get data */
                  if ((RtFndTasksNum(rtdindex)+1) > MaxNumTasksToFind)continue;
                  spsave = RtFndTasksNum(rtdindex)++;
                  RtStatus(rtdindex) = stComplete;  /* all done now */
                  RtId(spsave, rtdindex) = dqeptr->tan;
                  tsaptr = (struct tsa *)(((int)(dqeptr->msd)) & 0xffe000);
                /* logical tsa address */
                  RtTSA(spsave, rtdindex) = (int)(TSAP);
                  RtDSS(spsave, rtdindex) = (int)(tsaptr->bias);
                /* scan thru tsa to get address data */
                  for (cntr=0; cntr < tsaptr->memlo; cntr++) {
                    short * midlptr = (short *)dqeptr->msd;
                    short * memlptr = ((short*)(int)midlptr +
                       (int)(tsaptr->memlo));
                    /* look for shared map */
                    if (memlptr[cntr] & 0x1000) {
                      if (!css)css = cntr;  /* save map # if 1st shared map */
                      if (!dse)dse = cntr;  /* set dse if not yet set */
                    }
                    /* look for valid map */
                    if (midlptr[cntr] & 0x8000)
                      last = cntr;
                    else
                      if (!dse)dse = cntr;  /* set dse if not yet set */
                  } /* end of tsa scan loop */
                /* add o/s size to values */
                dse += CDOTP->msd;
                css += CDOTP->msd;
                last += (CDOTP->msd+1);
                /* return dse + 1w */
                  RtDSE(spsave, rtdindex) = dse << 13;
                  RtCSS(spsave, rtdindex) = css << 13;
                /* return end + 1w */
                  RtEND(spsave, rtdindex) = last << 13;
                /* TXPM bias value if present, else zero */
                  if (*(int *)0xdc) /* C.CTXT */
                    RtTXPM(spsave, rtdindex) = (int)((dqeptr->pssf)[1]);
                  else
                    RtTXPM(spsave, rtdindex) = 0;
                }
                break;
/*
 *(PDL)
 *(PDL)                 case reqInqPrt:
 *(PDL)                   lookup in partition table and get information;
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
              case reqInqPrt:
                for (dqen = 0, smtptr = SMTP ; dqen < (int)SMTN; dqen++,
                 smtptr = (struct smt *)((int)smtptr + SMTS)) {
                /* test for active entry */
                  if (!(smtptr->flags & 0x4000))continue;
                /* test for dynamic or static common */
                  if (!(smtptr->flags & 0x60000000))continue;
                  if ((RtPrtDName(rtdindex)) != smtptr->name)continue;
                /* if owername here validate, else use any found */
                  if ((RtRPrtDOwner(rtdindex)) &&
                   (RtRPrtDOwner(rtdindex) != smtptr->ownr))continue;
                /* we found a partition match, get data */
                  if ((RtFndPrtsNum(rtdindex)+1) > MaxNumPrtsToFind)continue;
                  spsave = RtFndPrtsNum(rtdindex)++;
                /* set ownername */
                  RtPrtDOwner(rtdindex,spsave) = smtptr->ownr;
                /* set index of partition */
                  RtPrtEntry(rtdindex,spsave) = smtptr->arta >> 24;
                /* set logical starting address */
                  RtPrtSA(rtdindex,spsave) = (int *)(smtptr->page << 11);
                  RtStatus(rtdindex) = stComplete;  /* all done now */
                }
                break;
/*
 *(PDL)
 *(PDL)                 case reqTrap:
 *(PDL)                   get counter value from task;
 *(PDL)                   if (status is stBeingProcessed and counter changed){
 *(PDL)                      execute the slave entries;
 *(PDL)                   }
 *(PDL)                   save new counter value in entry
 *(PDL)                   set entry status to stBeingProcessed;
 *(PDL)                   break;
 *(PDL)
 */
              case reqTrap: {
                int das;
                int curlmap;
                int phyadr;
                short * midlptr;
                /* get dqe number from task number */
                dqen = (RtTaskNo(rtdindex) >> 24);
                /* data addr map start */
                das = (int)RtCtrAddr(rtdindex);
                /* data addr map start */
                dqeptr = DQEP(dqen);
                if (dqeptr->us < CURR)continue;
                /* get real tsa address of requested task */
                tsaptr = (struct tsa *)(((int)(dqeptr->msd)) & 0xffe000);
                /* calc logical map number */
                curlmap = (das >> 13) - CDOTP->msd;
                midlptr = (short *)dqeptr->msd;
                /* get physical map num & calc real addr */
                phyadr = (((int)(midlptr[curlmap]) << 13) &
                  0xffe000) | (das & 0x1fff);
                if ((RtStatus(rtdindex) == stBeingProcessed) &&
                  (RtLastRTDctr(rtdindex) != (*(int *)phyadr))) {
                  int slvnum;
                  for (slvnum = 0; slvnum < RtNSlaves(rtdindex); slvnum++) {
                    int temprtdindex = rtdindex;
                    /* get index to slave entry */
                    rtdindex = RtSlave(slvnum, temprtdindex);
                    if ((RtStatus(rtdindex) == stPending) ||
                      (RtStatus(rtdindex) == stBeingProcessed)) {
                      if(RtNode(rtdindex) == nodenum) {

                      /* an entry has been found for me to process */
                      int getput = 0;     /* flag for get and put */

                      switch (RtReqCode(rtdindex)) {
/*
 *(PDL)
 *(PDL)                 case reqGet:
 *(PDL)                   map in task or partition;
 *(PDL)                   read data into entry;
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
                        case reqGet:
                          getput = 1;
/*
 *(PDL)
 *(PDL)                 case reqSet:
 *(PDL)                   map in task or partition;
 *(PDL)                   write data from entry;
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
                        case reqSet:
                          /* see if task or partition */
                          if (dqen = (RtTaskNo(rtdindex) >> 24)) {
                            /* we have a task number */
                            /* data addr map start */
                            int das = (int)RtLogAddr(rtdindex);
                            /* data addr map start */
                            int dae = das + RtLen(rtdindex) - 1;
                            int cntr;
                            dqeptr = DQEP(dqen);
                            if (dqeptr->us < CURR)continue;
                            /* get real tsa address of requested task */
                            tsaptr = (struct tsa *)(((int)(dqeptr->msd)) & 0xffe
                            /* loop for each data byte requested */
                            for (cntr=0; cntr < RtLen(rtdindex); cntr++) {
                              /* calc logical map number */
                              int curlmap = ((das + cntr) >> 13) - CDOTP->msd;
                              short * midlptr = (short *)dqeptr->msd;
                              /* look for valid map */
/*                            if (midlptr[curlmap] & 0x8000) */
                            /* get physical map num & calc real addr */
                             int phyadr = (((int)(midlptr[curlmap]) << 13) &
                                 0xffe000) | ((das + cntr) & 0x1fff);
                              if (getput)
                              /* get data from memory */
                                RtData(cntr, rtdindex) = (*(char *)phyadr);
                              else
                              /* put data in memory */
                                *(char *)phyadr = RtData(cntr, rtdindex);
                            }
                          } else {
                            /* we have a partition index */
                            /* data addr map start */
                            int das = (int)RtLogAddr(rtdindex);
                            /* data addr map start */
                            int dae = das + RtLen(rtdindex) - 1;
                            int cntr;
                            int psla;
                            /* get smt addr of requested partition */
                            smtptr = (struct smt *)((int)SMTP +
                              (SMTS * RtPrtNo(rtdindex)));
                            /* set logical starting address */
                            psla = smtptr->page << 11;
                            /* loop for each data byte requested */
                            for (cntr=0; cntr < RtLen(rtdindex); cntr++) {
                              /* calc logical map offset number */
                              int mapoff = (das - psla + cntr) >> 13;
                              /* get physical map num & calc real addr */
                              int phyadr = (((int)(smtptr->midl[mapoff]) << 13) 
                                 0xffe000) | ((das - psla + cntr) & 0x1fff);
                              if (getput)
                              /* get data from memory */
                                RtData(cntr, rtdindex) = (*(char *)phyadr);
                              else
                              /* put data in memory */
                                *(char *)phyadr = RtData(cntr, rtdindex);
                            }
                          }
                          RtStatus(rtdindex) = stComplete;  /* all done now */
                          break;
                        }
                      }
                    }
                  }
                }
                /* get counter from memory */
                RtLastRTDctr(rtdindex) = (*(int *)phyadr);
                RtStatus(rtdindex) = stBeingProcessed;  /* processing now */
                break;
                }
/*
 *(PDL)
 *(PDL)                 case reqWakeup:
 *(PDL)                   for (every resume entry for this node)
 *(PDL)                     if (program suspended) {
 *(PDL)                       put program in ready-to-run queue;
 *(PDL)                       update entry (mark as invalid)
 *(PDL)                     }
 *(PDL)                   break;
 *(PDL)
 */
              case reqWakeup:
                /* get dqe addr */
                dqeptr = DQEP(RtTaskNo(rtdindex) >> 24);
                /* if task suspended, resume it; else wait till later */
                if (dqeptr->us == SUSP) {
                  asm (" stw sp.,spsave");    /* save stack pointer */
                  asm (" ext S.EXEC14");      /* exec resume routine */
                  asm (" lw r2.,dqeptr");     /* get dqe addr in r2 */
                  asm (" bl S.EXEC14");       /* go to exec */
                  asm (" lw r3.,spsave");     /* get back our sp */
                  RtStatus(rtdindex) = stComplete;  /* all done now */
                }
                break;
/*
 *(PDL)
 *(PDL)                 case reqBreak:
 *(PDL)                   get program number from entry
 *(PDL)                   execute break svc
 *(PDL)                   set entry status to stComplete;
 *(PDL)                   break;
 *(PDL)
 */
              case reqBreak:
                /* get dqe addr */
                dqeptr = DQEP(RtTaskNo(rtdindex) >> 24);
                /* send break to specified task */
                asm (" stw sp.,spsave");    /* save stack pointer */
                asm (" ext S.EXEC13");      /* exec break routine */
                asm (" lw r2.,dqeptr");     /* get dqe addr in r2 */
                asm (" bl S.EXEC13");       /* go to exec */
                asm (" lw r3.,spsave");     /* get back our sp */
                RtStatus(rtdindex) = stComplete;  /* all done now */
                break;
/*
 *(PDL)
 *(PDL)                 case reqReinit:
 *(PDL)                   call init;
 *(PDL)                   break;
 *(PDL)
 */
              case reqReinit:
                break;

              default:
                break;
/*
 *(PDL)
 *(PDL)           }  !switch
 *(PDL)        }     !if status ...
 *(PDL)     }        !do for each entry
 *(PDL)  }           !if initDone
 *(PDL)
 */
            } /* end switch */
          } /* if our node */
        } /* if status pending or being processed */
      } /* for each entry assigned */
    } /* if first entry for this rtd64 */
  } /* for each rtd64 index */
}

/*
 *(PDL)
 *(PDL) III.  Init Start SVC (called by RtIniTsk program)
 *(PDL)       use svc 1,6 (r7 = node number on entry)
 *(PDL)       save node number;
 *(PDL)       initDone = FALSE;
 *(PDL)       return;
 *(PDL)
 */
/* routine to handle svc 1,6 init start processing */
/* r7 has node number to save */
instrt()
{

    nodenum = TSAP->regp->reg[7];   /* get node num from callers r7 */
    initDone = FALSE;               /* set init not done yet */
}
/*
 *(PDL)
 *(PDL)  IV.  Init Complete SVC (called by RtIniTsk program)
 *(PDL)       use svc 1,7 (r7 = initDone on return)
 *(PDL)       if (initDone == FALSE)
 *(PDL)          initDone = TRUE;
 *(PDL)       set start clock value to C.INTC
 *(PDL)       return initDone;
 *(PDL)
 */
/* routine to handle svc 1,7 init complete processing */
indone()
{
    if (initDone == FALSE)
        initDone = TRUE;            /* show init done now */
    TSAP->regp->reg[7] = initDone;  /* return initDone status to user r7 */
    strtclk = CDOTP->intc;          /* get starting time */
    realpadr = lear(laddr);         /* get real partition address */
    rtdnp = (struct rtdnodes *)realpadr;  /* set RTDNODE part real addr */
    rtdpp = (struct rtdprt  *)((int)realpadr
      + PAGESIZE);                  /* set RTDPRT partition real address */
    NdActive(nodenum) = NodeActive; /* set us active */
    NdFlag(nodenum) &= !ShutDown;   /* shut off shutdown flag */
}
/*
 *(PDL)
 *(PDL)   V.  TaskInit SVC (called by each RTD64 program)
 *(PDL)       use svc 1,8 (r7 = node number > 0 or 0 for FALSE on return)
 *(PDL)       if (initDone)
 *(PDL)          return TRUE, node number;
 *(PDL)       else
 *(PDL)          return FALSE;
 *(PDL)
 */
/* routine to handle svc 1,8 Task init processing */
/* r7 returns current node number */
/* r6 returns timer ticks per second */

intask()
{
    if (initDone) {
        TSAP->regp->reg[6] = ticksx1;   /* return ticks per second in r6 */
        TSAP->regp->reg[7] = nodenum;   /* return nodenum to user r7 */
    } else {
        TSAP->regp->reg[6] = ticksx1;   /* return ticks per second in r6 */
        TSAP->regp->reg[7] = FALSE;     /* return FALSE status to user r7 */
    }
}
/*
 *(PDL)
 */

/* local subroutines */
/* routine to get real address from tsa */
static int * xlear(addr)
int * addr;
{
    int     mapnum;

    mapnum = (((int)addr & 0xffffff) >> 13) - CDOTP->msd;  /* get map number */

    /* return real variable address */
    return ((int *)(((TSAP->midla[mapnum] << 13)
        | ((int)addr & 0x1fff)) & 0xffffff));
}

/* routine to get real address */
static int * lear(addr)
int * addr;
{
    asm (" lw r1.,call.+.args,sp.");/* get address */
    asm (" lear r0.,0w,r1.");       /* make it real */
}

/* routine to go unmapped */
static void goumap()
{
    asm (" lpsd psd1");
    asm (" bound 1d");
    asm ("psd1 gen 8/x'84',24/goon");
    asm (" dataw x'00018000'");
    asm ("goon equ $");
}

/* routine to go mapped */
static void gomap()
{
    asm (" lpsd psd2");
    asm (" bound 1d");
    asm ("psd2 gen 8/x'84',24/gmon");
    asm (" dataw x'80018000'");
    asm ("gmon equ $");
}

/* this is the interface code to the clock int */
/* it is entered at each clock int */
    asm ("clki stf r0.,lclstk");    /* save regs */
    asm (" la sp.,lclstk");         /* get local stack address */
    asm (" bl _rtdclk");            /* call rtd clock int rtn */
    asm (" lf r0.,0w,sp.");         /* restore regs */
    asm ("rtci nop");               /* execute replaced h.ipcl instr */
    asm ("reti bu $-$");            /* return to h.ipcl */
    asm (" res 8f");                /* local stack */
    asm ("lclstk res 1f");          /* local save area */

/* this is the interface code for svc 1,6 Init start svc */
/* the svc's use t.fssp stack area in the tsa */
    asm ("svc1_6 lw r3.,x'a80'");   /* get tsa address C.TSAD */
    asm (" lw sp.,x'5bc',sp.");     /* get T.FSSP pointer from tsa */
    asm (" bl _instrt");            /* call init svc routine */
    asm (" ext S.EXEC20");          /* svc return address */
    asm (" bu S.EXEC20");           /* return from svc */

/* this is the interface code for svc 1,7 Init Done svc */
/* the svc's use t.fssp stack area in the tsa */
    asm ("svc1_7 lw r3.,x'a80'");   /* get tsa address C.TSAD */
    asm (" lw sp.,x'5bc',sp.");     /* get T.FSSP pointer from tsa */
    asm (" bl _indone");            /* call init done svc routine */
    asm (" ext S.EXEC20");          /* svc return address */
    asm (" bu S.EXEC20");           /* return from svc */

/* this is the interface code for svc 1,8 Taskinit svc */
/* the svc's use t.fssp stack area in the tsa */
    asm ("svc1_8 lw r3.,x'a80'");   /* get tsa address C.TSAD */
    asm (" lw sp.,x'5bc',sp.");     /* get T.FSSP pointer from tsa */
    asm (" bl _intask");            /* call taskinit svc routine */
    asm (" ext S.EXEC20");          /* svc return address */
    asm (" bu S.EXEC20");           /* return from svc */

static int tcpb[3] = {0,0,0};

/* routine to type a message on the console */
static void typ(str)
char *str;
{
    int i;
    for( i =1;str[i]!=0;i++);
        tcpb[0]=i<<20 | 0x00080000 |  (int)str;
    asm(" la 1,tcpb");
    asm(" svc 1,x'3f'");
}

/* this is the sysgen initialization entry */
asm (" lpool");
asm ("sg.ini stf 0,stack-1f");
asm (" la sp.,stack-2f");
asm (" bl _sgent");
asm (" lf 0,stack-1f");
asm (" trsw 0");
asm (" res 12f");
asm ("stack equ $");

/* instructions used during sysgen */
        asm ("bri bu clki");            /* br instruction put in h.ipcl */

sgent(r0,r1,r2,r3,r4,r5,r6,r7)
int r0;
int r1;
int r2;
int r3;
int r4;
int r5;
int r6;
int r7;
{
    /* sysgen init code here */

    asm (" ext IPCL.ICB");          /* connect to rtc code */
    asm (" la r1.,IPCL.ICB");       /* get clock icb address */
    asm (" lw r1.,2w,r1.");         /* get new psd wd 1 */
    asm (" adi r1.,2w");            /* skip abm & stf instrs */
    asm (" anmw r1.,=x'ffffff'");   /* keep address only */
    asm (" lw r0.,=x'ec000000'");   /* get bu instruction */
    asm (" orr r1.,r0.");           /* or in return address */
    asm (" adi r0.,1w");            /* location to return to */
    asm (" stw r0.,reti");          /* set return instr in code */
    asm (" lw r0.,0w,r1.");         /* get instr from h.ipcl */
    asm (" stw r0.,rtci");          /* put instr in local code */
    asm (" lw r0.,bri");            /* get branch to us instruction */
    asm (" stw r0.,0w,r1.");        /* put in h.ipcl code */

    asm (" lw r1.,x'b00'");         /* get C.SVTA address */
    asm (" la r0.,svc1_6");         /* get svc 1,6 routn address */
    asm (" stw r0.,6w,r1.");        /* put address in svc 1 table */
    asm (" la r0.,svc1_7");         /* get svc 1,7 routn address */
    asm (" stw r0.,7w,r1.");        /* put address in svc 1 table */
    asm (" la r0.,svc1_8");         /* get svc 1,8 routn address */
    asm (" stw r0.,8w,r1.");        /* put address in svc 1 table */

    asm (" li r7.,1");              /* calculate 1 secs of ticks */
    asm (" mpmw r6.,x'adc'");       /* ..times C.MTIM */
    asm (" dvmw r6.,x'ae0'");       /* ..divided by C.NTIM */
    asm (" stw r7.,ticksx1");       /* save ticks in 1 secs */

    asm (" li r7.,5");              /* calculate 5 secs of ticks */
    asm (" mpmw r6.,x'adc'");       /* ..times C.MTIM */
    asm (" dvmw r6.,x'ae0'");       /* ..divided by C.NTIM */
    asm (" stw r7.,ticksx5");       /* save ticks in 5 secs */

    asm (" lw r7.,=86400");         /* calc 1 day (86400 secs) of ticks */
    asm (" mpmw r6.,x'adc'");       /* ..times C.MTIM */
    asm (" dvmw r6.,x'ae0'");       /* ..divided by C.NTIM */
    asm (" stw r7.,ticksday");      /* save ticks in a day */

        return;
}
