


     PLOCK(2)                  UNIX System V                  PLOCK(2)



     NAME
          plock - lock text, data, or a process into memory

     SYNTAX
          #include <sys/lock.h>

          int plock(operation)
          int operation;

     PARAMETERS
          operation   Specifies one of the following:

                      PROCLOCK       Process lock
                      TXTLOCK        Text lock
                      DATLOCK        Data lock
                      UNLOCK         Remove locks

     DESCRIPTION
          Plock enables the calling process to lock its text segment
          (text lock), its data segment (data lock), or both its text
          and data segments (process lock) into memory.  Locked
          segments are immune to all paging and swapping.  Plock also
          allows these segments to be unlocked.  All currently
          nonresident pages are brought into memory on a plock.  Any
          additional data space that the process acquires is locked
          down.

     SPECIAL CONSIDERATIONS
          The ability to plock a process is currently permitted only
          to superuser under SVID.

          This system call is typically used in conjunction with
          real-time processes that use direct I/O.  No direct I/O
          connection can be outstanding when the process requests
          segments to be unlocked.  When a real-time application is
          compiled or linked, this system call must be loaded using
          the -lrt option.

          The amount of plocked memory is limited by physical memory,
          but plock has the following nonstandard system-management
          feature:  the ceiling can be lowered by patching the
          variable max__otal__locks in the running kernel.  This
          variable is set at startup time to PLOCK_FRACTION of the
          total number of clusters, ncmap.

     RETURN VALUE
          Upon successful completion, 0 (zero) is returned.
          Otherwise, a value of -1 is returned, and errno is set to
          indicate the error.

     ERRORS
          EPERM       The calling process does not possess the



     Page 1                                         (printed 11/18/90)






     PLOCK(2)                  UNIX System V                  PLOCK(2)



                      privileges necessary to perform this operation.

          EINVAL      The process already has the specified lock.
                      This is for purposes of System V compatibility.

                      The operation is PROCLOCK, and a process lock, a
                      text lock, or a data lock already exists on the
                      calling process.

                      The operation is TXTLOCK, and a text lock or a
                      process lock already exists on the calling
                      process.

                      The operation is DATLOCK, and a data lock or a
                      process lock already exists on the calling
                      process.

                      The operation is UNLOCK, and no text, data, or
                      process lock already exists on the calling
                      process.

          ENOMEM      The amount of plocked memory would exceed
                      max__otal__locks.  This is not a standard
                      feature.

          EACCES      Operation is UNLOCK, and direct I/O is
                      outstanding; the lock cannot be released until
                      direct I/O completes because memory might be
                      clobbered.

     SEE ALSO
          exec(2), exit(2), fork(2), dioconnect(3RT),
          diodisconnect(3RT)






















     Page 2                                         (printed 11/18/90)



