


     MSGCTL(2)                 UNIX System V                 MSGCTL(2)



     NAME
          msgctl - message control operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/msg.h>

          int msgctl (msqid, cmd, buf)
          int msqid, cmd;
          struct msqid_ds *buf;

     DESCRIPTION
          Msgctl provides a variety of message control operations as
          specified by cmd.  The following cmds are available:

          IPC_STAT       Place the current value of each member of the
                         data structure associated with msqid into the
                         structure pointed to by buf.  The contents of
                         this structure are described in intro(2)
                         under Message Operation Permissions.

          IPC_SET        Set the value of the following members of the
                         data structure associated with msqid to the
                         corresponding value found in the structure
                         pointed to by buf:
                              msg_perm.uid
                              msg_perm.gid
                              msg_perm.mode /* only low 9 bits */
                              msg_qbytes

                         This cmd can only be executed by a process
                         that has an effective user ID equal to either
                         that of super user or to the value of
                         msg_perm.uid in the data structure associated
                         with msqid.  Only super user can raise the
                         value of msg_qbytes.

          IPC_RMID       Remove the message queue identifier specified
                         by msqid from the system and destroy the
                         message queue and data structure associated
                         with it.  This cmd can only be executed by a
                         process that has an effective user ID equal
                         to either that of super user or to the value
                         of msg_perm.uid in the data structure
                         associated with msqid.

          Msgctl will fail if one or more of the following are true:

          [EINVAL]       Msqid is not a valid message queue
                         identifier.




     Page 1                                         (printed 11/18/90)






     MSGCTL(2)                 UNIX System V                 MSGCTL(2)



          [EINVAL]       Cmd is not a valid command.

          [EACCES]       Cmd is equal to IPC_STAT, and read operation
                         permission is denied to the calling process
                         (see intro(2)).

          [EPERM]        Cmd is equal to IPC_RMID or IPC_SET.  The
                         effective user ID of the calling process is
                         not equal to that of super user and it is not
                         equal to the value of msg_perm.uid in the
                         data structure associated with msqid.

          [EPERM]        Cmd is equal to IPC_SET, an attempt is being
                         made to increase to the value of msg_qbytes,
                         and the effective user ID of the calling
                         process is not equal to that of super user.

          [EFAULT]       Buf points to an illegal address.

     RETURN VALUE
          Upon successful completion, a value of 0 is returned.
          Otherwise, a value of -1 is returned and errno is set to
          indicate the error.

     SEE ALSO
          intro(2), msgget(2), msgop(2).





























     Page 2                                         (printed 11/18/90)



