-- 	(c) Copyright 1986 Gould Inc.
-- 	    All Rights Reserved.
--
#if	defined(RCSID) && !defined(lint)
	.fardata
.ascii "@(#) (Gould) $Header: urem.s,v 1.1 86/11/08 18:18:00 root UTX $";
	.align 2
/* --	@(#) UTX/32   urem.s ver 1.4 */
--*	ASSEMRCS is defined so that the include file stackdef.h will
--*	use .ascii syntax for RCS ID string
#define ASSEMRCS

#endif	RCSID

	.text
--
-- NAME:
--	urem
--
-- PURPOSE:
--	unsigned remainder for GOULD Concept 32 base register machines
--
-- PRECONDITIONS:
--	arguments: dividend, divisor
--
-- POSTCONDITIONS:
--	result: remainder
--	uses r0,r1,r3
--
-- ALGORITHIM
--	if 1 < divisor <= 2147483647, zero-extend the dividend
--	to 64 bits and let ediv do the work.  If the divisor is 1,
--	ediv will overflow if bit 31 of the dividend is on, so
--	just return 0.  If the divisor is 0, do the ediv also,
--	so it will generate the proper exception.  All other values
--	of the divisor have bit 31 on: in this case the remainder
--	must be the dividend if divisor > dividend, and the dividend
--	minus the divisor otherwise.  The comparison must be unsigned.
-- 
-- HISTORY:
--	adapted for GOULD UNIX base register compiler from
-- 30 July 1983	J. M. Feldman of Compion	Initial adaptation
--

#include "DEFS.h"

#define _urem urem

ENTER5(urem, .fartext)
	movw	ARGOFFSET[b2],r1   -- Dividend 
	movw	ARGOFFSET+1w[b2],r3	-- Divisor  
	jeq	Ldiv		-- If divisor=0, force exception
	cmpw	#1,r3		-- If divisor <= 1 (signed),
	jeq	Lnodiv		-- if divisor == 1, return zero
	jlt	Lnzero		-- it's < 1
Ldiv:
	movw	#0,r0		-- Don't sign-extend the dividend
	divw	r3,r0		-- Divide.  q->r1 (discarded), r->r0
	retn			-- return remainder in r0 (or exception)
Lnodiv:
	movw	#0,r0		--  (because doing the divide will overflow
	jmp	Lout
Lnzero:
	movw	#0,ARGOFFSET[b2] -- most significant bits of 16w+17w doubleword
	movw	#0,r0		-- r0+r1 doubleword has dividend (odd least sig)
	cmpl	ARGOFFSET[b2],r0 -- Signed double comparison between
	jge	Lsub		--  dividend (r0+r1) and divisor (16w+17w)
	movw	r1,r0		-- dividend < divisor (unsigned)
	retn			--  remainder is dividend
Lsub:
	subl	ARGOFFSET[b2],r0	--  else remainder is dividend - divisor
	movw	r1,r0		-- return least significant part of difference
Lout:
	retn
	.ef	1

-- 	(c) Copyright 1986 Gould Inc.
-- 	    All Rights Reserved.
