# 1 "tsearch.c"

















# 1 "/u/cinclude/nbinclude/search.h"









typedef struct entry { char *key, *data; } ENTRY;
typedef enum { FIND, ENTER } ACTION;


typedef enum { preorder, postorder, endorder, leaf } VISIT;
# 18 "tsearch.c"
typedef char *POINTER;
typedef struct node { POINTER key; struct node *llink, *rlink; } NODE;



extern char *malloc();

NODE *
tsearch(key, rootp, compar)	
POINTER	key;			
register NODE	**rootp;	
int	(*compar)();		
{
	register NODE *q;	

	if (rootp == 0)
		return (0);
	while (*rootp != 0) {			
		int r = (*compar)(key, (*rootp)->key);	
		if (r == 0)
			return (*rootp);	
		rootp = (r < 0) ?
		    &(*rootp)->llink :		
		    &(*rootp)->rlink;		
	}
	q = (NODE *) malloc(sizeof(NODE));	
	if (q != 0) {			
		*rootp = q;			
		q->key = key;			
		q->llink = q->rlink = 0;
	}
	return (q);
}

NODE *
tdelete(key, rootp, compar)	
POINTER	key;			
register NODE	**rootp;	
int	(*compar)();		
{
	NODE *p;		
	register NODE *q;	
	register NODE *r;	
	int ans;		

	if (rootp == 0 || (p = *rootp) == 0)
		return (0);
	while ((ans = (*compar)(key, (*rootp)->key)) != 0) {
		p = *rootp;
		rootp = (ans < 0) ?
		    &(*rootp)->llink :		
		    &(*rootp)->rlink;		
		if (*rootp == 0)
			return (0);		
	}
	r = (*rootp)->rlink;			
	if ((q = (*rootp)->llink) == 0)	
		q = r;
	else if (r != 0) {			
		if (r->llink == 0) {		
			r->llink = q;
			q = r;
		} else {			
			for (q = r->llink; q->llink != 0; q = r->llink)
		 		r = q;
			r->llink = q->rlink;
			q->llink = (*rootp)->llink;
			q->rlink = (*rootp)->rlink;
		}
	}
	free((POINTER) *rootp);		
	*rootp = q;			
	return (p);
}

void
twalk(root, action)		
NODE	*root;			
void	(*action)();		
{
	void _twalk();

	if (root != 0 && action != 0)
		_twalk(root, action, 0);
}

static void
_twalk(root, action, level)	
register NODE	*root;		
register void	(*action)();	
register int	level;
{
	if (root->llink == 0 && root->rlink == 0)
		(*action)(root, leaf, level);
	else {
		(*action)(root, preorder, level);
		if (root->llink != 0)
			_twalk(root->llink, action, level + 1);
		(*action)(root, postorder, level);
		if (root->rlink != 0)
			_twalk(root->rlink, action, level + 1);
		(*action)(root, endorder, level);
	}
}
