/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements - Control                             */
/*                          5.5.2 Break                                      */
/*  Product and Revision :  Unix 1.6                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  7/3/84                                           */
/*  Source File :           source/stat.552.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          06/12/84    T. Aleksa        UTX-32 1.0 Release  */
/*                          -- Modified printf statement.                    */
/*                                                                           */
/*  Description :           Verify the break statement causes termination    */
/*                          of the smallest enclosing while, do, for, or     */
/*                          switch statement.                                */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.55.j                              */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
        int i,j;
        FILE *fp;
        fp=fopen("stat_res bloc=y","a");
        /*
           The compiler fails if this does not compile
        */
 
 /* Test 1 */
 
        for ( i = 0; i < 3 ; i++)
        break;
 
        /*  break statement inside a for loop */
        for ( i=j=0; i < 3 ; i++ )
           { if ( i < 3 ) break   ;
             j++;
           }
 
        /* if j or i is greater than 0 then fail */
        if ( j || i )
           {   fail = TRUE;
                fprintf(fp,"  ** statement, break 5.5.2-1 class 1 fail -  exit return code : %d\n",j);
                printf("  ** statement, break 5.5.2-1 class 1 fail -  exit return code : %d\n",j);
           }
 
 
/* Test 2
           break statement inside a while loop */
        i = j = 0 ;
        while ( i < 3  )
        {       if ( i < 3 ) { i++;break;};
                j++;
        };
        if ( j || i != 1 )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, break 5.5.2-2 class 1 fail -  exit return code : %d\n",j);
                printf("  ** statement, break 5.5.2-2 class 1 fail -  exit return code : %d\n",j);
        };
 
/* Test 3
           break statement inside a do while loop */
        i = j = 0;
        do {i++;
                if ( i <= 3 ) break;
                j++;
           } while ( i < 3 );
        if ( j || i != 1 )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, break 5.5.2-3 class 1 fail -  exit return code : %d\n",j);
                printf("  ** statement, break 5.5.2-3 class 1 fail -  exit return code : %d\n",j);
        };
 
/* Test 4
           verify that the break statement provides an early exit
           from switch.
        */
        i = j = 0;
        while ( i < 3 )
        {
                switch (i)
                {
                        case 0 : i++; break;
                        case 1 : i++; break;
                        case 2 : i++; break;
                        case 3 : i++; break;
                        case 4 : i++; break;
                        case 5 : i++; break;
                        case 6 : i++; break;
                        case 7 : i++; break;
                        case 8 : i++; break;
                        case 9 : i++; break;
                        case 10 : i++; break;
                }
                /* verify the break used inside the switch can
                   be distinguished from the break used in the
                   while loop.
                */
                if ( i > 3 ) break ; j++;
        }
        if ( i != 3 || j != 3 )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, break 5.5.2-4 class 1 fail -  exit return code : %d\n",i);
                printf("  ** statement, break 5.5.2-4 class 1 fail -  exit return code : %d\n",i);
        };
 if ( !fail )
   {fprintf(fp,"  .. statement, break 5.5.2 class 1 pass\n");
    printf("  .. statement, break 5.5.2 class 1 pass\n");}
 fclose(fp);
}
