/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      The C Preprocessor - File Inclusion              */
/*                          Section  6.2                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/prep.624.c                                */
/*  Revisions :             04/25/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that #include may be nested.              */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/prep.62.j                              */
/*                                                                           */
/*  Associated Files :      Associated data files are include files named    */
/*                          ../data/prep.624[1-20].d.                        */
/*                          Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test was originally spr0131 written against UTX Release 2.0.
        Problem description:  The C documentation states that #includes' may
                be nested.  However the depth of nested includes is not
                mentioned.  For UTX 2.0, the C preprocessor has a limit of
                10 for nested includes.  Exceeding that limit caused a fatal
                error in /lib/cpp.
 
        For UTX-32 Release 1.0, nested includes were limited to 8 files.
 
        This test is capable of testing a maximum of 20 nested include files.
        Documentation should be verified and updated.
*/
 
#include <stdio.h>
#include "prep.6241.d"
 
main()
{int i=0;
 FILE *fp;
 fp = fopen("prep_res bloc=y","a");
 i = MAX;
 if (i=8)
   {
     fprintf(fp," .. prep.624 - 8 nested include files - pass\n");
     printf(" .. prep.624 - 8 nested include files - pass\n");
   }
 else
   {
     fprintf(fp," ** prep.624 - 8 nested include files - fail\n");
     printf(" ** prep.624 - 8 nested include files - fail\n");
   }
 fclose(fp);
}
