/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts                           */
/*                          Strings                                          */
/*                          Section  1.2.5                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/misc.1255.c                               */
/*  Revisions :             06/14/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the compiler will accept             */
/*                          "string"[constant expression].                   */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  This test was originally a problem documented in (Compion Bug Report) cbr6.
    Problem Description:  "string"[constant index] generates unloadable code.
*/
 
#include <stdio.h>
main()
{
        char c;
        FILE *fp;
        fp=fopen("misc_res bloc=y","a");
 
        c = "this is a string"[8];
 
        if ( c != 'a' )
          {fprintf(fp,"  ** miscellaneous, strings 1.2.5.5 class 1 fail     -  exit return code : %c\n", c);
           printf("  ** miscellaneous, strings 1.2.5.5 class 1 fail     -  exit return code : %c\n", c);}
        else
          {fprintf(fp,"  .. miscellaneous, strings 1.2.5.5 class 1 pass\n");
           printf("  .. miscellaneous, strings 1.2.5.5 class 1 pass\n");}
        fclose(fp);
}
 
