/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc_1231.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Constants   Gould S.E.L. Unix reference Manual,  */
/*                          Vol I, chapter 4 states that a floating constant */
/*                          of an integer part, a decimal point, a fraction  */
/*                          part, an e or E, and an optionally signed integer*/
/*                          exponent.                                        */
/*                          This program tests the conformance of the        */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{   int test;
    float a,b;
    FILE *fp;
    fp=fopen("misc_res bloc=y","a");
 
    /* verify the upper case E and lower case e are equivalent.*/
    /* Test 1 */
    a = 1e1;
    b = 1E1;
    if ( a != b )
       {fail = TRUE;
       fprintf(fp,"  ** miscellaneous, constants 1.2.3.1-1 calss 1 fail -  exit return code : %f%f\n",a,b);
       printf("  ** miscellaneous, constants 1.2.3.1-1 calss 1 fail -  exit return code : %f%f\n",a,b);
       }
 
    /* Test 2 */
    a = 123.123e2;
    b = 123.123E2;
    if ( a != b)
       { fail = TRUE;
       fprintf(fp,"  ** miscellaneous, constants 1.2.3.1-2 class 1 fail-  exit return code : %f%f\n",a,b);
       printf("  ** miscellaneous, constants 1.2.3.1-2 class 1 fail-  exit return code : %f%f\n",a,b);
       }
 
    /* Test 3 */
    a = 0e1;
    b = 0E1;
    if ( a != b || a != 0 )
       { fail = TRUE;
         fprintf(fp,"  ** miscellaneous, constants 1.2.3.1-3 class 1 fail -  exit return code : %f%fn",a,b);
         printf("  ** miscellaneous, constants 1.2.3.1-3 class 1 fail -  exit return code : %f%fn",a,b);
       }
 
    if (!fail)
      {fprintf(fp,"  .. miscellaneous, constants 1.2.3.1 class 1 pass\n");
       printf("  .. miscellaneous, constants 1.2.3.1 class 1 pass\n");}
    fclose(fp);
}
 
