/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1221.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Verify that a decimal, octal, or hexadecimal     */
/*                          intege constant immediately followed by l or L   */
/*                          is a long constant.                              */
/*                          This program also  tests the conformance of the  */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* In Gould S.E.L. 's machine, integer and long values considered identical  */
/* This program verify the decimal, octal and hexadecimal are represented    */
/* correctly. */
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
     int test;
     FILE *fp;
     fp=fopen("misc_res bloc=y","a");
   {/* test 1 verify the lower case l and upper case L are identical */
     int a,b,c,d;
      test = 1;
      a = 123L;
      b = 123l;
      c = 0x7bl;
      d = 0173L;
      if ( a != b || b != c || c != d )
      { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.1 class 1 fail exit return code : %d%d%d%d%d\n",test,a,b,c,d);
        printf("  ** miscellaneous, constants 1.2.2.1 class 1 fail exit return code : %d%d%d%d%d\n",test,a,b,c,d);
      }
   }
 
/* MORE */
 
   if (!fail)
       {fprintf(fp,"  .. miscellaneous, constants 1.2.2.1 class 1 pass\n");
        printf("  .. miscellaneous, constants 1.2.2.1 class 1 pass\n");}
    fclose(fp);
}
