/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts                           */
/*                          Constants                                        */
/*                          Section  1.2, 1.2.1                              */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/misc.1216.c                               */
/*  Revisions :             03/21/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that a constant expression can be         */
/*                          stored in an integer constant.                   */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test was originally qar7 written against UTX Release 2.0        */
 
/*      Problem description:  If an integer constant expression when         */
/*      evaluated would need at least 14 bits of register storage space,     */
/*      the compiler does not seem to know where to store the result.        */
/*      Compiler aborts with errors.                                         */
 
 
#include <stdio.h>
main()
{
        int i;
        FILE *fp;
        fp=fopen("misc_res bloc=y","a");
 
        i = 20 * 512 - 1;
 
        if ( i != 10239 )
          {fprintf(fp,"  ** miscellaneous, constants 1.2.1.6 class 1 fail  - exit return code : %d\n", i );
           printf("  ** miscellaneous, constants 1.2.1.6 class 1 fail  - exit return code : %d\n", i );}
        else
          {fprintf(fp,"  .. miscellaneous, constants 1.2.1.6 class 1 pass\n");
           printf("  .. miscellaneous, constants 1.2.1.6 class 1 pass\n");}
        fclose(fp);
}
 
 
