/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Identifiers             */
/*                          Section 1.1.2.4                                  */
/*  Product and Revision :  1.2                                              */
/*  Author :                Suifun Law                                       */
/*  Date :                  10/25/83                                                 */
/*  Source File :           source/misc.1124.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*  Description :           upper/lower case differentiation                 */
/*                          The upper case identifiers should be             */
/*                          distinguished from lower case with the same      */
/*                          spelling.                                        */
/*                          This program verifies this conformance.          */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.11.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* Identifiers  Gould S.E.L. Unix reference Manual Vol I, chapter 4
                states that Gould S.E.L. 32/27 has 2 cases for
                identifiers.
                The following tests identifiers that have same spelling
                but written in different cases do not match.
*/
#include <stdio.h>
main()
{
     int   conform , CONFORM,conFORM, CONform;
     FILE *fp;
     fp=fopen("misc_res bloc=y","a");
 
     conFORM = 1;
     CONform = 2;
     conform = 1;
     CONFORM = 2;
     if ( conform == CONFORM || conFORM == CONform )
        { fprintf(fp,"  ** miscellaneous, identifiers 1.1.2.4 class 3 fail\n");
        printf("  ** miscellaneous, identifiers 1.1.2.4 class 3 fail\n");}
     else
        { fprintf(fp,"  .. miscellaneous, identifiers 1.1.2.4 class 3 pass\n");
        printf("  .. miscellaneous, identifiers 1.1.2.4 class 3 pass\n");} 
     fclose(fp);
}
 
 
