/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Returned Values - Static Functions               */
/*                          Section  3.3.2                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33210.c                              */
/*  Revisions :             04/11/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that values are correctly returned from   */
/*                          functions that are declared to be static.        */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#define TRUE 1
int fail=0;
 
/*   The following test was originally spr0042 written against UTX Release 1.0.
     Problem description:  Predeclaration of a function should be permitted but
             it is not.
*/
 
static char *foo();
 
main()
{
        FILE *fp;
        char *str[10];
        *str = foo();
        fp=fopen("extn_res bloc=y","a");
 
        if ( compare( *str, "hello" ) != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** external, returned values 3.3.2.10 class 1 fail    -  exit return code : %s\n", *str );
             printf("  ** external, returned values 3.3.2.10 class 1 fail    -  exit return code : %s\n", *str );
           }
        if ( !fail )
          {fprintf (fp,"  .. external, returned values 3.3.2.10 class 1 pass\n");
           printf ("  .. external, returned values 3.3.2.10 class 1 pass\n");}
}
static char *
foo()
{
        return("hello");
}
 
/*  Compare:   compares two given strings
 
     inputs  -  two strings s1 and s2
     outputs -  = 0, if s1 is equal to s2
                > 0, if s1 is greater than s2
                < 0, if s1 is less than s2
*/
 
compare( s1, s2 )
char *s1, *s2;
{
        for ( ; *s1 == *s2; s1++, s2++ )
              if ( *s1 == '\0' )
                 return 0;
        return ( *s1 - *s2 );
}
