/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Functions - By arrays                            */
/*                          Section  3.3.1.3                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33132.c                              */
/*  Revisions :             04/12/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the address of an array can be       */
/*                          subscripted to access and alter any element of   */
/*                          an array.                                        */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
/*   Tests 1 thru 3 were originally spr0253 written against UTX Release 2.0.
     Problem description :  The following program demonstrates a bug in the
             handling by the C compiler of addresses of structure fields,
             passed as arguments in functions.  It appears that problems
             only occur when the field is not the first one in the structure.
*/
 
struct bug {
        int f1;
        int f2;
        int f3;
} ;
 
int x1,x2;
 
 
 
FILE *fp;
main()
{
        struct bug x[2];
 
fp=fopen("extn_res bloc=y","a");
        x[0].f1=10;
        x[1].f1=11;
 
        x[0].f2=20;
        x[1].f2=21;
 
        x[0].f3=30;
        x[1].f3=31;
 
        field1(&x[0],&x[1]);
        field2(&x[0],&x[1]);
        field3(&x[0],&x[1]);
 
        if ( !fail )
          {fprintf(fp,"  .. external, functions, arrays 3.3.1.3.2 class 1 pass\n" );
           printf("  .. external, functions, arrays 3.3.1.3.2 class 1 pass\n" );}
        fclose(fp);
}
 
field1(a1,a2)
struct bug *a1,*a2;
{
        int y1, y2;
 
        y1 = a1->f1;
        y2 = a2->f1;
        x1 = a1->f1;
        x2 = a2->f1;
 
        if ( y1 != 10  || y2 != 11  || x1 != 10 || x2 != 11 )
           { fail = TRUE;
             fprintf(fp,"  ** external, functions, arrays 3.3.1.3.2-1 class 1 fail   -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
             printf("  ** external, functions, arrays 3.3.1.3.2-1 class 1 fail   -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
           }
}
 
field2(a1,a2)
struct bug *a1,*a2;
{
        int y1, y2;
 
        y1 = a1->f2;
        y2 = a2->f2;
        x1 = a1->f2;
        x2 = a2->f2;
 
        if ( y1 != 20  || y2 != 21  || x1 != 20 || x2 != 21 )
           { fail = TRUE;
             fprintf(fp,"  ** external, functions, arrays 3.3.1.3.2-2 class 1 fail  -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
             printf("  ** external, functions, arrays 3.3.1.3.2-2 class 1 fail  -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
           }
}
 
field3(a1,a2)
struct bug *a1,*a2;
{
       int y1, y2;
 
       y1 = a1->f3;
       y2 = a2->f3;
       x1 = a1->f3;
       x2 = a2->f3;
 
       if ( y1 != 30 || y2 != 31 || x1 != 30 || x2 != 31 )
          { fail = TRUE;
            fprintf(fp,"  ** external, functions, arrays, 3.3.1.3.2-3 class 1 fail -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
            printf("  ** external, functions, arrays, 3.3.1.3.2-3 class 1 fail -  exit return code : %d%d%d%d\n", y1, y2, x1, x2 );
          }
}
