/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Functions - By arrays                            */
/*                          Section  3.3.1.3                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33131.c                              */
/*  Revisions :             04/09/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the address of an array is passed    */
/*                          to a function.                                   */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../extn.33.j                                    */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
/*  Test 1 was orginally spr0030 written against UTX Release 1.0.
    Problem description:  Incorrect code generation for calling on an
                          array of functions.
*/
 
isame(n)
int n;
{
    return(n);
}
 
int (*funct_table[]) () = { isame };  /* funct_table[] is a pointer to an array
                                         of functions of which function isame is
                                         the first element of the array
                                      */
main()
{
        int a;
 
FILE *fp;
fp=fopen("extn_res bloc=y","a");
        a  =  ( *funct_table[isame(0)] ) (5);
        if ( a != 5 )
           { fail = TRUE;
             fprintf(fp,"  ** external, functions 3.3.1.3.1 class 1 fail -  exit return code  :  %d\n", a );
             printf("  ** external, functions 3.3.1.3.1 class 1 fail -  exit return code  :  %d\n", a );
           }
 
        if ( !fail )
          {fprintf(fp,"  .. external, functions 3.3.1.3.1 class 1 pass\n" );
           printf("  .. external, functions 3.3.1.3.1 class 1 pass\n" );}
        fclose(fp);
}
