/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Functions, By Pointers                           */
/*                          Section  3.3.1.2                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33123.c                              */
/*  Revisions :             04/06/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that pointers can be passed and be used   */
/*                          to reference structures.                         */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
struct ONE {         /*  referenced in test 1  */
        int x;
};
 
typedef struct {                          /* referenced in test 2 */
         unsigned short two_page;
         int            two_line  : 8;
         int            two_index : 8;
        } TWO;
 
TWO x;
 
main()
{
FILE *fp;
fp=fopen("extn_res bloc=y","a");
/*   Test 1 was originally spr0236 written against UTX Release 2.0.
     Problem description : Pointers to structures are not dereferenced
                           within procedure calls.
*/
 {
        struct ONE one;
        struct ONE *oneptr;
        int a;
 
        one.x = 666;
        oneptr = &one;
 
 
        if (( a = subone(*oneptr) ) != 666 )     /* pointer passed to subone */
           { fail = TRUE;
             fprintf(fp,"  ** external, functions, pointers 3.3.1.2.3-1 class 2 fail- exit return code : %d\n", a );
             printf("  ** external, functions, pointers 3.3.1.2.3-1 class 2 fail- exit return code : %d\n", a );
           }
  }
/*   Test 2 was originally spr130 written against UTX Release 2.0.
     Problem description : The compiler refuses to correctly handle bit-fields
                           as parameters to functions.  The compiler get con-
                           fused in register allocation.
*/
 {
        int val;
 
        x.two_line = 5;
        val = search ( &x );
 
        if ( val != 5 )
           { fail = TRUE;
             fprintf(fp,"  ** external, functions, pointers 3.3.1.2.3-2 class 2 fail       - exit return code : %d\n", val );
             printf("  ** external, functions, pointers 3.3.1.2.3-2 class 2 fail       - exit return code : %d\n", val );
           }
  }
        if ( !fail )
          {fprintf(fp,"  .. external, functions, pointers 3.3.1.2.3 class 2 pass\n");
           printf("  .. external, functions, pointers 3.3.1.2.3 class 2 pass\n");}
       fclose(fp);
}
 
subone(one)             /* referenced in test 1 */
struct ONE one;
{
        int a;
        a = one.x;
        return ( a );
}
 
TWO   *subtwo(two)      /* referenced in test 2 */
int   two;
{
        return ( &x );
}
 
search( kptr )          /* referenced in test 2 */
TWO     *kptr;
{
        TWO *kptr1;
 
        kptr1 = subtwo( kptr->two_line );
        return ( kptr->two_line );
}
