/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Remote Basic Types  - Section 3.1.3              */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3132a.c                              */
/*  Revisions :             04/16/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  4/17/85                                          */
/*  Descriptions :          For basic types defined and declared in          */
/*                          different files:                                 */
/*                          Verify that a globally declared identifier       */
/*                          can be correctly referenced through the end of   */
/*                          the source file.  The compiler fails if this     */
/*                          program cannot be compiled.                      */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.  Associated files include                */
/*                          source/extn.3132b.c which is compiled with this  */
/*                          program.                                         */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
int     fail;
 
extern int in;
extern short int si;
extern long int li;
extern short sh;
extern long lg;
extern char ch;
extern unsigned un;
extern unsigned int ui;
extern unsigned short us;
extern unsigned short int usi;
extern unsigned long ul;
extern unsigned long int uli;
extern unsigned char uc;
 
float fl = 2.5;
long float lf = (-1.5);
double db = .0125E3;
 
FILE *fp;
main()
{
fp=fopen("extn_res bloc=y","a");
        if ( in != 5   || si != (-10) || li != 15     || sh != (-20) ||
             lg != 25  || un != 30    || ui != 35     || us != 40    ||
             usi != 45 || ul != 50    || uli != 55    || uc != 'a'   ||
             ch != 'b' ||  fl != 2.5  || lf != (-1.5) || db != .0125E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-1 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-1 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        /*  shift the external variables
        */
 
        shift();
 
        if ( in != 20   || si != (-40) || li != 60     || sh != (-80) ||
             lg != 100  || un != 120   || ui != 140    || us != 160   ||
             usi != 180 || ul != 200   || uli != 220   || uc != 'c'   ||
             ch != 'd'  ||  fl != 3.5  || lf != (-0.5) || db != .0135E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-2 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-2 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        /*  function dbl() resides in file source/extn.3132b.c
        */
 
        dbl();
 
        if ( in != 40   || si != (-80) || li != 120    || sh != (-160) ||
             lg != 200  || un != 240   || ui != 280    || us != 320    ||
             usi != 360 || ul != 400   || uli != 440   || uc != 'e'    ||
             ch != 'f'  || fl != 7.0   || lf != (-1.0) || db != .027E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-3 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-3 class 1 fail   - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        /*  shift the external variables again
        */
 
        shift();
 
        if ( in != 160   || si != (-320) || li != 480   || sh != (-640) ||
             lg != 800   || un != 960    || ui != 1120  || us != 1280   ||
             usi != 1440 || ul != 1600   || uli != 1760 || uc != 'g'    ||
             ch != 'h'   || fl != 8.0    || lf != (0.0) || db != .028E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-4 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-4 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        /*  function dec() resides in file source/extn.3132b.c
        */
 
        dec();
 
        if ( in != 159   || si != (-321) || li != 479    || sh != (-641) ||
             lg != 799   || un != 959    || ui != 1119   || us != 1279   ||
             usi != 1439 || ul != 1599   || uli != 1759  || uc != 'f'    ||
             ch != 'g'   || fl != 7.0    || lf != (-1.0) || db != .027E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-5 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-5 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        /*  increment the external variables
        */
 
        inc();
 
        if ( in != 161   || si != (-319) || li != 481   || sh != (-639) ||
             lg != 801   || un != 961    || ui != 1121  || us != 1281   ||
             usi != 1441 || ul != 1601   || uli != 1761 || uc != 'h'    ||
             ch != 'i'   || fl != 9.0    || lf != (1.0) || db != .029E3 )
           { fail = TRUE;
             fprintf(fp,"  ** external, remote basic types 3.1.3.2-6 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
              printf("  ** external, remote basic types 3.1.3.2-6 class 1 fail  - exit return code : %d%d%d%d%d%d%d%d%d%d%d%c%c%f%f%f\n",
                   in,si,li,sh,lg,un,ui,us,usi,ul,uli,uc,ch,fl,lf,db );
           }
 
        if ( !fail )
          {fprintf(fp,"  .. external, remote basic types 3.1.3.2 class 1 pass\n");
            printf("  .. external, remote basic types 3.1.3.2 class 1 pass\n");}
        fclose(fp);
 
}
 
/*****************************************************************************/
/*                                                                           */
/*  shift()  -  This function references the external variables,             */
/*              left shifting all variables except float, double,            */
/*              and long float which are incremented by 1, and char          */
/*              and unsigned char which are incremented by 2.                */
/*                                                                           */
/*****************************************************************************/
shift()
{
        in <<= 2;
        si <<= 2;
        li <<= 2;
        sh <<= 2;
        lg <<= 2;
        un <<= 2;
        ui <<= 2;
        us <<= 2;
        usi <<= 2;
        ul <<= 2;
        uli <<= 2;
        ch += 2;
        uc += 2;
        fl += 1.0;
        lf += 1.0;
        db += 1.0;
}
 
/*****************************************************************************/
/*                                                                           */
/*  inc()  -   This function references the external variables and           */
/*             increments their values by 2.                                 */
/*                                                                           */
/*****************************************************************************/
inc()
{
        in += 2;
        si += 2;
        li += 2;
        sh += 2;
        lg += 2;
        ch += 2;
        un += 2;
        ui += 2;
        us += 2;
        usi += 2;
        ul += 2;
        uli += 2;
        uc += 2;
        fl += 2.0;
        lf += 2.0;
        db += 2.0;
}
