/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Remote Basic Types  - Section 3.1.3              */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3131a.c                              */
/*  Revisions :             04/16/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Revision:               4/30/90                                          */
/*                          Mike Bennett                                     */
/*                          Revised the format and changed the variable      */
/*                          of lf from 14.6 to 14.7.                         */
/*  Revision:               5/03/90                                          */
/*                          Mindy Pheterson                                  */
/*                          Revised the format to account for precision      */
/*                          differences for lf.                              */
/*  Descriptions :          For basic types defined and declared in          */
/*                          different files:                                 */
/*                          Verify that an identifier which is declared      */
/*                          within a function can be referenced within that  */
/*                          function.  The compiler fails if this program    */
/*                          cannot be compiled.                              */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.  Associated files include                */
/*                          source/extn.3131b.c which is compiled with this  */
/*                          program.                                         */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
#define FILENAME "extn_res bloc=y"
 
int     fail;
int     in = 1;
short int si = 2;
long int li = 3;
short   sh = 4;
long    lg = 5;
char    ch = 'a';
unsigned un = 6;
unsigned int ui = 7;
unsigned short us = 8;
unsigned short int usi = 9;
unsigned long ul = 10;
unsigned long int uli = 11;
unsigned char uc = 'b';
float   fl = 12.5;
long float lf = 14.7;
double  db = .0465E2;
FILE   *fp;
 
main ()
{
   fp = fopen (FILENAME, "a");
   inc ();
 
   if (in != 3) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1a class 1 fail - exit return code: %d\n", in);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1a class 1 fail - exit return code: %d\n", in);
   }
   if (si != 4) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1b class 1 fail - exit return code: %d\n", si);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1b class 1 fail - exit return code: %d\n", si);
   }
   if (li != 5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1c class 1 fail - exit return code: %d\n", li);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1c class 1 fail - exit return code: %d\n", li);
   }
   if (sh != 6) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1c class 1 fail - exit return code: %d\n", sh);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1c class 1 fail - exit return code: %d\n", sh);
   }
   if (lg != 7) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1d class 1 fail - exit return code: %d\n", lg);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1d class 1 fail - exit return code: %d\n", lg);
   }
   if (ch != 'c') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1e class 1 fail - exit return code: %c\n", ch);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1e class 1 fail - exit return code: %c\n", ch);
   }
   if (un != 8) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1f class 1 fail - exit return code: %d\n", un);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1f class 1 fail - exit return code: %d\n", un);
   }
   if (ui != 9) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1g class 1 fail - exit return code: %d\n", ui);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1g class 1 fail - exit return code: %d\n", ui);
   }
   if (us != 10) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1h class 1 fail - exit return code: %d\n", us);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1h class 1 fail - exit return code: %d\n", us);
   }
   if (usi != 11) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1i class 1 fail - exit return code: %d\n", usi);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1i class 1 fail - exit return code: %d\n", usi);
   }
   if (ul != 12) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1j class 1 fail - exit return code: %d\n", ul);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1j class 1 fail - exit return code: %d\n", ul);
   }
   if (uli != 13) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1k class 1 fail - exit return code: %d\n", uli);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1k class 1 fail - exit return code: %d\n", uli);
   }
   if (uc != 'd') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1l class 1 fail - exit return code: %c\n", uc);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1l class 1 fail - exit return code: %c\n", uc);
   }
   if (fl != 14.5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1m class 1 fail - exit return code: %f\n", fl);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1m class 1 fail - exit return code: %f\n", fl);
   }
   if (lf != 16.7) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-1n class 1 fail - exit return code: %f\n", lf);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-1n class 1 fail - exit return code: %f\n", lf);
   }
   if (db !=.0665E2) {
      fail = TRUE;
      printf ("   ** external, remote basic types 3.1.3.1-1o class 1 fail - exit return code: %f\n", db);
      fprintf (fp, "   ** external, remote basic types 3.1.3.1-1o class 1 fail - exit return code: %f\n", db);
   }
 
   /*
    * function dec() resides in file source/extn.3131b.c 
    */
 
   dec ();
 
   /*
    * increment external variables again 
    */
 
   inc ();
 
   if (in != 4) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3a class 1 fail - exit return code: %d\n", in);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3a class 1 fail - exit return code: %d\n", in);
   }
   if (si != 5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3b class 1 fail - exit return code: %d\n", si);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3b class 1 fail - exit return code: %d\n", si);
   }
   if (li != 6) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3c class 1 fail - exit return code: %d\n", li);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3c class 1 fail - exit return code: %d\n", li);
   }
   if (sh != 7) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3c class 1 fail - exit return code: %d\n", sh);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3c class 1 fail - exit return code: %d\n", sh);
   }
   if (lg != 8) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3d class 1 fail - exit return code: %d\n", lg);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3d class 1 fail - exit return code: %d\n", lg);
   }
   if (ch != 'd') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3e class 1 fail - exit return code: %c\n", ch);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3e class 1 fail - exit return code: %c\n", ch);
   }
   if (un != 9) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3f class 1 fail - exit return code: %d\n", un);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3f class 1 fail - exit return code: %d\n", un);
   }
   if (ui != 10) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3g class 1 fail - exit return code: %d\n", ui);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3g class 1 fail - exit return code: %d\n", ui);
   }
   if (us != 11) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3h class 1 fail - exit return code: %d\n", us);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3h class 1 fail - exit return code: %d\n", us);
   }
   if (usi != 12) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3i class 1 fail - exit return code: %d\n", usi);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3i class 1 fail - exit return code: %d\n", usi);
   }
   if (ul != 13) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3j class 1 fail - exit return code: %d\n", ul);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3j class 1 fail - exit return code: %d\n", ul);
   }
   if (uli != 14) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3k class 1 fail - exit return code: %d\n", uli);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3k class 1 fail - exit return code: %d\n", uli);
   }
   if (uc != 'e') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3l class 1 fail - exit return code: %c\n", uc);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3l class 1 fail - exit return code: %c\n", uc);
   }
   if (fl != 15.5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-3m class 1 fail - exit return code: %f\n", fl);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-3m class 1 fail - exit return code: %f\n", fl);
   }
   if (lf != 17.7) {
      fail = TRUE;
      printf("   lf should equal 17.700000.  lf equals: %f\n", lf);
      fprintf("   lf should equal 17.700000.  lf equals: %f\n", lf);
   }
   if (db !=.0765E2) {
      fail = TRUE;
      printf ("   ** external, remote basic types 3.1.3.1-3o class 1 fail - exit return code: %f\n", db);
      fprintf (fp, "   ** external, remote basic types 3.1.3.1-3o class 1 fail - exit return code: %f\n", db);
   }
   if (!fail) {
      fprintf (fp, "  .. external, remote basic types 3.1.3.1 class 1 pass\n");
      printf ("  .. external, remote basic types 3.1.3.1 class 1 pass\n");
   }
   fclose (fp);
 
}
 
/*****************************************************************************/
/*                                                                           */
/*  inc()  -   This function references the external variables and           */
/*             increments their values by 2.                                 */
/*                                                                           */
/*****************************************************************************/
inc ()
{
   in += 2;
   si += 2;
   li += 2;
   sh += 2;
   lg += 2;
   ch += 2;
   un += 2;
   ui += 2;
   us += 2;
   usi += 2;
   ul += 2;
   uli += 2;
   uc += 2;
   fl += 2.0;
   lf += 2.0;
   db += 2.0;
}
 
