/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Local Basic Types - Section 3.1.1                */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3112.c                               */
/*  Revisions :             03/19/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/21/85                                          */
/*  Descriptions :          For all basic types, defined and declared        */
/*                          (implicitly by context or explicitly using the   */
/*                          extern storage class specifier ) in the same     */
/*                          file:                                            */
/*                          Verify that the locations are initialized        */
/*                          correctly.                                       */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
int     fail;
 
int             in = 1;
short           sh = 2;
short int       si = 3;
long            lg = 4;
long int        li = 5;
char            ch = 'a';
 
unsigned                un = 6;
unsigned int            ui = 7;
unsigned short          us = 8;
unsigned short int      usi = 9;
unsigned long           ul = 10;
unsigned long int       uli = 11;
unsigned char           uc = 'b';
 
float           fl = 1.0;
long float      lf = (-5.4e-7);
double          db = 7.2e75;
 
main()
{
  int dummy;
  FILE *fp;
  fp=fopen("extn_res bloc=y","a");
{
    int in, sh, si, lg, li, ch;
 
      in = -1;
      sh = -2;
      si = -3;
      lg = -4;
      li = -5;
      ch = 5;
 
      {
         unsigned un, ui, us, usi, ul, uli, uc;
 
           un = -6;
           ui = -7;
           us = -8;
           usi = -9;
           ul = -10;
           uli = -11;
           uc = 11;
 
           {
              float fl, lf, db;
 
                 fl = -1.0;
                 lf = -2.0;
                 db = -3.0;
           }
 
           if ( fl != 1.0 || lf != (-5.4e-7) || db != 7.2e75 )
              { fail = TRUE;
                fprintf(fp,"  ** external, local basic types 3.1.1.2-1 class 1 fail      -  exit return code : %f%e%e\n", fl, lf, db );
                printf("  ** external, local basic types 3.1.1.2-1 class 1 fail      -  exit return code : %f%e%e\n", fl, lf, db );
              }
      }
 
      if ( un != 6  || ui != 7   || us != 8 || usi != 9 ||
           ul != 10 || uli != 11 || uc != 'b' )
         { fail = TRUE;
           fprintf(fp,"  ** external, local basic types 3.1.1.2-2 class 1 fail-  exit return code : %d%d%d%d%d%d%c\n",
                 un, ui, us, usi, ul, uli, uc );
            printf("  ** external, local basic types 3.1.1.2-2 class 1 fail-  exit return code : %d%d%d%d%d%d%c\n",
                 un, ui, us, usi, ul, uli, uc );
         }
  }
 
  if ( in != 1 || sh != 2 || si != 3 ||
       lg != 4 || li != 5 || ch != 'a' )
     { fail = TRUE;
       fprintf(fp,"  ** external, local basic types 3.1.1.2-3 class 1 fail - exit return code : %d%d%d%d%d%c\n",  in, sh, si, lg, li, ch );
       printf("  ** external, local basic types 3.1.1.2-3 class 1 fail - exit return code : %d%d%d%d%d%c\n",  in, sh, si, lg, li, ch );
     }
 
  if ( !fail )
    {fprintf(fp,"  .. external, local basic types 3.1.1.2 class 1 pass\n");
     printf("  .. external, local basic types 3.1.1.2 class 1 pass\n");}
  fclose(fp);
}
