/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Local Basic Types - Section 3.1.1                */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3111.c                               */
/*  Revisions :             03/19/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/21/85                                          */
/*  Descriptions :          For all basic types, defined and declared        */
/*                          (implicitly by context or explicitly using the   */
/*                          extern storage class specifier ) in the same     */
/*                          file:                                            */
/*                          Verify that space is allocated correctly and     */
/*                          that storage space persists from the point of    */
/*                          an identifier's definition to the end of the     */
/*                          file.                                            */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
int     fail;
 
/*  define and declare implicitly by context  */
 
int             in = 1;
short           sh = 2;
short int       si = 3;
long            lg = 4;
long int        li = 5;
char            ch = 'a';
 
unsigned                un = 6;
unsigned int            ui = 7;
unsigned short          us = 8;
unsigned short int      usi = 9;
unsigned long           ul = 10;
unsigned long int       uli = 11;
unsigned char           uc = 'b';
 
float           fl = 1.0;
long float      lf = (-5.4e-7);
double          db = 7.2e75;
 
FILE *fp;
main()
{
        fp=fopen("extn_res bloc=y","a");
        verify();
 
        if ( !fail )
          {fprintf(fp,"  .. external, local basic types 3.1.1.1 class 1 pass\n");
           printf("  .. external, local basic types 3.1.1.1 class 1 pass\n");}
        else
          {fprintf(fp,"  .. enternal, local basic types 3.1.1.1 class 1 fail\n");
           printf("  .. enternal, local basic types 3.1.1.1 class 1 fail\n");}
        fclose(fp);
}
 
 
verify()
{
        /*  declare explicitly using the
            extern storage class specifier
        */
 
        extern int       in;
        extern short     sh;
        extern short int si;
        extern long      lg;
        extern long int  li;
        extern char      ch;
 
        extern unsigned           un;
        extern unsigned int       ui;
        extern unsigned short     us;
        extern unsigned short int usi;
        extern unsigned long      ul;
        extern unsigned long int  uli;
        extern unsigned char      uc;
 
        extern float            fl;
        extern long float       lf;
        extern double           db;
 
 
        if ( in != 1   || sh != 2   || si != 3         || lg != 4    ||
             li != 5   || ch != 'a' || un != 6         || ui != 7    ||
             us != 8   || usi != 9  || ul != 10        || uli != 11  ||
             uc != 'b' || fl != 1.0 || lf != (-5.4e-7) || db != 7.2e75 )
           { fail = TRUE;
             fprintf(fp,"  ** external, local basic types 3.1.1.1 class 1 fail  -  exit return code : %d%d%d%d%d%c%d%d%d%d%d%d%c%f%e%e\n",
                   in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc,
                   fl, lf, db );
              printf("  ** external, local basic types 3.1.1.1 class 1 fail  -  exit return code : %d%d%d%d%d%c%d%d%d%d%d%d%c%f%e%e\n",
                   in, sh, si, lg, li, ch, un, ui, us, usi, ul, uli, uc,
                   fl, lf, db );
           }
}
