/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Assignment Operators                */
/*                          Section  4.1.7.1.3                               */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.41713.c                              */
/*  Revisions :             03/27/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the right operand is converted       */
/*                          to the type of the left operand before the       */
/*                          assignment is made.                              */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
/*      Test 1 was originally spr0226 written against UTX Release 2.0.       */
/*      Problem description:   The compiler has problems compiling           */
/*                             int += float and int -= float.                */
 
/*      Test 1          */
 
main()
{
        int     a = 3, b = 4;
        float   x = 2.0;
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
        a += x;
        b -= x;
 
        if ( a != 5 || b != 2 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.3 class 1 fail- exit return code : %d%d\n",a,b);
           printf("  ** expression, assignment operator 4.1.7.1.3 class 1 fail- exit return code : %d%d\n",a,b);
         }
 
        if ( !fail )
         {fprintf(fp,"  .. expression, assignment operator 4.1.7.1.3 class 1 pass\n");
          printf("  .. expression, assignment operator 4.1.7.1.3 class 1 pass\n");}
        fclose(fp);
}
