/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Operators                           */
/*                          Assignment Operators                             */
/*                          Section   4.1.7.1                                */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  4/11/85                                          */
/*  Source File :           source/expr.41712.c                              */
/*  Revisions :             03/30/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          04/11/85    Tina          UTX-32 (1.2) Release   */
/*                          -- added test for UTX/32(1.1) qar127             */
/*                                                                           */
/*  Description :           Basic Types for the following assignment         */
/*                          operators:                                       */
/*                          =  +=  -=  *=  /=  %=  >>=  <<=  &=  ^=  |=      */
/*                          Verify that the result of the assignment is      */
/*                          stored in object referred to by the left operand.*/
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*  Tests 1 thru 4 were originally spr129 written against UTX Release 2.0.   */
/*  Problem Description:  Improper assembler language output generated when  */
/*          the "-=" assignment operator is used with byte and halfword      */
/*          variables.                                                       */
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
FILE *fp;
fp=fopen("expr_res bloc=y","a");
 
 {
  char  a,*ptra;
  short b,*ptrb;
  int   c,*ptrc;
  long  d,*ptrd;
 
  a = b = c = d = 0;
 
  ptra = &a;
  ptrb = &b;
  ptrc = &c;
  ptrd = &d;
 
  /*    Test 1          byte variable           */
 
  if (( *ptra -= 1 ) >= 0 )
     { fail = TRUE;
       fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-1 class 1 fail - exit return code  :  %d\n", *ptra );
       printf("  ** expression, assignment operator 4.1.7.1.2-1 class 1 fail - exit return code  :  %d\n", *ptra );
     }
 
  /*    Test 2          halfword varible        */
 
  if (( *ptrb -= 1 ) >= 0 )
     { fail = TRUE;
       fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-2 class 1 fail -  exit return code  :  %d\n", *ptrb );
       printf("  ** expression, assignment operator 4.1.7.1.2-2 class 1 fail -  exit return code  :  %d\n", *ptrb );
     }
 
  /*    Test 3          word variable           */
 
  if (( *ptrc -= 1 ) >= 0 )
     { fail = TRUE;
       fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-3 class 1 fail exit return code  :  %d\n", *ptrc );
       printf("  ** expression, assignment operator 4.1.7.1.2-3 class 1 fail exit return code  :  %d\n", *ptrc );
     }
 
 /*     Test 4          longword variable       */
 
  if (( *ptrd -= 1 ) >= 0 )
     { fail = TRUE;
       fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-4 class 1 fail -  exit return code  :  %d\n", *ptrd );
       printf("  ** expression, assignment operator 4.1.7.1.2-4 class 1 fail -  exit return code  :  %d\n", *ptrd );
     }
 }
 
/*      Test 5 was originally qar60 written against UTX Release 2.0.         */
/*      Problem description:  The code generated for <ident1> (op)= <ident2> */
/*              is equivalent to <ident1> = <ident1> (op) <ident2>.  However,*/
/*              in the case where <ident1> is a character pointer and        */
/*              <ident2> is an unsigned integer the code generated has the   */
/*              form <ident1> = <ident2> (op) <ident1>. This is incorrect.   */
 
/*      Test 5          */
{
        char *ptr, *tmp;
        unsigned offset;
 
        ptr = "MOM";
        offset = 1;
        tmp = ptr;
 
        ptr -= offset;
        tmp = tmp - 1;
 
        if ( ptr != tmp )
          { fail = TRUE;
          fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-5 class 1 fail    - exit return code : %d\n", ptr );
          printf("  ** expression, assignment operator 4.1.7.1.2-5 class 1 fail    - exit return code : %d\n", ptr );
          }
 
}
/*   Tests 6 thru 10 were originally spr0010 written against UTX 2.0 Release. */
/*   Problem Description:  The compiler generates wrong code for the          */
/*           following operators when the operands are of type "register int".*/
/*           *=, <<=, >>=, /=, %=                                             */
{
        register int a, b, c;
 
        a = 3;
        b = 2;
        c = 1;
 
/*      Test 6          */
 
        a *= b;
        if ( a != 6 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-6 class 1 fail    - exit return code : %d\n", a );
           printf("  ** expression, assignment operator 4.1.7.1.2-6 class 1 fail    - exit return code : %d\n", a );
         }
 
/*      Test 7          */
 
        a = 3;
        a <<= b;
        if ( a != 12 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-7 class 1 fail  - exit return code : %d\n", a );
           printf("  ** expression, assignment operator 4.1.7.1.2-7 class 1 fail  - exit return code : %d\n", a );
         }
 
/*      Test 8          */
 
        a = 3;
        a >>= c;
        if ( a != 1 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-8 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, assignment operator 4.1.7.1.2-8 class 1 fail - exit return code : %d\n", a );
         }
 
/*      Test 9          */
 
        a = 3;
        a /= a;
        if ( a != 1 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-9 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, assignment operator 4.1.7.1.2-9 class 1 fail - exit return code : %d\n", a );
         }
 
/*      Test 10         */
 
        a = 3;
        a %= b;
        if ( a != 1 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, assignment operator 4.1.7.1.2-10 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, assignment operator 4.1.7.1.2-10 class 1 fail - exit return code : %d\n", a );
         }
 
/*      Test 11 was originally qar127 written against UTX/32 Release 1.1.    */
/*      Problem Description:  the compiler does not perform the "mod 32" on  */
/*              shift lengths.  If a user requests a shift of more that 31   */
/*              bits, the assembler error : "warning: op_shift: shift is too */
/*              long" is reported but there is no message form the compiler. */
/*              Test reporting for this test is reported separately from the */
/*              rest of the tests in this file.                              */
 
/*      Test 11         */
      {
        int x;
        x <<= 32;
      }
}
 
  if ( !fail )
    {fprintf(fp,"  .. expression, assignment operator 4.1.7.1.2 class 1 pass\n" );
     printf("  .. expression, assignment operator 4.1.7.1.2 class 1 pass\n" );}
  fclose(fp);
}
