/****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Operators                           */
/*                          Relational Operators                             */
/*                          Section  4.1.4                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.4143.c                               */
/*  Revisions :             03/19/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           For the relational and equality operators:       */
/*                          <  >  <=  >=  ==  !=                             */
/*                          Verify that all arithmetic types can be compared.*/
/*                          The compiler fails if this program will not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  Tests 1 thru 3 were originally qar12 written against UTX Release 1.0     */
 
/*  Problem Description:  When using the relationship operators with the     */
/*                        unmatched operand types of integer and float or    */
/*                        double, compiler errors occur.                     */
 
#include <stdio.h>
#define TRUE 1
int fail=0;
FILE *fp;
          
main()
{       
  fp=fopen("expr_res bloc=y","a");
 
        {
        int i;
        float x;
         x = 5.00;
         
        for ( i = 1; i < x; i++ );
 
        if ( i != 5 )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, relational operator 4.1.4.3-1 class 1 fail-  exit return code : %d\n",i );
                printf("  ** expression, relational operator 4.1.4.3-1 class 1 fail-  exit return code : %d\n",i );
        }
}
/*      Test 2       */
{
        int i;
        double x;
        x = 5.00;
 
        for ( i = 1; i < x; i++ );
 
        if ( i != 5 )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, relational operator 4.1.4.3-2 class 1 fail -  exit return code : %d\n",i );
                printf("  ** expression, relational operator 4.1.4.3-2 class 1 fail -  exit return code : %d\n",i );
        }
}
/*      Test 3       */
{
        int i;
        int x;
        x = 5.00;
 
        for ( i = 1; i < x; i++ );
 
        if ( i != 5 )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, relational operator 4.1.4.3-3 class 1 fail -  exit return code : %d\n",i );
                printf("  ** expression, relational operator 4.1.4.3-3 class 1 fail -  exit return code : %d\n",i );
        }
}
 
/*   Tests 4 thru 9 were originally spr0009 written against UTX Release 2.0.  */
/*   Problem Description:  Relational operators sometimes produce incorrect   */
/*           results when either operand is of type "unsigned short".         */
 
{
        unsigned short a;
        int b;
        float c;
        double d;
 
        a = 10;
        b = 20;
        c = 2.5;
        d = 10.0;
 
        if ( a == b )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational == operator 4.1.4.3-4 class 1 fail     - exit return code : %d\n", a );
           printf("  ** expression, relational == operator 4.1.4.3-4 class 1 fail     - exit return code : %d\n", a );
         }
        if ( a != d )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational != operator 4.1.4.3-5 class 1 fail  - exit return code : %d\n", a );
           printf("  ** expression, relational != operator 4.1.4.3-5 class 1 fail  - exit return code : %d\n", a );
         }
        if ( c > a )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational > operator 4.1.4.3-6 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, relational > operator 4.1.4.3-6 class 1 fail - exit return code : %d\n", a );
         }
        if ( c >= a )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational >= operator 4.1.4.3-7 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, relational >= operator 4.1.4.3-7 class 1 fail - exit return code : %d\n", a );
         }
        if ( a < c )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational < operator 4.1.4.3-8 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, relational < operator 4.1.4.3-8 class 1 fail - exit return code : %d\n", a );
         }
        if ( a <= c )
         { fail = TRUE;
           fprintf(fp,"  ** expression, relational <= operator 4.1.4.3-9 class 1 fail - exit return code : %d\n", a );
           printf("  ** expression, relational <= operator 4.1.4.3-9 class 1 fail - exit return code : %d\n", a );
         }
}
 
if ( !fail )
   {fprintf(fp,"  .. expression, relational operator 4.1.4.3 class 1 pass\n");
     printf("  .. expression, relational operator 4.1.4.3 class 1 pass\n");}
fclose(fp);
}
