/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Relational Operators               */
/*                          Section  4.1.4                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/expr.4142.c                               */
/*  Revisions :             05/08/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that two pointers can be compared and     */
/*                          that the result gives the relative positions     */
/*                          in the address space of the pointed to objects.  */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  UNIX System V Release 2.0 reported that the C compiler generates wrong
    code on pointer comparison.
*/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
        int  *a, *b;
        int  buf[11];
        int i;
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
        a = buf;            /*  pointers a and b both point    */
        b = buf;            /*  to the same array - buf        */
 
        for ( i = 0; i < 10; i++, b++ )
        {
                buf[i] = i;
        }
 
        b--;                /*  decrement pointer b to point to the 10th
                                        element of buf                             */
 
        if ( a > b || *a > *b )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, > operator 4.1.4.2-1 class 1 fail -  exit return code :  %d%d\n",
                    a>b, *a>*b );
                 printf("  ** expression, > operator 4.1.4.2-1 class 1 fail -  exit return code :  %d%d\n",
                    a>b, *a>*b );
        }
 
        if (  a >= b || *a >= *b )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, >= operator 4.1.4.2-2 class 1 fail -  exit return code :  %d%d\n",a>=b, *a>=*b );
                printf("  ** expression, >= operator 4.1.4.2-2 class 1 fail -  exit return code :  %d%d\n",a>=b, *a>=*b );
        }
 
        /*   alter the relative positions of the pointers which alters
             their values                                                    */
 
        a += 4;
        b -= 6;
 
        if ( a < b || *a < *b )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, < operator 4.1.4.2-3 class 1 fail -  exit return code : %d%d\n", a<b, *a<*b );
                printf("  ** expression, < operator 4.1.4.2-3 class 1 fail -  exit return code : %d%d\n", a<b, *a<*b );
        }
 
        if ( a <= b || *a <= *b )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, <= operator 4.1.4.2-4 class 1 fail -  exit return code : %d%d\n",a<=b, *a<=*b );
                printf("  ** expression, <= operator 4.1.4.2-4 class 1 fail -  exit return code : %d%d\n",a<=b, *a<=*b );
        }
 
        if ( a == b || *a == *b )
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, == operator 4.1.4.2-5 class 1 fail -  exit return code : %d%d\n",a==b, *a==*b );
                printf("  ** expression, == operator 4.1.4.2-5 class 1 fail -  exit return code : %d%d\n",a==b, *a==*b );
        }
 
        if ( a != b || *a != *b )
                ;
        else
        {
                fail = TRUE;
                fprintf(fp,"  ** expression, != operator 4.1.4.2-6 class 1 fail -  exit return code : %d%d\n",a!=b, *a!=*b );
                printf("  ** expression, != operator 4.1.4.2-6 class 1 fail -  exit return code : %d%d\n",a!=b, *a!=*b );
        }
 
        if ( !fail )
               {fprintf(fp,"  .. expression, relational operator 4.1.4.2 class 1 pass\n");
                printf("  .. expression, relational operator 4.1.4.2 class 1 pass\n");}
        fclose(fp);
}
