/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Relational operators               */
/*                          Section - 4.1.4.1                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4141.c                               */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/20/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added test for qar170 written against UTX-32. */
/*                                                                           */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify that the relational operator will yield   */
/*                          0 if the specified relation is false and 1       */
/*                          otherwise.                                       */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
 int  a,b;
 int  c,d,e,f,g,h;
 FILE *fp;
 fp=fopen("expr_res bloc=y","a");
 a = 1;
 b = 0;
 if ( a < b )
 {  fail = TRUE;
    fprintf(fp,"  ** expression, <  operators 4.1.4.1-1 class 1 fail -  exit return code : %d\n",a<b);
    printf("  ** expression, <  operators 4.1.4.1-1 class 1 fail -  exit return code : %d\n",a<b);
 }
 if ( a <= b )
 { fail = TRUE;
    fprintf(fp,"  ** expression, <= operators 4.1.4.1-2 class 1 fail -  exit return code : %d\n",a<=b);
    printf("  ** expression, <= operators 4.1.4.1-2 class 1 fail -  exit return code : %d\n",a<=b);
 }
 if ( a == b )
 { fail = TRUE;
    fprintf(fp,"  ** expression, == operators 4.1.4.1-3 class 1 fail -  exit return code : %d\n",a==b);
    printf("  ** expression, == operators 4.1.4.1-3 class 1 fail -  exit return code : %d\n",a==b);
 }
 if ( a > b )
    ;
 else
 {  fail = TRUE;
    fprintf(fp,"  ** expression, >  operators 4.1.4.1-4 class 1 fail -  exit return code : %d\n",a>b);
    printf("  ** expression, >  operators 4.1.4.1-4 class 1 fail -  exit return code : %d\n",a>b);
 }
 
 if ( a >= b )
    ;
 else
 {  fail = TRUE;
    fprintf(fp,"  ** expression, >= operators 4.1.4.1-5 class 1 fail -  exit return code : %d\n",a>=b);
    printf("  ** expression, >= operators 4.1.4.1-5 class 1 fail -  exit return code : %d\n",a>=b);
 }
 
 if ( a != b )
    ;
 else
 { fail = TRUE;
   fprintf(fp,"  ** expression, != operators 4.1.4.1-6 class 1 fail -  exit return code : %d\n",a!=b);
   printf("  ** expression, != operators 4.1.4.1-6 class 1 fail -  exit return code : %d\n",a!=b);
 }
 
/*      Tests 7 and 8 are qar170 written against UTX-32 1.0 Release.      */
/*      Tests 7 thru 12 were originally qar57 written against UTX 2.0.    */
 
/*      Problem Description:  A relational expression comparing two       */
/*                            integer constants where one constant is an  */
/*                            unsigned integer and the other constant an  */
/*                            integer always returns a true value when    */
/*                            the relational operator is < and <=.        */
 
 if ( c = ( unsigned ) 79 <= ( int ) 0 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, <= operator 4.1.4.1-7 class 1 fail -  exit return code : %d\n",  c );
   printf("  ** expression, <= operator 4.1.4.1-7 class 1 fail -  exit return code : %d\n",  c );
 }
 
 if ( d = ( unsigned ) 79 <  ( int ) 0 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, < operator 4.1.4.1-8 class 1 fail -  exit return code : %d\n",  d );
   printf("  ** expression, < operator 4.1.4.1-8 class 1 fail -  exit return code : %d\n",  d );
 }
 
 if ( e = ( int ) 0 == ( unsigned ) 79 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, == operator 4.1.4.1-9 class 1 fail -  exit return code : %d\n",  e );
   printf("  ** expression, == operator 4.1.4.1-9 class 1 fail -  exit return code : %d\n",  e );
 }
 
 if ( f = ( int ) 0 != ( unsigned ) 0 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, != operator 4.1.4.1-10 class 1 fail -  exit return code : %d\n",  f );
   printf("  ** expression, != operator 4.1.4.1-10 class 1 fail -  exit return code : %d\n",  f );
 }
 
 if ( g =  ( int ) 0 > ( unsigned) 79 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, > operator 4.1.4.1-11 class 1 fail -  exit return code : %d\n",  g );
   printf("  ** expression, > operator 4.1.4.1-11 class 1 fail -  exit return code : %d\n",  g );
 }
 
 if ( h = ( int ) 0  >= ( unsigned ) 79 )
 { fail = TRUE;
   fprintf(fp,"  ** expression, >= operator 4.1.4.1-12 class 1 fail - exit return code : %d\n",   h );
   printf("  ** expression, >= operator 4.1.4.1-12 class 1 fail - exit return code : %d\n",   h );
 }
 
 if ( !fail)
   {fprintf(fp,"  .. expression, relational operator 4.1.4.1 class 1 pass\n");
    printf("  .. expression, relational operator 4.1.4.1 class 1 pass\n");}
 fclose(fp);
 
 
}
