/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise logical operators          */
/*                          Section - 4.1.3.2                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4132.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/30/84    T. Aleksa    UTX-32  1.0 Release     */
/*                          -- Added test 5 for spr0044.                     */
/*                          -- Added test 6 for spr0230.                     */
/*                          04/26/84    T. Aleksa    UTX-32  1.0 Release     */
/*                          -- Test 6 is qar83  written against UTX-32 1.0.  */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify that the left-shift operator << will      */
/*                          left-shift the integral left operand by the      */
/*                          number of bit positions given by the integral    */
/*                          right operand.                                   */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE  1
int fail;
 
main ()
{             
  int test;                                     /* use to identify test no.*/
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
  /* Test 1 */
  {
    register int a,b;
    int          c;
    a = c =  2 ; b  = 3;
    a = a << b;
    c = c << 3;
    if ( a != 16 || b != 3 || c != 16 )
       {  fail = TRUE;
          fprintf(fp,"  ** expression, left shift 4.1.3.2-1 class 1 fail-  exit return code : %d%d%d\n",a,b,c);
          printf("  ** expression, left shift 4.1.3.2-1 class 1 fail-  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  /* Test 2 */
  {
    unsigned a,b,c;
    a = c = 2 ; b = 3;
    a = a << b;
    c = c << 3;
    if ( a != 16 || b != 3 || c != 16 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, left shift 4.1.3.2-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, left shift 4.1.3.2-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  /* Test 3 */
  {
    short  a,b,c;
    a = c =  2 ; b = 3;
    a = a << b;
    c = c << 3;
    if ( a != 16 || b != 3 || c != 16 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, left shift 4.1.3.2-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, left shift 4.1.3.2-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  /* Test 4 */
  {
   int a,b;
   a = -2; b = 3;
   a = a << b;
   if ( a != -16 )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, left shift 4.1.3.2-4 class 1 fail  -  exit return code : %d%d\n",a,b);
            printf("  ** expression, left shift 4.1.3.2-4 class 1 fail  -  exit return code : %d%d\n",a,b);
         }
  }
 
  /* Test 5 */
 
  /* The followng test was originally spr0044 written against UTX Release 2.0.
     Problem description:  Shifts by amount of type 'char' causes a compiler
                           error.                                             */
  {
   int i;
   char c;
 
   i = 1 << c;
   if ( i != 1 )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, left shift 4.1.3.2-5 class 1 fail -  exit return code : %d\n", i );
            printf("  ** expression, left shift 4.1.3.2-5 class 1 fail -  exit return code : %d\n", i );
         }
   }
 
  /* Test 6  */
 
  /* This following test was originally spr0230 written against UTX Release 2.0.
     Problem description:  Expression incorrectly sign extended.
 
     This test is presently qar83 written against UTX-32 1.0 Release.
     Problem description:  cc -O breaks programs which mix shorts and ints.
             The C object code improver is too enthusiastic about eliminating
             redundant moves.  The result is that short ints are not always
             properly sign-extended when they are converted to ints.
  */
 {
  short a, b;
  int i, j;
 
  a = 0x80;
  b = a << 8;
 
  i = b;       /* short to int  - sign extension occurs */
  j = a << 8;  /* short converted to int, left shift    */
 
  if ( i != ( -32768 ) || j != 32768 )
     { fail = TRUE;
       fprintf(fp,"  ** expression, left shift 4.1.3.2-6 class 1 fail - exit return code : %d%d\n", i, j );
       printf("  ** expression, left shift 4.1.3.2-6 class 1 fail - exit return code : %d%d\n", i, j );
     }
 }
 
  if ( !fail)
    {fprintf(fp,"  .. expression, left shift 4.1.3.2 class 1 pass\n");
     printf("  .. expression, left shift 4.1.3.2 class 1 pass\n");}
  fclose(fp);
}
 
