/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise Logical Operators          */
/*                          Section  4.1.3                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  6/20/84                                          */
/*  Source File :           source/expr.41313.c                              */
/*  Revisions :             06/15/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that signed right shifts work correctly.  */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  This test is qar401 written against UTX-32 1.0 Release.
 
    Problem Description:  Signed right shifts are often defective.
 
    Note:  For UTX-32 1.0 Release, right shifting a signed quantity should
           fill with sign bits.
*/
#include <stdio.h>
#define TRUE 1
int fail;
 
int sign, nosign;
char A_char;
short A_short;
int A_int;
 
main()
{
        register r, s, t;
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
/* Test 1 */
{
        r = (-1);
        A_char = 1;
 
        r >>= A_char;
        if ( r == 0xffffffff )
             sign++;
        else if ( r == 0x7fffffff )
                  nosign++;
             else
                 fail = TRUE;
}
/* Test 2 */
{
        s = (-1);
        A_short = 1;
 
        s >>= A_short;
        if ( s == 0xffffffff )
             sign++;
        else if ( s == 0x7fffffff )
                  nosign++;
             else
                 fail = TRUE;
}
/* Test 3 */
{
        t = (-1);
        A_int = 1;
 
        t >>= A_int;
        if ( t == 0xffffffff )
             sign++;
        else if ( t == 0x7fffffff )
                  nosign++;
             else
                 fail = TRUE;
}
if ( sign == 3 && !fail )
   { fprintf(fp,"  !! expression, >> op 4.1.3.1.3 class 2\n");
     printf("  !! expression, >> op 4.1.3.1.3 class 2\n");
     fprintf(fp,"     Right shifting a signed quantity filled with sign bits\n");
     printf("     Right shifting a signed quantity filled with sign bits\n");
   }
else if ( nosign == 3 && !fail )
     { fprintf(fp,"  !! expression, >> op 4.1.3.1.3 class 2\n");
       printf("  !! expression, >> op 4.1.3.1.3 class 2\n");
       fprintf(fp,"     Right shifting a signed quantity filled with 0-bits\n");
       printf("     Right shifting a signed quantity filled with 0-bits\n");
     }
     else
       {fprintf(fp,"  ** expression, >> op 4.1.3.1.3 class 2 fail exit return code : %x %x %x\n", r, s, t );
        printf("  ** expression, >> op 4.1.3.1.3 class 2 fail exit return code : %x %x %x\n", r, s, t );}
     fclose(fp);
}
