/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expression, Operators                            */
/*                          Arithmetic Operators                             */
/*                          Section  4.1.2                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  5/18/84                                          */
/*  Source File :           source/expr.4123.c                               */
/*  Revisions :             03/30/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*                          05/01/84    T. Aleksa     UTX-32 (1.0) Release   */
/*                          -- Added test for qar77 written on UTX-32 1.0.   */
/*                                                                           */
/*  Description :           Verify that binary % operator indicates modular  */
/*                          division and modular division works correctly    */
/*                          for all integral types.                          */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail=0;
char numbuf[20];
 
main()
{
 
 
FILE *fp;
/*      Test 1          */
 
/*      Test 1 is spr0128 written against UTX Release 2.0.
        Problem description:  The statement "n = n % (p->a + p->b);" causes
                a compilation error which states that "off1 and aut1 are
                undefined".  This error is a result of the C compiler
                running out of registers when it tries to process the "p->b"
                part of the statement.
*/
 
 
struct bla {
        int a ;
        int b ;
        } bb;
 
        struct bla *p = &bb;
        int n = 8;
        fp=fopen("expr_res bloc=y","a");
 
        p->a = 5;
        p->b = 2;
        n = n % ( p->a + p->b );
 
        if ( n != 1 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, modulus operator 4.1.2.3-1 class 1 fail exit return code  : %d\n", n );
           printf("  ** expression, modulus operator 4.1.2.3-1 class 1 fail exit return code  : %d\n", n );
         }
 
/*      Test 2          */
 
/*      Test 2 is qar77 written against UTX-32 1.0 Release.
        Problem description:  The following test works correctly when compiled
                without the optimizer, but when the optimizer is used the
                program aborts.  Inspection of the optimizer output showed a
                misplaced register to register move instruction, which appeared
                to be related to the statement containing a modulus op.
*/
 
         {
           int a;
           char *t;
 
           t = "34567";
 
           itos( 34567 );
 
           a = strcmp( numbuf, t );
           if ( a != 0 )
            { fail = TRUE;
              fprintf(fp,"  ** expression, modulus operator 4.1.2.3-2 class 1 fail exit return code : %d\n", a );
              printf("  ** expression, modulus operator 4.1.2.3-2 class 1 fail exit return code : %d\n", a );
            }
        }
 
        if ( !fail ){
           fprintf(fp,"  .. expression, modulus operator 4.1.2.3 class 1 pass\n");
           printf("  .. expression, modulus operator 4.1.2.3 class 1 pass\n");
           }
           fclose(fp);
}
 
itos( n )        /* referenced in test 2 */
 
/*      This function copies n into the character array numbuf.           */
 
{
        register char *abuf;
        register int a, i;
        int pr, d;
 
        abuf = numbuf;
        pr = 0;
        a = n;
 
        for ( i = 10000; i != 1; i /= 10 )
            { if ( pr |= ( d = a/i ) )
                 *abuf++ = d + '0';
                 a = a % i;           /* Test 2, qar77 - modulus op */
            }
 
        *abuf++ = a + '0';
        *abuf++ = 0;
}
 
strcmp(s, t)           /* referenced in test 2 */
char *s, *t;
 
/*    This function performs a string comparison and returns the following
      results:
                       if s <  t, return < 0
                       if s == t, return 0
                       if s >  t, return > 0
*/
{
       for ( ; *s == *t; s++, t++)
            if ( *s == '\0' )
               return (0);
        return ( *s - *t );
}
