/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Increment/Decrement operator       */
/*                          Section - 4.1.1.6                                */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4116.c                               */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                          05/08/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added prefix increment and decrement op-      */
/*                             erators in Test 4.1.1.6-8.                    */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify increment/decrement operators perform     */
/*                          their functionalism.                             */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define   TRUE   1
#define   FALSE  0
 
main()
{ FILE *fp;
 int x, sx ,                                   /* variable x and size of x */
      n, sn ;                                   /* variable n and size of n */
  char *s="Hello how are you ?";                /* initialize string s      */
  char *fs="Hell hw are yu ?";                  /* expected final result    */
  char c='o';                                   /* deleted character        */
  int  a[5];                                    /* an array                 */
  int  *p;                                      /* a pointer                */
  int fail = 0;                                 /* will be turned on if one */
                                                /* of the tests fails       */
 
  /* 4.1.1.6-1 verify prefix increment operator causes the value
               of an object to be incremented before using its value.
  */
  fp=fopen("expr_res bloc=y","a");
  n = 5;
  x = ++n;              /* n = n + 1 ; x = n; */
  if ( x != 6 || n != 6 )
  {  fail = TRUE;
     fprintf(fp,"  ** expression, increment operator 4.1.1.6-1 class 1 fail exit return code : %d%d\n",x,n);
     printf("  ** expression, increment operator 4.1.1.6-1 class 1 fail exit return code : %d%d\n",x,n);
  }
 
  /* 4.1.1.6-2 verify postfix increment operator causes the value
               of an object to be incremented after using its value.
  */
  n = 5;
  x = n++;                      /*  x = n ; n = n + 1; */
  if ( x != 5 || n != 6 )
  {  fail = TRUE;
     fprintf(fp,"  ** expression, increment operator 4.1.1.6-2 class 1 fail exit return code : %d%d\n",x,n);
     printf("  ** expression, increment operator 4.1.1.6-2 class 1 fail exit return code : %d%d\n",x,n);
  }
 
  /* 4.1.1.6-3 verify the result of the prefix decrement operator
               causes the value of an object to be decremented before
               using its value.
  */
  n = 5;
  x = --n;
  if ( x!= 4 || n != 4 )
  {  fail = TRUE;
     fprintf(fp,"  ** expression, decrement operator 4.1.1.6-3 class 1 fail exit return code : %d%d\n",x,n);
     printf("  ** expression, decrement operator 4.1.1.6-3 class 1 fail exit return code : %d%d\n",x,n);
  }
  /* 4.1.1.6-4 verify the result of the postfix decrement operator
               causes the value of an object to be decremented after
               using its value.
  */
  n = 5;
  x = n--;                         /* x = n ; n = n - 1 */
  if ( x != 5 || n != 4 )
  {  fail = TRUE;
     fprintf(fp,"  ** expression, decrement operator 4.1.1.6-4 class 1 fail exit return code : %d%d\n",x,n);
     printf("  ** expression, decrement operator 4.1.1.6-4 class 1 fail exit return code : %d%d\n",x,n);
  }
 
 
 
  /* 4.1.1.6-5 verify the result is the same type as the type of Long
               value expression.
  */
 
  if ( (sx = sizeof(x)) != (sn = sizeof(n)) && sx != 4 )
  {  fail = TRUE ;
     fprintf(fp,"  ** expression, operator 4.1.1.6-5 class 1 fail exit return code : %d%d\n",sx,sn);
     printf("  ** expression, operator 4.1.1.6-5 class 1 fail exit return code : %d%d\n",sx,sn);
  }
 
  /* 4.1.1.6-6 verify that increment and decrement operators can work
               when their operands are indices to arrays.
  */
  for ( x = n = 0; s[x] != '\0'; x++ )
      if ( s[x] != c)
         s[n++] = s[x];
  s[n] = '\0';
  if ( *s != *fs )
     { fail = TRUE;
       fprintf(fp,"  ** expression, operator 4.1.1.6-6 class 1 fail exit return code : %d\n",fail);
       printf("  ** expression, operator 4.1.1.6-6 class 1 fail exit return code : %d\n",fail);
     }
 
   /* 4.1.1.6-8 verify that increment and decrement operators when
                applied to a pointer to the next/previous object
                and this pointer is correctly offset from the
                original object.
   */
      /* initialize an array with 4 elements                    */
      for ( n=0; n <= 4; n++ )
          a[n]=n;
     /* set pointer pointing to each element                    */
     for ( n = 0, p = &a[0]; p <= &a[4]; n++, p++ ) /* postfix incrementation */
     {
       if ( *p != n )
          {  fail = TRUE;
           fprintf(fp,"  ** expression, increment operator 4.1.1.6-8.1 class 1 fail exit return code : %d\n",*p);
           printf("  ** expression, increment operator 4.1.1.6-8.1 class 1 fail exit return code : %d\n",*p);
          };
 
     }
     for ( n = 0, p = &a[0], p--; p <= &a[3]; n++ )
     {
       if ( *++p != n )                             /* prefix incrementation */
          {  fail = TRUE;
           fprintf(fp,"  ** expression, increment operator 4.1.1.6-8.2 class 1 fail exit return code : %d\n",*p);
           printf("  ** expression, increment operator 4.1.1.6-8.2 class 1 fail exit return code : %d\n",*p);
          };
     }
     for ( n = 4, p = &a[4]; p >= &a[0]; n--, p-- ) /* postfix decrementation */
     {
       if ( *p != n )
          { fail = TRUE;
           fprintf(fp,"  ** expression, decrement operator 4.1.1.6-8.3 class 1 fail exit return code : %d\n",*p);
           printf("  ** expression, decrement operator 4.1.1.6-8.3 class 1 fail exit return code : %d\n",*p);
          };
      }
     for ( n = 4, p = &a[5]; p >= &a[1]; n-- )
     {
       if ( *--p != n )                             /* prefix decrementation */
          { fail = TRUE;
           fprintf(fp,"  ** expression, decrement operator 4.1.1.6-8.4 class 1 fail exit return code : %d\n",*p);
           printf("  ** expression, decrement operator 4.1.1.6-8.4 class 1 fail exit return code : %d\n",*p);
          };
      }
 
if ( !fail ){
     fprintf(fp,"  .. expression, inc/dec operator 4.1.1.6 class 1 pass\n");
     printf("  .. expression, inc/dec operator 4.1.1.6 class 1 pass\n");
     }
     fclose(fp);
}
