 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Operators                           */
/*                          Unary Operators                                  */
/*                          Section  4.1.1                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.4113.c                              */
/*  Revisions :             03/20/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the result of the unary - operator   */
/*                          is to negate the value of its operand.           */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
double testd();
 
/*      Test 1 was originally qar48 written against UTX Release 2.0.         */
/*      Problem description:  The compiler complains about too complex an    */
/*              expression when the unary minus sign is used with an         */
/*              unsigned integer.                                            */
 
/*      Test 1          */
main()
{
FILE *fp;
fp=fopen("expr_res bloc=y","a");
 {
        int i;
        unsigned u;
 
        u = 3;
        i = -u;
 
        if ( i != ( -3 ) )
          { fail = TRUE;
            fprintf(fp,"  ** expression, unary operator 4.1.1.3-1 class 1 fail exit return code : %d\n", i );
            printf("  ** expression, unary operator 4.1.1.3-1 class 1 fail exit return code : %d\n", i );
          }
 }
 
/*      Test 2 was originally spr0008 written against UTX Release 2.0.       */
/*      Problem description:  Operator precedence using unary minus with     */
/*              double type produces compiler errors.                        */
 
/*      Test 2          */
 {
        double  x, y;
 
        x = 3.5;
        y = ( -3.5 );
 
        if ( testd ( x,y ) != 1 )
         { fail = TRUE;
           fprintf(fp,"  ** expression, unary operator 4.1.1.3-2 class 1 fail exit return code : %f\n", testd( x,y ) );
           printf("  ** expression, unary operator 4.1.1.3-2 class 1 fail exit return code : %f\n", testd( x,y ) );
         }
 }
       if ( !fail ) {
        fprintf(fp,"  .. expression, unary operator 4.1.1.3 class 1 pass\n");
        printf("  .. expression, unary operator 4.1.1.3 class 1 pass\n");
        }
        fclose(fp);
}
 
double testd ( x,y )
double x, y;
{
        return ( x==-y );  /* this statement tests the unary minus operator
                              precedence with double types for test 2      */
}
