/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initializations and Variable       */
/*                          Reference  -  Compound Statements                */
/*                          Section  - 2.9                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.292.c                                */
/*  Revisions :             03/11/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  3/18/85                                          */
/*  Descriptions :          For all basic types, arrays, structures, unions  */
/*                          and fields in block declarations :               */
/*                          Verify that basic types, arrays, structures,     */
/*                          unions and fields are initialized correctly      */
/*                          from the declaration.                            */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.29.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");    /* OPEN FILE FOR WRITTING RESULTS */
/*  Test 1  */
{
        int  a = 10, b = 20, c = 30;
 
        if ( a != 10 || b != 20 || c != 30 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-1 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-1 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 2  */
{
        short int a = 1, b = 2, c = a * b;
 
        if ( a != 1 || b != 2 || c != 2 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-2 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-2 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 3  */
{
        short  a = 3, b = 4, c = b/a;
 
        if ( a !=  3 || b != 4 || c != 1 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-3 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-3 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 4  */
{
        long  a = 0xffffffff, b = 7, c = ~a;
 
        if ( a != 0xffffffff || b != 7 || c != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-4 class 1 fail exit return code : %x%d%d\n", a, b, c);
             printf("  ** declaration, compound 2.9.2-4 class 1 fail exit return code : %x%d%d\n", a, b, c);
           }
}
/*  Test 5   */
{
        long int  a = 7, b = 5, c = a % b;
 
        if ( a != 7 || b != 5 || c != 2 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-5 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-5 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 6   */
{
        float  a = (-7.0), b = (-1.0), c = a - b;
 
        if ( a != (-7.0) || b != (-1.0) || c != (-6.0 ) )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-6 class 1 fail exit return code : %f%f%f\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-6 class 1 fail exit return code : %f%f%f\n", a, b, c );
           }
}
/*  Test 7   */
{
        long float  a = (-1.25), b = 3.33, c = 4.76;
 
        if ( a != (-1.25) || b != 3.33 || c != 4.76 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-7 class 1 fail exit return code : %f%f%f\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-7 class 1 fail exit return code : %f%f%f\n", a, b, c );
           }
}
/*  Test 8   */
{
        double  a = 1.000001, b = .023E+02, c = .005E+03;
 
        if ( a != 1.000001 || b != 2.3 || c != 5 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-8 class 1 fail exit return code : %f%f%f\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-8 class 1 fail exit return code : %f%f%f\n", a, b, c );
           }
}
/*  Test 9  */
{
        char a = 'a', b = 'z', c = '7';
 
        if ( a != 'a' || b != 'z' || c != '7' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-9 class 1 fail exit return code : %c%c%c\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-9 class 1 fail exit return code : %c%c%c\n", a, b, c );
           }
}
/*  Test 10  */
{
        unsigned  a = 22, b = 333, c = 4444;
 
        if ( a != 22 || b != 333 || c != 4444 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-10 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-10 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 11  */
{
        unsigned int  a = 10, *b = &a, c = 20;
 
        if ( a !=  10 || *b != 10 || c != 20 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-11 class 1 fail exit return code : %d%d%d\n", a, *b, c );
             printf("  ** declaration, compound 2.9.2-11 class 1 fail exit return code : %d%d%d\n", a, *b, c );
           }
}
/*  Test 12   */
{
        unsigned short  a = 0xffff, b = 25, c = 020;
 
        if ( a !=  0xffff || b != 031 || c != 16 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-12 class 1 fail exit return code : %x%d%o\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-12 class 1 fail exit return code : %x%d%o\n", a, b, c );
           }
}
/*  Test 13   */
{
        unsigned short int  a = 100, b = 200, c = 300;
 
        if ( a != 100 || b != 200 || c != 300 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-13 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-13 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 14   */
{
        unsigned long  a = 5,  b = 2, c = a ^ b;
 
        if ( a != 5 || b != 2 || c != 7 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-14 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-14 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 15   */
{
        unsigned long int a = 15, b = 20, c = a << 2;
 
        if ( a != 15 || b != 20 || c != 60 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-15 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-15 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 16   */
{
        unsigned char  a = 'a', b = a, c = b;
 
        if ( a !=  'a' || b != a || c != b )
          { fail = TRUE;
            fprintf(fp,"  ** declaration, compound 2.9.2-16 class 1 fail exit return code : %c%c%c\n", a, b, c );
            printf("  ** declaration, compound 2.9.2-16 class 1 fail exit return code : %c%c%c\n", a, b, c );
          }
}
/*  Test 17   */
{
/*  According to "The C Programming Language" by Kernighan & Ritchie, pg. 198,
    it is not permitted to initialize automatic aggregrates.  Therefore, the
    following structure is not initialized on the declaration.
*/
        struct test {
               int a;
               short b;
        } one;
 
        one.a = 1;
        one.b = one.a >> 2;
        if ( one.a != 1 || one.b != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-17 class 1 fail exit return code : %d%d\n", one.a, one.b );
             printf("  ** declaration, compound 2.9.2-17 class 1 fail exit return code : %d%d\n", one.a, one.b );
           }
}
/*  Test 18   */
{
/*  According to "The C Programming Language" by Kernighan & Ritchie, pg. 198,
    it is not permitted to initialize unions.
*/
        union test {
              float a;
              double b;
        } one;
 
        one.a = 1.0;
        if ( one.a != 1.0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-18 class 1 fail exit return code : %f\n", one.a );
             printf("  ** declaration, compound 2.9.2-18 class 1 fail exit return code : %f\n", one.a );
           }
}
/*  Test 19   */
{
/*  According to "The C Programming Language" by Kernighan & Ritchie, pg. 198,
    it is not permitted to initialize automatic aggregrates.  Therefore, the
    following fields are not initialized on the declaration.
*/
        struct test {
               unsigned a :  4;
               unsigned b :  4;
               unsigned c :  2;
        } boundry;
 
        boundry.a = 2;
        boundry.b = 4;
        boundry.c |= boundry.a ;
        if ( boundry.a != 2 || boundry.b != 4 || boundry.c != 2 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-19 class 1 fail exit return code : %d%d%d\n",boundry.a, boundry.b, boundry.c );
             printf("  ** declaration, compound 2.9.2-19 class 1 fail exit return code : %d%d%d\n",boundry.a, boundry.b, boundry.c );
           }
}
/*  Test 20  */
{
        register a = 1, b = 2, c = (a > b) ? a : b;
 
        if ( a != 1 || b != 2 || c != b )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-20 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-20 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
/*  Test 21  */
{
        register int a = 5, b = a, c = b;
 
        if ( a != 5 || b != a || c != b )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, compound 2.9.2-21 class 1 fail exit return code : %d%d%d\n", a, b, c );
             printf("  ** declaration, compound 2.9.2-21 class 1 fail exit return code : %d%d%d\n", a, b, c );
           }
}
        if ( !fail ){
           fprintf(fp,"  .. declaration, compound 2.9.2 class 1 pass\n");
           printf("  .. declaration, compound 2.9.2 class 1 pass\n");
           }
           fclose(fp);
}
