/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - Pointer Reference                  */
/*                          Section  - 2.8                                   */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/decl.2812.c                               */
/*  Revisions :             03/04/85    Sqa     Original UTX 1.2 Release     */
/*                          09/30/85    T. Aleksa        UTX-32(1.2) Release */
/*                                                                           */
/*  Date :                  10/1/85                                          */
/*  Descriptions :          For a pointer to all of the basic types, arrays  */
/*                          structures and unions:                           */
/*                          Verify that a static pointer declaration can be  */
/*                          initialized and that the pointer value can be    */
/*                          referenced.  The compiler fails if this program  */
/*                          cannot be compiled.                              */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*  Problem Description:  When a pointer is assigned the address of a double
                          dimension array, the compiler issues the erroneous
                          warning:  "illegal pointer combination".  The
                          assignment is legal and the warning should be
                          discarded.  This problem is a spr written against
                          UTX/32 1.1 Update A.
    Resolution 09/27/85:
    There is a minor error in the test case.  Specifically, the declaration
 
        static int *pa[2] = a;
 
    of the pointer "pa", should read as follows:
 
        static int (*pa)[2] = a;
 
    In the test case, the name "a" refers to an array of two objects, each of
    which is itself another array.  The expression "a[0]" is the first object.
    which is an array of two integers.  Likewise, the expression a[1] is a
    second array, also containing two integers.  The expressions a[0] and
    a[1] both have type "array of int"; the expression consisting only of the
    name "a", however has type "array of array of int".  These rules are
    described in Kernhigan and Ritchie on page 195.
 
    The usual arithmetic conversions in K & R describe which types may be
    automatically converted to other types in assignments and initializations.
    Specifically, page 185 of K & R states that if the type of an identifier
    is "array of something", it may be legally be assigned to an object
    of type "pointer to something", where the "somethings" are compatible,
    according to the usual arithmetic conversions.  For example, it is legal
    to assign an "array of int" value to an object of type "pointer to int".
    It is also legal to assign "array of array of int" to an object of type
    "pointer to array of int".  In my correction to the example, this is
    what I have done.  I declared the variable "pa" to be of type
    "pointer to array of 2 integers", which is compatible with the type of
    "a", which is "array of array of 2 integers".
 
*/
 
#include <stdio.h>
#define  TRUE  1;
 
int     fail;
 
/*  declare and initialize external static types
*/
 
static int                 ax = 1,  *pax = &ax;
static short               bx = 2,  *pbx = &bx;
static short int           cx = 3,  *pcx = &cx;
static long                dx = 4,  *pdx = &dx;
static long int            ex = 5,  *pex = &ex;
static float               fx = 6,  *pfx = &fx;
static long float          gx = 7,  *pgx = &gx;
static double              hx = 8,  *phx = &hx;
static char                ix = 9,  *pix = &ix;
static unsigned            jx = 10, *pjx = &jx;
static unsigned int        kx = 11, *pkx = &kx;
static unsigned short      lx = 12, *plx = &lx;
static unsigned short int  mx = 13, *pmx = &mx;
static unsigned long       nx = 14, *pnx = &nx;
static unsigned long int   ox = 15, *pox = &ox;
static unsigned char       px = 16, *ppx = &px;
 
static int onex[10] = { 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 }, *ponex = onex;
static int twox[5][5] = { { 1, 2, 3, 4, 5 },
                          { 6, 7, 8, 9, 0 } }, (*ptwox)[5] = twox;
 
static struct {
        int   aax;
        short bbx;
        short ccx;
} threex = { 10, 20, 30 }, *pthreex = &threex;
 
static union {
        float  i;
        double j;
} fourx, *pfourx = &fourx;
 
main()
{
FILE *fp;                    /* OPEN FILE FOR WRITTING RESULTS */
 
/*  declare and initialize internal static types
*/
 
static int                 a = 1,  *pa = &a;
static short               b = 2,  *pb = &b;
static short int           c = 3,  *pc = &c;
static long                d = 4,  *pd = &d;
static long int            e = 5,  *pe = &e;
static float               f = 6,  *pf = &f;
static long float          g = 7,  *pg = &g;
static double              h = 8,  *ph = &h;
static char                i = 9,  *pi = &i;
static unsigned            j = 10, *pj = &j;
static unsigned int        k = 11, *pk = &k;
static unsigned short      l = 12, *pl = &l;
static unsigned short int  m = 13, *pm = &m;
static unsigned long       n = 14, *pn = &n;
static unsigned long int   o = 15, *po = &o;
static unsigned char       p = 16, *pp = &p;
 
static int one[10] = { 10, 9, 8,7, 6, 5, 4, 3, 2, 1 }, *pone = one;
static int two[5][5] = { { 1, 2, 3, 4, 5 },
                         { 6, 7, 8, 9, 0 } }, (*ptwo)[5] = two;
 
static struct {
        int   aa;
        short bb;
        short cc;
} three = { 10, 20, 30 }, *pthree = &three;
 
static union {
        float  i;
        double j;
} four, *pfour = &four;
 
 
fp=fopen("decl_res bloc=y","a");
/*  Test 1  -  verify that the pointer value can be referenced for
               external static basic types.
*/
    if ( *pax != 1  || *pbx != 2  || *pcx != 3  || *pdx != 4 ||
         *pex != 5  || *pfx != 6  || *pgx != 7  || *phx != 8 ||
         *pix != 9  || *pjx != 10 || *pkx != 11 || *plx !=12 ||
         *pmx != 13 || *pnx != 14 || *pox != 15 || *ppx !=16  )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointer 2.8.1.2-1 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
             *pax, *pbx, *pcx, *pdx, *pex, *pfx, *pgx, *phx,*pix, *pjx, *pkx, *plx, *pmx, *pnx, *pox, *ppx );
         printf("  ** declaration, pointer 2.8.1.2-1 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
             *pax, *pbx, *pcx, *pdx, *pex, *pfx, *pgx, *phx,*pix, *pjx, *pkx, *plx, *pmx, *pnx, *pox, *ppx );
}
 
/*  Test 2  -  verify that the pointer value can be referenced for
               external static arrays, structures and unions.
*/
 
    fourx.i = 1.0;     /* initialize union */
 
    if ( *ponex != 10          || *(ponex + 5) != 5     ||
         *(ponex + 9)  != 1    || (*ptwox)[0] != 1      ||
         (*ptwox)[4] != 5      || (*ptwox)[7] != 8      ||
         (*ptwox)[9] != 0      || (*ptwox)[15] != 0     ||
         (*ptwox)[24] != 0     || pthreex->aax != 10    ||
         pthreex->bbx != 20    || pthreex->ccx != 30    ||
         pfourx->i != 1.0 )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointer 2.8.1.2-2 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%f\n",
             *ponex, *(ponex + 5), *(ponex + 9), (*ptwox), (*ptwox)[4],(*ptwox)[7], (*ptwox)[9], (*ptwox)[15], (*ptwox)[24],pthreex->aax, pthreex->bbx, pthreex->ccx, pfourx->i );
 
         printf("  ** declaration, pointer 2.8.1.2-2 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%f\n",
              *ponex, *(ponex + 5), *(ponex + 9), (*ptwox), (*ptwox)[4],(*ptwox)[7], (*ptwox)[9], (*ptwox)[15], (*ptwox)[24],pthreex->aax, pthreex->bbx, pthreex->ccx, pfourx->i );
 
}                
 
/*  Test 3  -  verify that the pointer value can be referenced for
               internal static basic types.
*/
    if ( *pa != 1  || *pb != 2  || *pc != 3  || *pd != 4 ||
         *pe != 5  || *pf != 6  || *pg != 7  || *ph != 8 ||
         *pi != 9  || *pj != 10 || *pk != 11 || *pl !=12 ||
         *pm != 13 || *pn != 14 || *po != 15 || *pp !=16  )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointer 2.8.1.2-3 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
             *pa, *pb, *pc, *pd, *pe, *pf, *pg, *ph,*pi, *pj, *pk, *pl, *pm, *pn, *po, *pp );
         printf("  ** declaration, pointer 2.8.1.2-3 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n",
             *pa, *pb, *pc, *pd, *pe, *pf, *pg, *ph,*pi, *pj, *pk, *pl, *pm, *pn, *po, *pp );
}
 
/*  Test 4  -  verify that the pointer value can be referenced for
               internal arrays, structures and unions.
*/
 
    four.i = 1.0;     /* initialize union */
 
    if ( *pone != 10        || *(pone + 5) != 5   || *(pone + 9) != 1    ||
         (*ptwo)[0] != 1    || (*ptwo)[4] != 5    || (*ptwo)[7]  != 8    ||
         (*ptwo)[9] != 0    || (*ptwo)[15] != 0   || (*ptwo)[24] != 0    ||
         pthree->aa != 10   || pthree->bb != 20   || pthree->cc != 30    ||
         pfour->i != 1.0 )
       { fail = TRUE;
         fprintf(fp,"  ** declaration, pointer 2.8.1.2-4 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%f\n",
         *pone, *(pone + 5), *(pone + 9), (*ptwo)[0], (*ptwo)[4],(*ptwo)[7], (*ptwo)[9], (*ptwo)[15], (*ptwo)[24],pthree->aa, pthree->bb, pthree->cc, pfour->i );
         
         printf("  ** declaration, pointer 2.8.1.2-4 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d%f\n",
         *pone, *(pone + 5), *(pone + 9), (*ptwo)[0], (*ptwo)[4],(*ptwo)[7], (*ptwo)[9], (*ptwo)[15], (*ptwo)[24],pthree->aa, pthree->bb, pthree->cc, pfour->i );
}
 
   if (!fail){
        fprintf(fp,"  .. declaration, pointer 2.8.1.2 class 1 pass\n");
        printf("  .. declaration, pointer 2.8.1.2 class 1 pass\n");
        }
        fclose(fp);
 
}
