/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Enumerations                         */
/*                          Section  2.5                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.256.c                                */
/*  Revisions :             05/31/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the objects of a given enumeration   */
/*                          type are regarded as having a type distinct      */
/*                          from objects of other enumeration types.         */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.25.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
/*  The compiler should generate a warning for this test, indicating that
    there is an enumeration type clash, operator ( = ) and operator ( != ).
    This should be a warning and not an error because the assignment simply
    assigns a constant to the identifier which does not result in adverse
    effect.
 
 
    Syntax:     enum identifier { enum-list }
                enum identifier
                enum identifier { enum-list }
                enum identifier
*/
 
enum colors { red, blue, green, yellow };
enum colors color;
enum fruits { apple, orange, peach, pear };
enum fruits fruit;
 
main()
{
 
FILE *fp;
fp=fopen("decl_res bloc=y","a");
/*     assign type fruits, identifier orange to conflicting
       enumeration type color.
*/
 
color = orange;
 
if ( color != orange ) {
     fprintf(fp,"  ** declaration, enumeration 2.5.6 class 3 fail exit return code : %d\n", color );
     printf("  ** declaration, enumeration 2.5.6 class 3 fail exit return code : %d\n", color );
     }
 else
  {
   fprintf(fp,"  .. declaration, enumeration 2.5.6 class 3 pass\n");
   printf("  .. declaration, enumeration 2.5.6 class 3 pass\n");
  }
 
fclose(fp);
 
 
}
