/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Union Reference                      */
/*                          Section  2.4.3                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2433.c                               */
/*  Revisions :             05/25/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that structure members of a union can     */
/*                          be referenced.                                   */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
#define WHOL 1
#define RETAL 2
 
int fail=0, stype;
 
union units {
        char  wholesale;
        char  retail;
        struct distribution {
               float amount;
               int   quantity;
               float total;
               char  type;
        }price;
}type;
 
union units dist(), a, b;
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
 
/* Test 1 */
 
        stype = WHOL;
        type.wholesale = 'w';
        a = dist( type, stype );
 
        if ( a.price.amount != 25.0 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %f\n", a.price.amount );
             printf("  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %f\n", a.price.amount );
           }
 
        if ( a.price.quantity != 1000 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %d\n", a.price.quantity );
             printf("  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %d\n", a.price.quantity );
           }
 
        if ( a.price.total != 25000.00 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %f\n", a.price.total );
             printf("  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %f\n", a.price.total );
           }
 
        if ( a.price.type != 'w' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %c\n", a.price.type );
             printf("  ** declaration, unions 2.4.3.3-1 class 2 fail exit return code : %c\n", a.price.type );
           }
 
/* Test 2 */
 
        stype = RETAL;
        type.retail = 'r';
        b = dist( type, stype );
 
        if ( b.price.amount != 50.50 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %f\n", b.price.amount );
             printf("  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %f\n", b.price.amount );
           }
 
        if ( b.price.quantity != 500 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %d\n", b.price.quantity );
             printf("  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %d\n", b.price.quantity );
           }
 
        if ( b.price.total != 25250.00 )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %f\n", b.price.total );
             printf("  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %f\n", b.price.total );
           }
 
        if ( b.price.type != 'r' )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %c\n", b.price.type );
             printf("  ** declaration, unions 2.4.3.3-2 class 2 fail exit return code : %c\n", b.price.type );
           }
 
        if ( !fail ){
           fprintf(fp,"  .. declaration, unions 2.4.3.3 class 2 pass\n" );
           printf("  .. declaration, unions 2.4.3.3 class 2 pass\n" );
           }
           fclose(fp);
}
/*  This subroutine returns a union of type units to main after
    assigning values to the structure price within the union.
*/
union units dist( value, stype )
union units value;
int stype;
{
        if ( stype == WHOL )
           { value.price.amount = 25.0;
             value.price.quantity = 1000;
             value.price.type = 'w';
           }
        else
           if ( stype == RETAL )
              { value.price.amount = 50.50;
                value.price.quantity = 500;
                value.price.type = 'r';
              }
 
 
        value.price.total = value.price.amount * value.price.quantity;
        return( value );
}
